/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.stats.BaseMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class LimbMaterialStats
extends BaseMaterialStats
implements IRepairableMaterialStats {
    public static final MaterialStatsId ID = new MaterialStatsId(TConstruct.getResource("limb"));
    public static final LimbMaterialStats DEFAULT = new LimbMaterialStats(1, 0.0f, 0.0f, 0.0f);
    static final String ACCURACY_PREFIX = LimbMaterialStats.makeTooltipKey(TConstruct.getResource("accuracy"));
    static final String DRAW_SPEED_PREFIX = LimbMaterialStats.makeTooltipKey(TConstruct.getResource("draw_speed"));
    static final String VELOCITY_PREFIX = LimbMaterialStats.makeTooltipKey(TConstruct.getResource("velocity"));
    private static final List<class_2561> DESCRIPTION = ImmutableList.of((Object)ToolStats.DURABILITY.getDescription(), (Object)ToolStats.DRAW_SPEED.getDescription(), (Object)ToolStats.VELOCITY.getDescription(), (Object)ToolStats.ATTACK_DAMAGE.getDescription());
    private final int durability;
    private final float drawSpeed;
    private final float velocity;
    private final float accuracy;

    public LimbMaterialStats(class_2540 buffer) {
        this.durability = buffer.readInt();
        this.drawSpeed = buffer.readFloat();
        this.velocity = buffer.readFloat();
        this.accuracy = buffer.readFloat();
    }

    @Override
    public void encode(class_2540 buffer) {
        buffer.writeInt(this.durability);
        buffer.writeFloat(this.drawSpeed);
        buffer.writeFloat(this.velocity);
        buffer.writeFloat(this.accuracy);
    }

    @Override
    public MaterialStatsId getIdentifier() {
        return ID;
    }

    @Override
    public List<class_2561> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(ToolStats.DURABILITY.formatValue(this.durability));
        info.add(IToolStat.formatColoredBonus(DRAW_SPEED_PREFIX, this.drawSpeed, 0.5f));
        info.add(IToolStat.formatColoredBonus(VELOCITY_PREFIX, this.velocity, 0.5f));
        info.add(IToolStat.formatColoredBonus(ACCURACY_PREFIX, this.accuracy, 0.5f));
        return info;
    }

    @Override
    public List<class_2561> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    public LimbMaterialStats(int durability, float drawSpeed, float velocity, float accuracy) {
        this.durability = durability;
        this.drawSpeed = drawSpeed;
        this.velocity = velocity;
        this.accuracy = accuracy;
    }

    @Override
    public int getDurability() {
        return this.durability;
    }

    public float getDrawSpeed() {
        return this.drawSpeed;
    }

    public float getVelocity() {
        return this.velocity;
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LimbMaterialStats)) {
            return false;
        }
        LimbMaterialStats other = (LimbMaterialStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDurability() != other.getDurability()) {
            return false;
        }
        if (Float.compare(this.getDrawSpeed(), other.getDrawSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getVelocity(), other.getVelocity()) != 0) {
            return false;
        }
        return Float.compare(this.getAccuracy(), other.getAccuracy()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LimbMaterialStats;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDurability();
        result = result * 59 + Float.floatToIntBits(this.getDrawSpeed());
        result = result * 59 + Float.floatToIntBits(this.getVelocity());
        result = result * 59 + Float.floatToIntBits(this.getAccuracy());
        return result;
    }

    public String toString() {
        return "LimbMaterialStats(durability=" + this.getDurability() + ", drawSpeed=" + this.getDrawSpeed() + ", velocity=" + this.getVelocity() + ", accuracy=" + this.getAccuracy() + ")";
    }
}

