/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.stats.BaseMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.IToolStat;

public class HandleMaterialStats
extends BaseMaterialStats {
    public static final MaterialStatsId ID = new MaterialStatsId(TConstruct.getResource("handle"));
    public static final HandleMaterialStats DEFAULT = new HandleMaterialStats(1.0f, 1.0f, 1.0f, 1.0f);
    private static final String DURABILITY_PREFIX = HandleMaterialStats.makeTooltipKey(TConstruct.getResource("durability"));
    private static final String ATTACK_DAMAGE_PREFIX = HandleMaterialStats.makeTooltipKey(TConstruct.getResource("attack_damage"));
    private static final String ATTACK_SPEED_PREFIX = HandleMaterialStats.makeTooltipKey(TConstruct.getResource("attack_speed"));
    private static final String MINING_SPEED_PREFIX = HandleMaterialStats.makeTooltipKey(TConstruct.getResource("mining_speed"));
    private static final class_2561 DURABILITY_DESCRIPTION = HandleMaterialStats.makeTooltip(TConstruct.getResource("handle.durability.description"));
    private static final class_2561 ATTACK_DAMAGE_DESCRIPTION = HandleMaterialStats.makeTooltip(TConstruct.getResource("handle.attack_damage.description"));
    private static final class_2561 ATTACK_SPEED_DESCRIPTION = HandleMaterialStats.makeTooltip(TConstruct.getResource("handle.attack_speed.description"));
    private static final class_2561 MINING_SPEED_DESCRIPTION = HandleMaterialStats.makeTooltip(TConstruct.getResource("handle.mining_speed.description"));
    private static final List<class_2561> DESCRIPTION = ImmutableList.of((Object)DURABILITY_DESCRIPTION, (Object)ATTACK_DAMAGE_DESCRIPTION, (Object)ATTACK_SPEED_DESCRIPTION, (Object)MINING_SPEED_DESCRIPTION);
    private final float durability;
    private final float miningSpeed;
    private final float attackSpeed;
    private final float attackDamage;

    public HandleMaterialStats(class_2540 buffer) {
        this.durability = buffer.readFloat();
        this.attackDamage = buffer.readFloat();
        this.attackSpeed = buffer.readFloat();
        this.miningSpeed = buffer.readFloat();
    }

    @Override
    public void encode(class_2540 buffer) {
        buffer.writeFloat(this.durability);
        buffer.writeFloat(this.attackDamage);
        buffer.writeFloat(this.attackSpeed);
        buffer.writeFloat(this.miningSpeed);
    }

    @Override
    public MaterialStatsId getIdentifier() {
        return ID;
    }

    @Override
    public List<class_2561> getLocalizedInfo() {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add(HandleMaterialStats.formatDurability(this.durability));
        list.add(HandleMaterialStats.formatAttackDamage(this.attackDamage));
        list.add(HandleMaterialStats.formatAttackSpeed(this.attackSpeed));
        list.add(HandleMaterialStats.formatMiningSpeed(this.miningSpeed));
        return list;
    }

    @Override
    public List<class_2561> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    public static class_2561 formatDurability(float quality) {
        return IToolStat.formatColoredMultiplier(DURABILITY_PREFIX, quality);
    }

    public static class_2561 formatAttackDamage(float quality) {
        return IToolStat.formatColoredMultiplier(ATTACK_DAMAGE_PREFIX, quality);
    }

    public static class_2561 formatAttackSpeed(float quality) {
        return IToolStat.formatColoredMultiplier(ATTACK_SPEED_PREFIX, quality);
    }

    public static class_2561 formatMiningSpeed(float quality) {
        return IToolStat.formatColoredMultiplier(MINING_SPEED_PREFIX, quality);
    }

    public float getDurability() {
        return this.durability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public HandleMaterialStats(float durability, float miningSpeed, float attackSpeed, float attackDamage) {
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.attackSpeed = attackSpeed;
        this.attackDamage = attackDamage;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandleMaterialStats)) {
            return false;
        }
        HandleMaterialStats other = (HandleMaterialStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Float.compare(this.getDurability(), other.getDurability()) != 0) {
            return false;
        }
        if (Float.compare(this.getMiningSpeed(), other.getMiningSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getAttackSpeed(), other.getAttackSpeed()) != 0) {
            return false;
        }
        return Float.compare(this.getAttackDamage(), other.getAttackDamage()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HandleMaterialStats;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Float.floatToIntBits(this.getDurability());
        result = result * 59 + Float.floatToIntBits(this.getMiningSpeed());
        result = result * 59 + Float.floatToIntBits(this.getAttackSpeed());
        result = result * 59 + Float.floatToIntBits(this.getAttackDamage());
        return result;
    }

    public String toString() {
        return "HandleMaterialStats(durability=" + this.getDurability() + ", miningSpeed=" + this.getMiningSpeed() + ", attackSpeed=" + this.getAttackSpeed() + ", attackDamage=" + this.getAttackDamage() + ")";
    }

    public HandleMaterialStats withDurability(float durability) {
        return this.durability == durability ? this : new HandleMaterialStats(durability, this.miningSpeed, this.attackSpeed, this.attackDamage);
    }

    public HandleMaterialStats withMiningSpeed(float miningSpeed) {
        return this.miningSpeed == miningSpeed ? this : new HandleMaterialStats(this.durability, miningSpeed, this.attackSpeed, this.attackDamage);
    }

    public HandleMaterialStats withAttackSpeed(float attackSpeed) {
        return this.attackSpeed == attackSpeed ? this : new HandleMaterialStats(this.durability, this.miningSpeed, attackSpeed, this.attackDamage);
    }

    public HandleMaterialStats withAttackDamage(float attackDamage) {
        return this.attackDamage == attackDamage ? this : new HandleMaterialStats(this.durability, this.miningSpeed, this.attackSpeed, attackDamage);
    }
}

