/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2444;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.worktable.AbstractSizedIngredientRecipeBuilder;
import slimeknights.tconstruct.library.recipe.worktable.AbstractWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;

public class EnchantmentConvertingRecipe
extends AbstractWorktableRecipe {
    private static final String BASE_KEY = TConstruct.makeTranslationKey("recipe", "enchantment_converting");
    private static final class_2561 DESCRIPTION_LOST = TConstruct.makeTranslation("recipe", "enchantment_converting.description.lost");
    private static final class_2561 DESCRIPTION_KEEP = TConstruct.makeTranslation("recipe", "enchantment_converting.description.keep");
    private static final class_2561 NO_ENCHANTMENT = TConstruct.makeTranslation("recipe", "enchantment_converting.no_enchantments");
    private static final RecipeResult<ToolStack> TOO_FEW = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "enchantment_converting.too_few"), new Object[0]);
    private final String name;
    private final class_2561 title;
    private final boolean matchBook;
    private final boolean returnInput;
    private final IJsonPredicate<ModifierId> modifierPredicate;
    private List<ModifierEntry> displayModifiers;
    private static List<class_1799> ALL_ENCHANTABLE_TOOLS;

    public EnchantmentConvertingRecipe(class_2960 id, String name, List<SizedIngredient> inputs, boolean matchBook, boolean returnInput, IJsonPredicate<ModifierId> modifierPredicate) {
        super(id, inputs);
        this.name = name;
        this.title = class_2561.method_43471((String)(BASE_KEY + "." + name + ".title"));
        this.matchBook = matchBook;
        this.returnInput = returnInput;
        this.modifierPredicate = modifierPredicate;
    }

    private Map<class_1887, Integer> getEnchantments(class_1799 stack) {
        return class_1890.method_22445((class_2499)(this.matchBook ? class_1772.method_7806((class_1799)stack) : stack.method_7921()));
    }

    @Override
    public class_2561 getDescription(@Nullable ITinkerableContainer inv) {
        if (inv != null && this.getEnchantments(inv.getTinkerableStack()).entrySet().stream().noneMatch(entry -> {
            Modifier modifier = ModifierManager.INSTANCE.get((class_1887)entry.getKey());
            return modifier != null && this.modifierPredicate.matches((Object)modifier.getId());
        })) {
            return NO_ENCHANTMENT;
        }
        return this.returnInput ? DESCRIPTION_KEEP : DESCRIPTION_LOST;
    }

    @Override
    public boolean matches(ITinkerableContainer inv, class_1937 world) {
        class_1799 tool = inv.getTinkerableStack();
        if (this.matchBook ? !tool.method_31574(class_1802.field_8598) : !tool.method_7909().method_7870(tool)) {
            return false;
        }
        return ModifierRecipe.checkMatch(inv, this.inputs);
    }

    @Override
    public List<ModifierEntry> getModifierOptions(@Nullable ITinkerableContainer inv) {
        if (inv != null) {
            return this.getEnchantments(inv.getTinkerableStack()).entrySet().stream().map(entry -> {
                Modifier modifier = ModifierManager.INSTANCE.get((class_1887)entry.getKey());
                if (modifier != null && this.modifierPredicate.matches((Object)modifier.getId())) {
                    return new ModifierEntry(modifier, (int)((Integer)entry.getValue()));
                }
                return null;
            }).filter(Objects::nonNull).toList();
        }
        if (this.displayModifiers == null) {
            this.displayModifiers = ModifierRecipeLookup.getAllRecipeModifiers().filter(modifier -> this.modifierPredicate.matches((Object)modifier.getId())).map(mod -> new ModifierEntry((Modifier)mod, 1)).toList();
        }
        return this.displayModifiers;
    }

    @Override
    public RecipeResult<ToolStack> getResult(ITinkerableContainer inv, ModifierEntry modifier) {
        int level = modifier.getLevel();
        if (level > 1) {
            int used = -1;
            block0: for (SizedIngredient ingredient : this.inputs) {
                for (int i = 0; i < inv.getInputCount(); ++i) {
                    class_1799 stack;
                    if (i == used || (stack = inv.getInput(i)).method_7960() || ingredient.getAmountNeeded() * level > stack.method_7947() || !ingredient.test(stack)) continue;
                    used = i;
                    continue block0;
                }
                return TOO_FEW;
            }
        }
        return RecipeResult.success(ToolStack.from(ModifierCrystalItem.withModifier(modifier.getId())));
    }

    @Override
    public int toolResultSize(ITinkerableContainer inv, ModifierEntry selected) {
        return selected.getLevel();
    }

    @Override
    public void updateInputs(IToolStackView result, ITinkerableContainer.Mutable inv, ModifierEntry selected, boolean isServer) {
        for (int i = 0; i < selected.getLevel(); ++i) {
            ModifierRecipe.updateInputs(inv, this.inputs);
        }
        if (this.returnInput && isServer) {
            class_1799 unenchanted;
            class_1799 current = inv.getTinkerableStack();
            if (this.matchBook) {
                unenchanted = new class_1799((class_1935)class_1802.field_8529);
                if (current.method_7938()) {
                    unenchanted.method_7977(current.method_7964());
                }
            } else {
                unenchanted = current.method_7972();
                class_1890.method_8214(this.getEnchantments(unenchanted).entrySet().stream().filter(entry -> ((class_1887)entry.getKey()).method_8195()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), (class_1799)unenchanted);
            }
            inv.giveItem(unenchanted);
        }
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.enchantmentConvertingSerializer.get();
    }

    @Override
    public boolean isModifierOutput() {
        return true;
    }

    @Override
    public List<class_1799> getInputTools() {
        if (!this.matchBook) {
            return EnchantmentConvertingRecipe.getAllEnchantableTools();
        }
        if (this.tools == null) {
            Set modifiers = this.getModifierOptions(null).stream().map(ModifierEntry::getId).collect(Collectors.toSet());
            this.tools = ModifierManager.INSTANCE.getEquivalentEnchantments(modifiers::contains).flatMap(enchantment -> IntStream.rangeClosed(1, enchantment.method_8183()).mapToObj(level -> class_1772.method_7808((class_1889)new class_1889(enchantment, level)))).toList();
        }
        return this.tools;
    }

    private static List<class_1799> getAllEnchantableTools() {
        if (ALL_ENCHANTABLE_TOOLS == null) {
            ALL_ENCHANTABLE_TOOLS = class_7923.field_41178.method_10220().map(item -> {
                class_1799 stack;
                if (item != class_1802.field_8529 && (stack = new class_1799((class_1935)item)).method_7923()) {
                    return stack;
                }
                return class_1799.field_8037;
            }).filter(stack -> !stack.method_7960()).toList();
        }
        return ALL_ENCHANTABLE_TOOLS;
    }

    @Override
    public class_2561 getTitle() {
        return this.title;
    }

    public static class Builder
    extends AbstractSizedIngredientRecipeBuilder<Builder> {
        private final String name;
        private final boolean matchBook;
        private boolean returnInput = false;
        private IJsonPredicate<ModifierId> modifierPredicate = ModifierPredicate.ALWAYS;

        public Builder returnInput() {
            this.returnInput = true;
            return this;
        }

        public void save(Consumer<class_2444> consumer) {
            this.save(consumer, TConstruct.getResource(this.name));
        }

        public void save(Consumer<class_2444> consumer, class_2960 id) {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("Must have at least one input");
            }
            class_2960 advancementId = this.buildOptionalAdvancement(id, "modifiers");
            consumer.accept((class_2444)new Finished(id, advancementId));
        }

        private Builder(String name, boolean matchBook) {
            this.name = name;
            this.matchBook = matchBook;
        }

        public static Builder converting(String name, boolean matchBook) {
            return new Builder(name, matchBook);
        }

        public Builder modifierPredicate(IJsonPredicate<ModifierId> modifierPredicate) {
            this.modifierPredicate = modifierPredicate;
            return this;
        }

        private class Finished
        extends AbstractSizedIngredientRecipeBuilder.SizedFinishedRecipe {
            public Finished(@Nullable class_2960 ID, class_2960 advancementID) {
                super(ID, advancementID);
            }

            @Override
            public void method_10416(JsonObject json) {
                json.addProperty("name", Builder.this.name);
                super.method_10416(json);
                json.addProperty("match_book", Boolean.valueOf(Builder.this.matchBook));
                json.addProperty("return_unenchanted", Boolean.valueOf(Builder.this.returnInput));
                json.add("modifier_predicate", ModifierPredicate.LOADER.serialize(Builder.this.modifierPredicate));
            }

            public class_1865<?> method_17800() {
                return (class_1865)TinkerModifiers.enchantmentConvertingSerializer.get();
            }
        }
    }

    public static class Serializer
    extends LoggingRecipeSerializer<EnchantmentConvertingRecipe> {
        public EnchantmentConvertingRecipe fromJson(class_2960 id, JsonObject json) {
            String name = class_3518.method_15265((JsonObject)json, (String)"name");
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            boolean matchBook = class_3518.method_15270((JsonObject)json, (String)"match_book");
            boolean returnInput = class_3518.method_15270((JsonObject)json, (String)"return_unenchanted");
            IJsonPredicate modifierPredicate = (IJsonPredicate)ModifierPredicate.LOADER.getAndDeserialize(json, "modifier_predicate");
            return new EnchantmentConvertingRecipe(id, name, ingredients, matchBook, returnInput, (IJsonPredicate<ModifierId>)modifierPredicate);
        }

        @Nullable
        public EnchantmentConvertingRecipe fromNetworkSafe(class_2960 id, class_2540 buffer) {
            String name = buffer.method_10800(Short.MAX_VALUE);
            int size = buffer.method_10816();
            ImmutableList.Builder ingredients = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                ingredients.add((Object)SizedIngredient.read((class_2540)buffer));
            }
            boolean matchBook = buffer.readBoolean();
            boolean returnInput = buffer.readBoolean();
            IJsonPredicate modifierPredicate = (IJsonPredicate)ModifierPredicate.LOADER.fromNetwork(buffer);
            return new EnchantmentConvertingRecipe(id, name, (List<SizedIngredient>)ingredients.build(), matchBook, returnInput, (IJsonPredicate<ModifierId>)modifierPredicate);
        }

        public void toNetworkSafe(class_2540 buffer, EnchantmentConvertingRecipe recipe) {
            buffer.method_10814(recipe.name);
            buffer.method_10804(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
            buffer.writeBoolean(recipe.matchBook);
            buffer.writeBoolean(recipe.returnInput);
            ModifierPredicate.LOADER.toNetwork(recipe.modifierPredicate, buffer);
        }
    }
}

