/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;

public class ConductingModifier
extends Modifier
implements ConditionalStatModifierHook {
    private static final class_2561 ATTACK_DAMAGE = TConstruct.makeTranslation("modifier", "conducting.attack_damage");
    private static final int MAX_BONUS_TICKS = 300;
    private static final float PERCENT_PER_LEVEL = 0.15f;

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, TinkerHooks.CONDITIONAL_STAT);
    }

    @Override
    public int getPriority() {
        return 90;
    }

    private static float getBonus(class_1309 living, int level) {
        int fire = living.method_20802();
        if (fire > 0) {
            float bonus = 0.15f * (float)level;
            if (fire < 300) {
                bonus *= (float)fire / 300.0f;
            }
            if (living.method_6059(class_1294.field_5918)) {
                bonus /= 2.0f;
            }
            return bonus;
        }
        return 0.0f;
    }

    @Override
    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        float bonus = ConductingModifier.getBonus(context.getAttacker(), level);
        if (bonus > 0.0f) {
            damage *= 1.0f + bonus;
        }
        return damage;
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, class_1309 living, FloatToolStat stat, float baseValue, float multiplier) {
        float bonus;
        if (stat == ToolStats.PROJECTILE_DAMAGE && (bonus = ConductingModifier.getBonus(living, modifier.getLevel())) > 0.0f) {
            baseValue *= 1.0f + bonus;
        }
        return baseValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey key, class_1836 flag) {
        if (tool.hasTag(TinkerTags.Items.RANGED) || tool.hasTag(TinkerTags.Items.MELEE)) {
            float bonus = 0.15f * (float)level;
            if (player != null && key == TooltipKey.SHIFT && player.method_20802() == 0) {
                bonus = 0.0f;
            }
            tooltip.add((class_2561)this.applyStyle(class_2561.method_43470((String)(Util.PERCENT_BOOST_FORMAT.format(bonus) + " ")).method_10852(ATTACK_DAMAGE)));
        }
    }
}

