/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.tool;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.mixin.transfer.BucketItemAccessor;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2402;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.impl.TankModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolModuleHooks;
import slimeknights.tconstruct.library.tools.definition.module.interaction.DualOptionInteraction;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class BucketingModifier
extends TankModifier
implements BlockInteractionModifierHook,
GeneralInteractionModifierHook {
    public BucketingModifier() {
        super(81000L);
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.BLOCK_INTERACT, TinkerHooks.GENERAL_INTERACT);
    }

    @Override
    public int getPriority() {
        return 80;
    }

    @Override
    public class_2561 getDisplayName(IToolStackView tool, int level) {
        return DualOptionInteraction.formatModifierName(tool, this, super.getDisplayName(tool, level));
    }

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (context.getChangedSlot() == class_1304.field_6174) {
            ModifierUtil.addTotalArmorModifierLevel(tool, context, TinkerDataKeys.SHOW_EMPTY_OFFHAND, 1, true);
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (context.getChangedSlot() == class_1304.field_6174) {
            ModifierUtil.addTotalArmorModifierLevel(tool, context, TinkerDataKeys.SHOW_EMPTY_OFFHAND, -1, true);
        }
    }

    private static boolean cannotContainFluid(class_1937 world, class_2338 pos, class_2680 state, class_3611 fluid) {
        class_2402 container;
        class_2248 block = state.method_26204();
        return !state.method_26188(fluid) && (!(block instanceof class_2402) || !(container = (class_2402)block).method_10310((class_1922)world, pos, state, fluid));
    }

    @Override
    public class_1269 beforeBlockUse(IToolStackView tool, ModifierEntry modifier, class_1838 context, InteractionSource source) {
        class_2350 face;
        class_2338 target;
        if (source != InteractionSource.ARMOR) {
            return class_1269.field_5811;
        }
        class_1937 world = context.method_8045();
        Storage capability = (Storage)FluidStorage.SIDED.find(world, target = context.method_8037(), (Object)(face = context.method_8038()));
        if (capability == null) {
            return class_1269.field_5811;
        }
        if (!world.field_9236) {
            class_1657 player = context.method_8036();
            boolean sneaking = player != null && player.method_5715();
            FluidStack fluidStack = this.getFluid(tool);
            class_3414 sound = null;
            if (sneaking) {
                if (!fluidStack.isEmpty()) {
                    try (Transaction t = TransferUtil.getTransaction();){
                        long added = capability.insert((Object)fluidStack.getType(), fluidStack.getAmount(), (TransactionContext)t);
                        if (added > 0L) {
                            sound = FluidVariantAttributes.getEmptySound((FluidVariant)fluidStack.getType());
                            fluidStack.shrink(added);
                            this.setFluid(tool, fluidStack);
                        }
                        t.commit();
                    }
                }
            } else if (fluidStack.isEmpty()) {
                FluidStack drained = TransferUtil.extractAnyFluid((Storage)capability, (long)this.getCapacity(tool));
                if (!drained.isEmpty()) {
                    this.setFluid(tool, drained);
                    sound = FluidVariantAttributes.getFillSound((FluidVariant)drained.getType());
                }
            } else {
                try (Transaction t = TransferUtil.getTransaction();){
                    long drained = capability.extract((Object)fluidStack.getType(), (long)this.getCapacity(tool) - fluidStack.getAmount(), (TransactionContext)t);
                    if (drained >= 0L && drained == fluidStack.getAmount()) {
                        fluidStack.grow(drained);
                        this.setFluid(tool, fluidStack);
                        sound = FluidVariantAttributes.getFillSound((FluidVariant)fluidStack.getType());
                    }
                    t.commit();
                }
            }
            if (sound != null) {
                world.method_8396(null, target, sound, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
        return class_1269.method_29236((boolean)world.field_9236);
    }

    @Override
    public class_1269 afterBlockUse(IToolStackView tool, ModifierEntry modifier, class_1838 context, InteractionSource source) {
        if (!tool.getDefinitionData().getModule(ToolModuleHooks.INTERACTION).canInteract(tool, modifier.getId(), source)) {
            return class_1269.field_5811;
        }
        class_1657 player = context.method_8036();
        if (player == null || !player.method_5715()) {
            return class_1269.field_5811;
        }
        FluidStack fluidStack = this.getFluid(tool);
        if (fluidStack.getAmount() < 81000L) {
            return class_1269.field_5811;
        }
        class_3611 fluid = fluidStack.getFluid();
        if (!(fluid instanceof class_3609)) {
            return class_1269.field_5811;
        }
        class_2350 face = context.method_8038();
        class_1937 world = context.method_8045();
        class_2338 target = context.method_8037();
        class_2338 offset = target.method_10093(face);
        if (!world.method_8505(player, target) || !player.method_7343(offset, face, context.method_8041())) {
            return class_1269.field_5811;
        }
        class_2680 existing = world.method_8320(target);
        if (BucketingModifier.cannotContainFluid(world, target, existing, fluidStack.getFluid()) && BucketingModifier.cannotContainFluid(world, target = offset, existing = world.method_8320(target), fluidStack.getFluid())) {
            return class_1269.field_5811;
        }
        boolean placed = false;
        if (world.method_8597().comp_644() && fluid.method_15791(class_3486.field_15517)) {
            world.method_8396(player, target, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.method_8406((class_2394)class_2398.field_11237, (double)target.method_10263() + Math.random(), (double)target.method_10264() + Math.random(), (double)target.method_10260() + Math.random(), 0.0, 0.0, 0.0);
            }
            placed = true;
        } else if (existing.method_26188(fluid)) {
            if (!world.field_9236 && !existing.method_51176()) {
                world.method_22352(target, true);
            }
            if (world.method_8501(target, fluid.method_15785().method_15759()) || existing.method_26227().method_15771()) {
                world.method_8396(null, target, FluidVariantAttributes.getEmptySound((FluidVariant)fluidStack.getType()), class_3419.field_15245, 1.0f, 1.0f);
                placed = true;
            }
        } else {
            class_2248 class_22482 = existing.method_26204();
            if (class_22482 instanceof class_2402) {
                class_2402 container = (class_2402)class_22482;
                container.method_10311((class_1936)world, target, existing, ((class_3609)fluid).method_15729(false));
                world.method_8396(null, target, FluidVariantAttributes.getEmptySound((FluidVariant)fluidStack.getType()), class_3419.field_15245, 1.0f, 1.0f);
                placed = true;
            }
        }
        if (placed) {
            this.drain(tool, fluidStack, 81000L);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    public class_1269 onToolUse(IToolStackView tool, ModifierEntry modifier, class_1657 player, class_1268 hand, InteractionSource source) {
        class_1755 bucketItem;
        class_3611 pickedUpFluid;
        class_1792 class_17922;
        class_2263 bucketPickup;
        class_1799 bucket;
        if (player.method_18276() || !tool.getDefinitionData().getModule(ToolModuleHooks.INTERACTION).canInteract(tool, modifier.getId(), source)) {
            return class_1269.field_5811;
        }
        FluidStack fluidStack = this.getFluid(tool);
        if ((long)this.getCapacity(tool) - fluidStack.getAmount() < 81000L) {
            return class_1269.field_5811;
        }
        class_1937 world = player.method_37908();
        class_3965 trace = ModifiableItem.blockRayTrace(world, player, class_3959.class_242.field_1345);
        if (trace.method_17783() != class_239.class_240.field_1332) {
            return class_1269.field_5811;
        }
        class_2350 face = trace.method_17780();
        class_2338 target = trace.method_17777();
        class_2338 offset = target.method_10093(face);
        if (!world.method_8505(player, target) || !player.method_7343(offset, face, player.method_6118(source.getSlot(hand)))) {
            return class_1269.field_5811;
        }
        class_3610 fluidState = world.method_8316(target);
        class_3611 currentFluid = fluidStack.getFluid();
        if (fluidState.method_15769() || !fluidStack.isEmpty() && !currentFluid.method_15780(fluidState.method_15772())) {
            return class_1269.field_5811;
        }
        class_2680 state = world.method_8320(target);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2263 && !(bucket = (bucketPickup = (class_2263)class_22482).method_9700((class_1936)world, target, state)).method_7960() && (class_17922 = bucket.method_7909()) instanceof class_1755 && (pickedUpFluid = ((BucketItemAccessor)(bucketItem = (class_1755)class_17922)).fabric_getFluid()) != class_3612.field_15906) {
            player.method_5783(FluidVariantAttributes.getFillSound((FluidVariant)FluidVariant.of((class_3611)pickedUpFluid)), 1.0f, 1.0f);
            if (!world.field_9236) {
                if (fluidStack.isEmpty()) {
                    this.setFluid(tool, new FluidStack(pickedUpFluid, 81000L));
                } else if (pickedUpFluid == currentFluid) {
                    fluidStack.grow(81000L);
                    this.setFluid(tool, fluidStack);
                } else {
                    TConstruct.LOG.error("Picked up a fluid {} that does not match the current fluid state {}, this should not happen", (Object)pickedUpFluid, (Object)fluidState.method_15772());
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }
}

