/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2444;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.AbstractRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tables.TinkerTables;

public class TinkerStationDamagingRecipe
implements ITinkerStationRecipe {
    private static final ValidatedResult BROKEN = ValidatedResult.failure(TConstruct.makeTranslationKey("recipe", "damaging.broken"), new Object[0]);
    private final class_2960 id;
    private final class_1856 ingredient;
    private final int damageAmount;

    @Override
    public boolean matches(ITinkerStationContainer inv, class_1937 world) {
        if (!inv.getTinkerableStack().method_31573(TinkerTags.Items.DURABILITY)) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv, class_5455 registryAccess) {
        if (ToolDamageUtil.isBroken(inv.getTinkerableStack())) {
            return BROKEN;
        }
        ToolStack tool = ToolStack.copyFrom(inv.getTinkerableStack());
        int maxDamage = IncrementalModifierRecipe.getAvailableAmount(inv, this.ingredient, this.damageAmount);
        ToolDamageUtil.directDamage(tool, maxDamage, null, inv.getTinkerableStack());
        return ValidatedResult.success(tool.createStack());
    }

    @Override
    public int shrinkToolSlotBy() {
        return 1;
    }

    @Override
    public void updateInputs(class_1799 result, IMutableTinkerStationContainer inv, boolean isServer) {
        int damageTaken = ToolStack.from(result).getDamage() - ToolStack.from(inv.getTinkerableStack()).getDamage();
        IncrementalModifierRecipe.updateInputs(inv, this.ingredient, damageTaken, this.damageAmount, class_1799.field_8037);
    }

    @Deprecated
    public class_1799 method_8110(class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerTables.tinkerStationDamagingSerializer.get();
    }

    public TinkerStationDamagingRecipe(class_2960 id, class_1856 ingredient, int damageAmount) {
        this.id = id;
        this.ingredient = ingredient;
        this.damageAmount = damageAmount;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public static class Builder
    extends AbstractRecipeBuilder<Builder> {
        private final class_1856 ingredient;
        private final int damageAmount;

        public void save(Consumer<class_2444> consumer) {
            class_1799[] stacks = this.ingredient.method_8105();
            if (stacks.length == 0) {
                throw new IllegalStateException("Empty ingredient not allowed");
            }
            this.save(consumer, class_7923.field_41178.method_10221((Object)stacks[0].method_7909()));
        }

        public void save(Consumer<class_2444> consumer, class_2960 id) {
            if (this.ingredient == class_1856.field_9017) {
                throw new IllegalStateException("Empty ingredient not allowed");
            }
            class_2960 advancementId = this.buildOptionalAdvancement(id, "tinker_station");
            consumer.accept((class_2444)new Finished(id, advancementId));
        }

        private Builder(class_1856 ingredient, int damageAmount) {
            this.ingredient = ingredient;
            this.damageAmount = damageAmount;
        }

        public static Builder damage(class_1856 ingredient, int damageAmount) {
            return new Builder(ingredient, damageAmount);
        }

        private class Finished
        extends AbstractRecipeBuilder.AbstractFinishedRecipe {
            public Finished(@Nullable class_2960 ID, class_2960 advancementID) {
                super((AbstractRecipeBuilder)Builder.this, ID, advancementID);
            }

            public void method_10416(JsonObject json) {
                json.add("ingredient", Builder.this.ingredient.method_8089());
                json.addProperty("damage_amount", (Number)Builder.this.damageAmount);
            }

            public class_1865<?> method_17800() {
                return (class_1865)TinkerTables.tinkerStationDamagingSerializer.get();
            }
        }
    }

    public static class Serializer
    extends AbstractRecipeSerializer<TinkerStationDamagingRecipe> {
        public TinkerStationDamagingRecipe fromJson(class_2960 id, JsonObject json) {
            class_1856 ingredient = class_1856.method_52177((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
            int restoreAmount = class_3518.method_15260((JsonObject)json, (String)"damage_amount");
            return new TinkerStationDamagingRecipe(id, ingredient, restoreAmount);
        }

        @Nullable
        public TinkerStationDamagingRecipe fromNetwork(class_2960 id, class_2540 buffer) {
            class_1856 ingredient = class_1856.method_8086((class_2540)buffer);
            int damageAmount = buffer.method_10816();
            return new TinkerStationDamagingRecipe(id, ingredient, damageAmount);
        }

        public void toNetwork(class_2540 buffer, TinkerStationDamagingRecipe recipe) {
            recipe.ingredient.method_8088(buffer);
            buffer.method_10804(recipe.damageAmount);
        }
    }
}

