/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.multiblock;

import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.common.multiblock.IMasterLogic;
import slimeknights.tconstruct.common.multiblock.IServantLogic;
import slimeknights.tconstruct.library.utils.TagUtil;

public class MultiblockStructureData {
    public static final String TAG_EXTRA_POS = "extra";
    public static final String TAG_MIN = "min";
    public static final String TAG_MAX = "max";
    private final class_2338 minPos;
    private final class_2338 maxPos;
    protected final Set<class_2338> extra;
    private final boolean hasCeiling;
    private final boolean hasFrame;
    private final boolean hasFloor;
    private final class_2338 minInside;
    private final class_2338 maxInside;
    private final int innerX;
    private final int innerY;
    private final int innerZ;
    private final class_238 bounds;

    public MultiblockStructureData(class_2338 minPos, class_2338 maxPos, Set<class_2338> extraPositons, boolean hasFloor, boolean hasFrame, boolean hasCeiling) {
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.extra = extraPositons;
        this.hasFloor = hasFloor;
        this.hasFrame = hasFrame;
        this.hasCeiling = hasCeiling;
        this.minInside = minPos.method_10069(1, hasFloor ? 1 : 0, 1);
        this.maxInside = maxPos.method_10069(-1, hasCeiling ? -1 : 0, -1);
        this.innerX = this.maxInside.method_10263() - this.minInside.method_10263() + 1;
        this.innerY = this.maxInside.method_10264() - this.minInside.method_10264() + 1;
        this.innerZ = this.maxInside.method_10260() - this.minInside.method_10260() + 1;
        this.bounds = new class_238(this.minInside, this.maxInside.method_10069(1, 1, 1));
    }

    public static boolean isWithin(class_2338 pos, class_2338 min, class_2338 max) {
        return pos.method_10263() >= min.method_10263() && pos.method_10264() >= min.method_10264() && pos.method_10260() >= min.method_10260() && pos.method_10263() <= max.method_10263() && pos.method_10264() <= max.method_10264() && pos.method_10260() <= max.method_10260();
    }

    public boolean withinBounds(class_2338 pos) {
        return MultiblockStructureData.isWithin(pos, this.minPos, this.maxPos);
    }

    public boolean isInside(class_2338 pos) {
        return MultiblockStructureData.isWithin(pos, this.minInside, this.maxInside);
    }

    public boolean contains(class_2338 pos) {
        return this.withinBounds(pos) && this.containsBase(pos);
    }

    private boolean containsBase(class_2338 pos) {
        if (!this.isInside(pos)) {
            if (this.hasFrame) {
                return true;
            }
            int edges = 0;
            if (pos.method_10263() == this.minPos.method_10263() || pos.method_10263() == this.maxPos.method_10263()) {
                ++edges;
            }
            if (pos.method_10260() == this.minPos.method_10260() || pos.method_10260() == this.maxPos.method_10260()) {
                ++edges;
            }
            if (this.hasFloor && pos.method_10264() == this.minPos.method_10264() || this.hasCeiling && pos.method_10263() == this.maxPos.method_10263()) {
                ++edges;
            }
            if (edges < 2) {
                return true;
            }
        }
        return this.extra.contains(pos);
    }

    public boolean isDirectlyAbove(class_2338 pos) {
        return pos.method_10263() >= this.minPos.method_10263() && pos.method_10260() >= this.minPos.method_10260() && pos.method_10263() <= this.maxPos.method_10263() && pos.method_10260() <= this.maxPos.method_10260() && pos.method_10264() == this.maxPos.method_10264() + 1;
    }

    public void forEachContained(Consumer<class_2338.class_2339> consumer) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int x = this.minPos.method_10263(); x <= this.maxPos.method_10263(); ++x) {
            for (int y = this.minPos.method_10264(); y <= this.maxPos.method_10264(); ++y) {
                for (int z = this.minPos.method_10260(); z <= this.maxPos.method_10260(); ++z) {
                    mutable.method_10103(x, y, z);
                    if (!this.containsBase((class_2338)mutable)) continue;
                    consumer.accept(mutable);
                }
            }
        }
    }

    public <T extends MantleBlockEntity> void assignMaster(T master, @Nullable MultiblockStructureData oldStructure) {
        Predicate<class_2338> shouldUpdate = oldStructure == null ? pos -> true : pos -> !oldStructure.contains((class_2338)pos);
        class_1937 world = master.method_10997();
        assert (world != null);
        this.forEachContained(pos -> {
            if (shouldUpdate.test((class_2338)pos) && world.method_22340((class_2338)pos)) {
                BlockEntityHelper.get(IServantLogic.class, (class_1922)world, (class_2338)pos).ifPresent(te -> te.setPotentialMaster((IMasterLogic)master));
            }
        });
        if (oldStructure != null) {
            oldStructure.forEachContained(pos -> {
                if (!this.contains((class_2338)pos) && world.method_22340((class_2338)pos)) {
                    BlockEntityHelper.get(IServantLogic.class, (class_1922)world, (class_2338)pos).ifPresent(te -> te.removeMaster((IMasterLogic)master));
                }
            });
        }
    }

    public <T extends MantleBlockEntity> void clearMaster(T master) {
        class_1937 world = master.method_10997();
        assert (world != null);
        this.forEachContained(pos -> {
            if (world.method_22340((class_2338)pos)) {
                BlockEntityHelper.get(IServantLogic.class, (class_1922)world, (class_2338)pos).ifPresent(te -> te.removeMaster((IMasterLogic)master));
            }
        });
    }

    public class_2487 writeClientTag() {
        class_2487 nbt = new class_2487();
        nbt.method_10566(TAG_MIN, (class_2520)TagUtil.writePos(this.minPos));
        nbt.method_10566(TAG_MAX, (class_2520)TagUtil.writePos(this.maxPos));
        return nbt;
    }

    public class_2487 writeToTag() {
        class_2487 nbt = this.writeClientTag();
        if (!this.extra.isEmpty()) {
            nbt.method_10566(TAG_EXTRA_POS, (class_2520)MultiblockStructureData.writePosList(this.extra));
        }
        return nbt;
    }

    protected static class_2499 writePosList(Collection<class_2338> collection) {
        class_2499 list = new class_2499();
        for (class_2338 pos : collection) {
            list.add((Object)TagUtil.writePos(pos));
        }
        return list;
    }

    public class_2338 getMinPos() {
        return this.minPos;
    }

    public class_2338 getMaxPos() {
        return this.maxPos;
    }

    public class_2338 getMinInside() {
        return this.minInside;
    }

    public class_2338 getMaxInside() {
        return this.maxInside;
    }

    public int getInnerX() {
        return this.innerX;
    }

    public int getInnerY() {
        return this.innerY;
    }

    public int getInnerZ() {
        return this.innerZ;
    }

    public class_238 getBounds() {
        return this.bounds;
    }
}

