/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.controller;

import io.github.fabricators_of_create.porting_lib.block.ChunkUnloadListeningBlockEntity;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import java.util.Collections;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5250;
import net.minecraft.class_5558;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.block.entity.NameableBlockEntity;
import slimeknights.mantle.client.model.data.SinglePropertyData;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.controller.MelterBlock;
import slimeknights.tconstruct.smeltery.block.entity.ITankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.menu.MelterContainerMenu;

public class MelterBlockEntity
extends NameableBlockEntity
implements ITankBlockEntity,
SidedStorageBlockEntity,
ChunkUnloadListeningBlockEntity {
    private static final long TANK_CAPACITY = 108000L;
    private static final String TAG_INVENTORY = "inventory";
    private static final class_5250 NAME = TConstruct.makeTranslation("gui", "melter");
    public static final class_5558<MelterBlockEntity> SERVER_TICKER = (level, pos, state, self) -> self.tick(level, pos, state);
    protected final FluidTankAnimated tank = new FluidTankAnimated(108000L, (MantleBlockEntity)this);
    private final SinglePropertyData<FluidTank> modelData = new SinglePropertyData(ModelProperties.FLUID_TANK, (Object)this.tank);
    private int lastStrength = -1;
    private int tick;
    private final MeltingModuleInventory meltingInventory;
    private final FuelModule fuelModule;

    public MelterBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591<? extends MelterBlockEntity>)((class_2591)TinkerSmeltery.melter.get()), pos, state);
    }

    protected MelterBlockEntity(class_2591<? extends MelterBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, (class_2561)NAME);
        this.meltingInventory = new MeltingModuleInventory((MantleBlockEntity)this, (SlottedStorage<FluidVariant>)this.tank, Config.COMMON.melterOreRate, 3);
        this.fuelModule = new FuelModule((MantleBlockEntity)this, () -> Collections.singletonList(this.field_11867.method_10074()));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inv, class_1657 playerEntity) {
        return new MelterContainerMenu(id, inv, this);
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 direction) {
        return this.tank;
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 direction) {
        return this.meltingInventory;
    }

    public void method_11012() {
        super.method_11012();
        this.invalidateCaps();
    }

    public void onChunkUnloaded() {
        this.invalidateCaps();
    }

    private boolean isFormed() {
        class_2680 state = this.method_11010();
        return state.method_28498((class_2769)MelterBlock.IN_STRUCTURE) && (Boolean)state.method_11654((class_2769)MelterBlock.IN_STRUCTURE) != false;
    }

    private void tick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.isFormed()) {
            switch (this.tick) {
                case 0: {
                    if (!this.fuelModule.hasFuel() && this.meltingInventory.canHeat(this.fuelModule.findFuel(false))) {
                        this.fuelModule.findFuel(true);
                    }
                }
                case 2: {
                    boolean hasFuel = this.fuelModule.hasFuel();
                    if ((Boolean)state.method_11654((class_2769)ControllerBlock.ACTIVE) != hasFuel) {
                        level.method_8501(pos, (class_2680)state.method_11657((class_2769)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                        class_2338 down = pos.method_10074();
                        class_2680 downState = level.method_8320(down);
                        if (downState.method_26164(TinkerTags.Blocks.FUEL_TANKS) && downState.method_28498((class_2769)ControllerBlock.ACTIVE) && (Boolean)downState.method_11654((class_2769)ControllerBlock.ACTIVE) != hasFuel) {
                            level.method_8501(down, (class_2680)downState.method_11657((class_2769)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                        }
                    }
                    if (hasFuel) {
                        this.meltingInventory.heatItems(this.fuelModule.getTemperature());
                        this.fuelModule.decreaseFuel(1);
                        break;
                    }
                    this.meltingInventory.coolItems();
                }
            }
            this.tick = (this.tick + 1) % 4;
        }
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.tank.readFromNBT(tag.method_10562("tank"));
        this.fuelModule.readFromTag(tag);
        if (tag.method_10573(TAG_INVENTORY, 10)) {
            this.meltingInventory.readFromTag(tag.method_10562(TAG_INVENTORY));
        }
    }

    public void saveSynced(class_2487 tag) {
        super.saveSynced(tag);
        tag.method_10566("tank", (class_2520)this.tank.writeToNBT(new class_2487()));
        tag.method_10566(TAG_INVENTORY, (class_2520)this.meltingInventory.writeToTag());
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.fuelModule.writeToTag(tag);
    }

    public Object getRenderData() {
        return this.modelData;
    }

    @Override
    public FluidTankAnimated getTank() {
        return this.tank;
    }

    public SinglePropertyData<FluidTank> getModelData() {
        return this.modelData;
    }

    @Override
    public int getLastStrength() {
        return this.lastStrength;
    }

    @Override
    public void setLastStrength(int lastStrength) {
        this.lastStrength = lastStrength;
    }

    public MeltingModuleInventory getMeltingInventory() {
        return this.meltingInventory;
    }

    public FuelModule getFuelModule() {
        return this.fuelModule;
    }
}

