/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.modifiers;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.fabricators_of_create.porting_lib.util.ForgeI18n;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4730;
import net.minecraft.class_757;
import slimeknights.mantle.client.model.NBTKeyModel;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierIngredientRenderer;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;
import slimeknights.tconstruct.tools.stats.SkullStats;

public class ModifierRecipeCategory
implements IRecipeCategory<IDisplayModifierRecipe> {
    protected static final class_2960 BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/tinker_station.png");
    private static final class_2561 TITLE = TConstruct.makeTranslation("jei", "modifiers.title");
    private static final List<class_2561> TEXT_FREE = Collections.singletonList(TConstruct.makeTranslation("jei", "modifiers.free"));
    private static final List<class_2561> TEXT_INCREMENTAL = Collections.singletonList(TConstruct.makeTranslation("jei", "modifiers.incremental"));
    private static final String KEY_SLOT = TConstruct.makeTranslationKey("jei", "modifiers.slot");
    private static final String KEY_SLOTS = TConstruct.makeTranslationKey("jei", "modifiers.slots");
    private static final String KEY_MAX = TConstruct.makeTranslationKey("jei", "modifiers.max");
    private final ModifierIngredientRenderer modifierRenderer = new ModifierIngredientRenderer(124, 10);
    private final IDrawable background;
    private final IDrawable icon;
    private final String maxPrefix;
    private final IDrawable requirements;
    private final IDrawable incremental;
    private final IDrawable[] slotIcons;
    private final Map<SlotType, class_1058> slotTypeSprites = new HashMap<SlotType, class_1058>();
    private static List<class_1799> SLIMESKULL_HELMETS = null;

    public ModifierRecipeCategory(IGuiHelper helper) {
        this.maxPrefix = ForgeI18n.getPattern((String)KEY_MAX);
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 0, 128, 77);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)CreativeSlotItem.withSlot(new class_1799(TinkerModifiers.creativeSlotItem), SlotType.UPGRADE));
        this.slotIcons = new IDrawable[6];
        for (int i = 0; i < 6; ++i) {
            this.slotIcons[i] = helper.createDrawable(BACKGROUND_LOC, 128 + i * 16, 0, 16, 16);
        }
        this.requirements = helper.createDrawable(BACKGROUND_LOC, 128, 17, 16, 16);
        this.incremental = helper.createDrawable(BACKGROUND_LOC, 128, 33, 16, 16);
    }

    public RecipeType<IDisplayModifierRecipe> getRecipeType() {
        return TConstructJEIConstants.MODIFIERS;
    }

    public class_2561 getTitle() {
        return TITLE;
    }

    private void drawSlot(class_332 graphics, IDisplayModifierRecipe recipe, int slot, int x, int y) {
        List<class_1799> stacks = recipe.getDisplayItems(slot);
        if (stacks.isEmpty()) {
            this.slotIcons[slot].draw(graphics, x + 1, y + 1);
        }
    }

    private void drawSlotType(class_332 graphics, @Nullable SlotType slotType, int x, int y) {
        class_1058 sprite;
        class_310 minecraft = class_310.method_1551();
        if (this.slotTypeSprites.containsKey(slotType)) {
            sprite = this.slotTypeSprites.get(slotType);
        } else {
            class_1092 modelManager = minecraft.method_1554();
            class_1087 model = minecraft.method_1480().method_4012().method_3304((class_1792)TinkerModifiers.creativeSlotItem.get());
            if (model != null && model.method_4710() instanceof NBTKeyModel.Overrides) {
                class_4730 material = ((NBTKeyModel.Overrides)model.method_4710()).getTexture(slotType == null ? "slotless" : slotType.getName());
                sprite = modelManager.method_24153(material.method_24144()).method_4608(material.method_24147());
            } else {
                sprite = modelManager.method_24153(class_1723.field_21668).method_4608(class_1047.method_4539());
            }
            this.slotTypeSprites.put(slotType, sprite);
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        graphics.method_25298(x, y, 0, 16, 16, sprite);
    }

    public void draw(IDisplayModifierRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        SlotType.SlotCount slots;
        this.drawSlot(graphics, recipe, 0, 2, 32);
        this.drawSlot(graphics, recipe, 1, 24, 14);
        this.drawSlot(graphics, recipe, 2, 46, 32);
        this.drawSlot(graphics, recipe, 3, 42, 57);
        this.drawSlot(graphics, recipe, 4, 6, 57);
        if (recipe.hasRequirements()) {
            this.requirements.draw(graphics, 66, 58);
        }
        if (recipe.isIncremental()) {
            this.incremental.draw(graphics, 83, 59);
        }
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int max = recipe.getMaxLevel();
        if (max > 0) {
            graphics.method_51433(fontRenderer, this.maxPrefix + max, 66, 16, Color.GRAY.getRGB(), false);
        }
        if ((slots = recipe.getSlots()) == null) {
            this.drawSlotType(graphics, null, 110, 58);
        } else {
            this.drawSlotType(graphics, slots.getType(), 110, 58);
            String text = Integer.toString(slots.getCount());
            int x = 111 - fontRenderer.method_1727(text);
            graphics.method_51433(fontRenderer, text, x, 63, Color.GRAY.getRGB(), false);
        }
    }

    public List<class_2561> getTooltipStrings(IDisplayModifierRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int checkX = (int)mouseX;
        int checkY = (int)mouseY;
        if (recipe.hasRequirements() && GuiUtil.isHovered(checkX, checkY, 66, 58, 16, 16)) {
            return Collections.singletonList(class_2561.method_43471((String)recipe.getRequirementsError()));
        }
        if (recipe.isIncremental() && GuiUtil.isHovered(checkX, checkY, 83, 59, 16, 16)) {
            return TEXT_INCREMENTAL;
        }
        if (GuiUtil.isHovered(checkX, checkY, 98, 58, 24, 16)) {
            SlotType.SlotCount slots = recipe.getSlots();
            if (slots != null) {
                int count = slots.getCount();
                if (count == 1) {
                    return Collections.singletonList(class_2561.method_43469((String)KEY_SLOT, (Object[])new Object[]{slots.getType().getDisplayName()}));
                }
                if (count > 1) {
                    return Collections.singletonList(class_2561.method_43469((String)KEY_SLOTS, (Object[])new Object[]{slots, slots.getType().getDisplayName()}));
                }
            } else {
                return TEXT_FREE;
            }
        }
        return Collections.emptyList();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IDisplayModifierRecipe recipe, IFocusGroup focuses) {
        IFocus focus;
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 33).addItemStacks(recipe.getDisplayItems(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 25, 15).addItemStacks(recipe.getDisplayItems(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 47, 33).addItemStacks(recipe.getDisplayItems(2));
        builder.addSlot(RecipeIngredientRole.INPUT, 43, 58).addItemStacks(recipe.getDisplayItems(3));
        builder.addSlot(RecipeIngredientRole.INPUT, 7, 58).addItemStacks(recipe.getDisplayItems(4));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 3, 3).setCustomRenderer(TConstructJEIConstants.MODIFIER_TYPE, (IIngredientRenderer)this.modifierRenderer).addIngredient(TConstructJEIConstants.MODIFIER_TYPE, (Object)recipe.getDisplayResult());
        List<class_1799> toolWithoutModifier = recipe.getToolWithoutModifier();
        List<class_1799> toolWithModifier = recipe.getToolWithModifier();
        class_1792 slimeskull = (class_1792)TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET);
        for (class_1799 stack : toolWithoutModifier) {
            if (!stack.method_31574(slimeskull)) continue;
            builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addItemStacks(ModifierRecipeCategory.getSlimeskullHelmets());
            break;
        }
        if ((focus = (IFocus)focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).filter(f -> f.getRole() == RecipeIngredientRole.CATALYST).findFirst().orElse(null)) != null) {
            class_1792 item = ((class_1799)focus.getTypedValue().getIngredient()).method_7909();
            for (class_1799 stack : toolWithoutModifier) {
                if (!stack.method_31574(item)) continue;
                toolWithoutModifier = List.of(stack);
                break;
            }
            for (class_1799 stack : toolWithModifier) {
                if (!stack.method_31574(item)) continue;
                toolWithModifier = List.of(stack);
                break;
            }
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 25, 38).addItemStacks(toolWithoutModifier);
        builder.addSlot(RecipeIngredientRole.CATALYST, 105, 34).addItemStacks(toolWithModifier);
    }

    public static void clearSlimeskullCache() {
        SLIMESKULL_HELMETS = null;
    }

    private static List<class_1799> getSlimeskullHelmets() {
        if (SLIMESKULL_HELMETS == null) {
            IMaterialRegistry registry = MaterialRegistry.getInstance();
            IModifiable slimeskull = (IModifiable)TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET);
            SLIMESKULL_HELMETS = registry.getAllMaterials().stream().filter(material -> registry.getMaterialStats(material.getIdentifier(), SkullStats.ID).isPresent()).map(material -> ToolBuildHandler.buildItemFromMaterials(slimeskull, MaterialNBT.of(material))).toList();
        }
        return SLIMESKULL_HELMETS;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

