/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.harvest;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.util.TierSortingRegistry;
import io.netty.handler.codec.DecoderException;
import java.util.Objects;
import net.minecraft.class_1832;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.tools.definition.harvest.IHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.HarvestTiers;

public class FixedTierHarvestLogic
implements IHarvestLogic {
    public static final Loader LOADER = new Loader();
    protected final class_6862<class_2248> tag;
    protected final class_1832 tier;

    @Override
    public boolean isEffective(IToolStackView tool, class_2680 state) {
        return state.method_26164(this.tag) && TierSortingRegistry.isCorrectTierForDrops((class_1832)this.getTier(tool), (class_2680)state);
    }

    @Override
    public class_1832 getTier(IToolStackView tool) {
        return HarvestTiers.min(this.tier, tool.getStats().get(ToolStats.HARVEST_TIER));
    }

    public GenericLoaderRegistry.IGenericLoader<? extends IHarvestLogic> getLoader() {
        return LOADER;
    }

    public FixedTierHarvestLogic(class_6862<class_2248> tag, class_1832 tier) {
        this.tag = tag;
        this.tier = tier;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<FixedTierHarvestLogic> {
        private Loader() {
        }

        public FixedTierHarvestLogic deserialize(JsonObject json) {
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)JsonHelper.getResourceLocation((JsonObject)json, (String)"effective"));
            class_2960 tierName = JsonHelper.getResourceLocation((JsonObject)json, (String)"tier");
            class_1832 tier = TierSortingRegistry.byName((class_2960)tierName);
            if (tier == null) {
                throw new JsonSyntaxException("Unknown harvest tier " + tierName);
            }
            return new FixedTierHarvestLogic((class_6862<class_2248>)tag, tier);
        }

        public FixedTierHarvestLogic fromNetwork(class_2540 buffer) {
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)buffer.method_10810());
            class_2960 name = buffer.method_10810();
            class_1832 tier = TierSortingRegistry.byName((class_2960)name);
            if (tier == null) {
                throw new DecoderException("Read unknown tier " + name + " from network");
            }
            return new FixedTierHarvestLogic((class_6862<class_2248>)tag, tier);
        }

        private static class_2960 getTierName(class_1832 tier) {
            return Objects.requireNonNull(TierSortingRegistry.getName((class_1832)tier), "Attempt to serialize unregistered tier");
        }

        public void serialize(FixedTierHarvestLogic object, JsonObject json) {
            json.addProperty("effective", object.tag.comp_327().toString());
            json.addProperty("tier", Loader.getTierName(object.tier).toString());
        }

        public void toNetwork(FixedTierHarvestLogic object, class_2540 buffer) {
            buffer.method_10812(object.tag.comp_327());
            buffer.method_10812(Loader.getTierName(object.tier));
        }
    }
}

