/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import slimeknights.tconstruct.library.tools.SlotType;

public class DefinitionModifierSlots {
    protected static final DefinitionModifierSlots EMPTY = new DefinitionModifierSlots(Collections.emptyMap());
    public static Serializer SERIALIZER = new Serializer();
    private final Map<SlotType, Integer> slots;

    public int getSlots(SlotType slotType) {
        return this.slots.getOrDefault(slotType, 0);
    }

    public Set<SlotType> containedTypes() {
        return this.slots.keySet();
    }

    public void write(class_2540 buffer) {
        buffer.method_10804(this.slots.size());
        for (Map.Entry<SlotType, Integer> entry : this.slots.entrySet()) {
            buffer.method_10814(entry.getKey().getName());
            buffer.method_10804(entry.getValue().intValue());
        }
    }

    public static DefinitionModifierSlots read(class_2540 buffer) {
        Builder builder = DefinitionModifierSlots.builder();
        int max = buffer.method_10816();
        for (int i = 0; i < max; ++i) {
            SlotType slotType = SlotType.getOrCreate(buffer.method_10800(Short.MAX_VALUE));
            builder.setSlots(slotType, buffer.method_10816());
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected DefinitionModifierSlots(Map<SlotType, Integer> slots) {
        this.slots = slots;
    }

    public static class Builder {
        private final ImmutableMap.Builder<SlotType, Integer> builder = ImmutableMap.builder();

        protected Builder() {
        }

        public Builder setSlots(SlotType slotType, int count) {
            this.builder.put((Object)slotType, (Object)count);
            return this;
        }

        public DefinitionModifierSlots build() {
            return new DefinitionModifierSlots((Map<SlotType, Integer>)this.builder.build());
        }
    }

    protected static class Serializer
    implements JsonDeserializer<DefinitionModifierSlots>,
    JsonSerializer<DefinitionModifierSlots> {
        protected Serializer() {
        }

        public DefinitionModifierSlots deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = class_3518.method_15295((JsonElement)json, (String)"stats");
            Builder builder = DefinitionModifierSlots.builder();
            for (Map.Entry entry : object.entrySet()) {
                int value = class_3518.method_15257((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                SlotType slotType = SlotType.getOrCreate((String)entry.getKey());
                builder.setSlots(slotType, value);
            }
            return builder.build();
        }

        public JsonElement serialize(DefinitionModifierSlots stats, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            for (Map.Entry<SlotType, Integer> entry : stats.slots.entrySet()) {
                json.addProperty(entry.getKey().getName(), (Number)entry.getValue());
            }
            return json;
        }
    }
}

