/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1865;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipeBuilder;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SwappableModifierRecipeBuilder
extends ModifierRecipeBuilder {
    private final String value;

    protected SwappableModifierRecipeBuilder(ModifierId modifier, String value) {
        super(new ModifierEntry(modifier, 1));
        this.value = value;
        this.allowCrystal = false;
    }

    public static SwappableModifierRecipeBuilder modifier(ModifierId modifier, String value) {
        return new SwappableModifierRecipeBuilder(modifier, value);
    }

    public static SwappableModifierRecipeBuilder modifier(LazyModifier modifier, String value) {
        return SwappableModifierRecipeBuilder.modifier(modifier.getId(), value);
    }

    @Override
    public ModifierRecipeBuilder setMaxLevel(int level) {
        throw new UnsupportedOperationException("Max level is always 1 for a swappable modifier recipe");
    }

    @Override
    public void save(Consumer<class_2444> consumer, class_2960 id) {
        if (this.inputs.isEmpty()) {
            throw new IllegalStateException("Must have at least 1 input");
        }
        class_2960 advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((class_2444)new Finished(id, advancementId, false));
        if (this.includeUnarmed) {
            if (this.requirements != ModifierMatch.ALWAYS) {
                throw new IllegalStateException("Cannot use includeUnarmed with requirements");
            }
            consumer.accept((class_2444)new Finished(new class_2960(id.method_12836(), id.method_12832() + "_unarmed"), null, true));
        }
    }

    private class Finished
    extends ModifierRecipeBuilder.FinishedAdding {
        public Finished(@Nullable class_2960 ID, class_2960 advancementID, boolean withUnarmed) {
            super(ID, advancementID, withUnarmed);
        }

        @Override
        public class_1865<?> method_17800() {
            return (class_1865)TinkerModifiers.swappableModifierSerializer.get();
        }

        @Override
        public void method_10416(JsonObject json) {
            super.method_10416(json);
            JsonObject result = json.getAsJsonObject("result");
            result.remove("level");
            result.addProperty("value", SwappableModifierRecipeBuilder.this.value);
        }
    }
}

