/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.DisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class MultilevelModifierRecipe
extends ModifierRecipe
implements IMultiRecipe<IDisplayModifierRecipe> {
    protected static final String KEY_MIN_LEVEL = TConstruct.makeTranslationKey("recipe", "modifier.min_level");
    private final List<LevelEntry> levels;
    private List<IDisplayModifierRecipe> displayRecipes = null;

    protected MultilevelModifierRecipe(class_2960 id, List<SizedIngredient> inputs, class_1856 toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierId result, boolean allowCrystal, List<LevelEntry> levels) {
        super(id, inputs, toolRequirement, maxToolSize, requirements, requirementsError, new ModifierEntry(result, 1), levels.get(0).maxLevel() + 1, levels.get(0).slots(), allowCrystal);
        this.levels = levels;
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv, class_5455 registryAccess) {
        class_1799 tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        ValidatedResult requirements = this.validateRequirements(tool);
        if (requirements.hasError()) {
            return requirements;
        }
        int newLevel = tool.getModifierLevel(this.result.getModifier()) + 1;
        LevelEntry levelEntry = null;
        for (LevelEntry check : this.levels) {
            if (!check.matches(newLevel)) continue;
            levelEntry = check;
            break;
        }
        if (levelEntry == null) {
            if (newLevel < this.levels.get(0).minLevel()) {
                return ValidatedResult.failure(KEY_MIN_LEVEL, this.result.getModifier().getDisplayName(), this.levels.get(0).minLevel() - 1);
            }
            return ValidatedResult.failure(KEY_MAX_LEVEL, this.result.getModifier().getDisplayName(), this.levels.get(this.levels.size() - 1).maxLevel());
        }
        SlotType.SlotCount slots = levelEntry.slots();
        requirements = MultilevelModifierRecipe.checkSlots(tool, slots);
        if (requirements.hasError()) {
            return requirements;
        }
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        if (slots != null) {
            persistentData.addSlots(slots.getType(), -slots.getCount());
        }
        tool.addModifier(this.result.getId(), this.result.getLevel());
        ValidatedResult toolValidation = tool.validate();
        if (toolValidation.hasError()) {
            return toolValidation;
        }
        return ValidatedResult.success(tool.createStack(Math.min(tinkerable.method_7947(), this.shrinkToolSlotBy())));
    }

    @Override
    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.multilevelModifierSerializer.get();
    }

    public List<IDisplayModifierRecipe> getRecipes() {
        if (this.inputs.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.displayRecipes == null) {
            List<class_1799> toolWithoutModifier = this.getToolWithoutModifier();
            List<class_1799> toolWithModifier = this.getToolWithModifier();
            String requirementsError = this.getRequirementsError();
            this.displayRecipes = Streams.concat((Stream[])new Stream[]{Stream.of(this), this.levels.stream().skip(1L).map(levelEntry -> new DisplayModifierRecipe(this.inputs, toolWithoutModifier, toolWithModifier, requirementsError + ".level_" + levelEntry.minLevel, this.result, levelEntry.maxLevel, levelEntry.slots))}).toList();
        }
        return this.displayRecipes;
    }

    record LevelEntry(@Nullable SlotType.SlotCount slots, int minLevel, int maxLevel) {
        public boolean matches(int level) {
            return this.minLevel <= level && level <= this.maxLevel;
        }

        public static LevelEntry parse(JsonObject json) {
            int min;
            int max;
            if (json.has("level")) {
                min = max = class_3518.method_15260((JsonObject)json, (String)"level");
            } else {
                min = class_3518.method_15282((JsonObject)json, (String)"min_level", (int)1);
                if (min > (max = class_3518.method_15282((JsonObject)json, (String)"max_level", (int)Short.MAX_VALUE))) {
                    throw new JsonSyntaxException("min_level must be less than or equal to max_level");
                }
            }
            SlotType.SlotCount slots = null;
            if (json.has("slots")) {
                slots = SlotType.SlotCount.fromJson(class_3518.method_15296((JsonObject)json, (String)"slots"));
            }
            return new LevelEntry(slots, min, max);
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            if (this.slots != null) {
                JsonObject slotJson = new JsonObject();
                slotJson.addProperty(this.slots.getType().getName(), (Number)this.slots.getCount());
                json.add("slots", (JsonElement)slotJson);
            }
            if (this.minLevel == this.maxLevel) {
                json.addProperty("level", (Number)this.minLevel);
            } else {
                json.addProperty("min_level", (Number)this.minLevel);
                if (this.maxLevel < Short.MAX_VALUE) {
                    json.addProperty("max_level", (Number)this.maxLevel);
                }
            }
            return json;
        }

        public static LevelEntry read(class_2540 buffer) {
            SlotType.SlotCount slots = SlotType.SlotCount.read(buffer);
            int min = buffer.method_10816();
            int max = buffer.method_10816();
            return new LevelEntry(slots, min, max);
        }

        public void write(class_2540 buffer) {
            SlotType.SlotCount.write(this.slots, buffer);
            buffer.method_10804(this.minLevel);
            buffer.method_10804(this.maxLevel);
        }
    }

    public static class Serializer
    extends LoggingRecipeSerializer<MultilevelModifierRecipe> {
        public MultilevelModifierRecipe fromJson(class_2960 id, JsonObject json) {
            class_1856 toolRequirement = class_1856.method_52177((JsonElement)json.get("tools"));
            int maxToolSize = class_3518.method_15282((JsonObject)json, (String)"max_tool_size", (int)16);
            ModifierId result = new ModifierId(JsonHelper.getResourceLocation((JsonObject)json, (String)"result"));
            List levels = JsonHelper.parseList((JsonObject)json, (String)"levels", LevelEntry::parse);
            List ingredients = Collections.emptyList();
            if (json.has("inputs")) {
                ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            }
            boolean allowCrystal = class_3518.method_15258((JsonObject)json, (String)"allow_crystal", (boolean)true);
            if (ingredients.isEmpty() && !allowCrystal) {
                throw new JsonSyntaxException("Must either have inputs or allow crystal");
            }
            ModifierMatch requirements = ModifierMatch.ALWAYS;
            String requirementsError = "";
            if (json.has("requirements")) {
                JsonObject reqJson = class_3518.method_15296((JsonObject)json, (String)"requirements");
                requirements = ModifierMatch.deserialize(reqJson);
                requirementsError = class_3518.method_15265((JsonObject)reqJson, (String)"error");
            } else if (!ingredients.isEmpty()) {
                requirementsError = class_3518.method_15265((JsonObject)json, (String)"level_error");
            }
            return new MultilevelModifierRecipe(id, (List<SizedIngredient>)ingredients, toolRequirement, maxToolSize, requirements, requirementsError, result, allowCrystal, levels);
        }

        @Nullable
        protected MultilevelModifierRecipe fromNetworkSafe(class_2960 id, class_2540 buffer) {
            class_1856 toolRequirement = class_1856.method_8086((class_2540)buffer);
            int maxToolSize = buffer.method_10816();
            ModifierMatch requirements = ModifierMatch.read(buffer);
            String requirementsError = buffer.method_10800(Short.MAX_VALUE);
            ModifierId result = new ModifierId(buffer.method_10810());
            int size = buffer.method_10816();
            ImmutableList.Builder inputs = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                inputs.add((Object)SizedIngredient.read((class_2540)buffer));
            }
            boolean allowCrystal = buffer.readBoolean();
            size = buffer.method_10816();
            ImmutableList.Builder levels = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                levels.add((Object)LevelEntry.read(buffer));
            }
            return new MultilevelModifierRecipe(id, (List<SizedIngredient>)inputs.build(), toolRequirement, maxToolSize, requirements, requirementsError, result, allowCrystal, (List<LevelEntry>)levels.build());
        }

        protected void toNetworkSafe(class_2540 buffer, MultilevelModifierRecipe recipe) {
            recipe.toolRequirement.method_8088(buffer);
            buffer.method_10804(recipe.maxToolSize);
            recipe.requirements.write(buffer);
            buffer.method_10814(recipe.requirementsError);
            buffer.method_10812((class_2960)recipe.result.getId());
            buffer.method_10804(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
            buffer.writeBoolean(recipe.allowCrystal);
            buffer.method_10804(recipe.levels.size());
            for (LevelEntry level : recipe.levels) {
                level.write(buffer);
            }
        }
    }
}

