/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialFluidRecipe
implements ICustomOutputRecipe<ICastingContainer> {
    private final class_2960 id;
    private final FluidIngredient fluid;
    private final int temperature;
    @Nullable
    private final MaterialVariant input;
    private final MaterialVariant output;

    public MaterialFluidRecipe(class_2960 id, FluidIngredient fluid, int temperature, @Nullable MaterialVariantId inputId, MaterialVariantId outputId) {
        this.id = id;
        this.fluid = fluid;
        this.temperature = temperature;
        this.input = inputId == null ? null : MaterialVariant.of(inputId);
        this.output = MaterialVariant.of(outputId);
        MaterialCastingLookup.registerFluid(this);
    }

    public boolean matches(ICastingContainer inv) {
        if (this.output.isUnknown() || !this.fluid.test(inv.getFluid())) {
            return false;
        }
        if (this.input != null) {
            if (this.input.isUnknown()) {
                return false;
            }
            return this.input.matchesVariant(inv.getStack());
        }
        return true;
    }

    public long getFluidAmount(class_3611 fluid) {
        return this.fluid.getAmount(fluid);
    }

    public List<FluidStack> getFluids() {
        return this.fluid.getFluids();
    }

    public final boolean matches(ICastingContainer inv, class_1937 worldIn) {
        return this.matches(inv);
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerSmeltery.materialFluidRecipe.get();
    }

    public class_3956<?> method_17716() {
        return (class_3956)TinkerRecipeTypes.DATA.get();
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public int getTemperature() {
        return this.temperature;
    }

    @Nullable
    public MaterialVariant getInput() {
        return this.input;
    }

    public MaterialVariant getOutput() {
        return this.output;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<MaterialFluidRecipe> {
        public MaterialFluidRecipe fromJson(class_2960 id, JsonObject json) {
            FluidIngredient fluid = FluidIngredient.deserialize((JsonObject)json, (String)"fluid");
            int temperature = class_3518.method_15260((JsonObject)json, (String)"temperature");
            MaterialVariantId input = null;
            if (json.has("input")) {
                input = MaterialVariantId.fromJson(json, "input");
            }
            MaterialVariantId output = MaterialVariantId.fromJson(json, "output");
            return new MaterialFluidRecipe(id, fluid, temperature, input, output);
        }

        @Nullable
        protected MaterialFluidRecipe fromNetworkSafe(class_2960 id, class_2540 buffer) {
            FluidIngredient fluid = FluidIngredient.read((class_2540)buffer);
            int temperature = buffer.readInt();
            MaterialVariantId input = null;
            if (buffer.readBoolean()) {
                input = MaterialVariantId.parse(buffer.method_10800(Short.MAX_VALUE));
            }
            MaterialVariantId output = MaterialVariantId.parse(buffer.method_10800(Short.MAX_VALUE));
            return new MaterialFluidRecipe(id, fluid, temperature, input, output);
        }

        protected void toNetworkSafe(class_2540 buffer, MaterialFluidRecipe recipe) {
            recipe.fluid.write(buffer);
            buffer.writeInt(recipe.temperature);
            if (recipe.input != null) {
                buffer.writeBoolean(true);
                buffer.method_10814(recipe.input.getVariant().toString());
            } else {
                buffer.writeBoolean(false);
            }
            buffer.method_10814(recipe.output.getVariant().toString());
        }
    }
}

