/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ModifierAttribute {
    private final String name;
    private final class_1320 attribute;
    private final class_1322.class_1323 operation;
    private final float amount;
    private final UUID[] slotUUIDs;

    public ModifierAttribute(String name, class_1320 attribute, class_1322.class_1323 operation, float amount, List<class_1304> slots) {
        this.name = name;
        this.attribute = attribute;
        this.operation = operation;
        this.amount = amount;
        this.slotUUIDs = new UUID[6];
        for (class_1304 slot : slots) {
            this.slotUUIDs[slot.method_5926()] = ModifierAttribute.getUUID(name, slot);
        }
    }

    public ModifierAttribute(String name, class_1320 attribute, class_1322.class_1323 operation, float amount, class_1304 ... slots) {
        this.name = name;
        this.attribute = attribute;
        this.operation = operation;
        this.amount = amount;
        this.slotUUIDs = new UUID[6];
        for (class_1304 slot : slots) {
            this.slotUUIDs[slot.method_5926()] = ModifierAttribute.getUUID(name, slot);
        }
    }

    public void apply(IToolStackView tool, float level, class_1304 slot, BiConsumer<class_1320, class_1322> consumer) {
        UUID uuid = this.slotUUIDs[slot.method_5926()];
        if (uuid != null) {
            consumer.accept(this.attribute, new class_1322(uuid, this.name + "." + slot.method_5923(), (double)(this.amount * level), this.operation));
        }
    }

    public JsonObject toJson(JsonObject json) {
        json.addProperty("unique", this.name);
        json.addProperty("attribute", Objects.requireNonNull(class_7923.field_41190.method_10221((Object)this.attribute)).toString());
        json.addProperty("operation", this.operation.name().toLowerCase(Locale.ROOT));
        json.addProperty("amount", (Number)Float.valueOf(this.amount));
        JsonArray array = new JsonArray();
        for (class_1304 slot : class_1304.values()) {
            if (this.slotUUIDs[slot.method_5926()] == null) continue;
            array.add(slot.method_5923());
        }
        json.add("slots", (JsonElement)array);
        return json;
    }

    public JsonObject toJson() {
        return this.toJson(new JsonObject());
    }

    public static ModifierAttribute fromJson(JsonObject json) {
        String unique = class_3518.method_15265((JsonObject)json, (String)"unique");
        class_1320 attribute = (class_1320)JsonHelper.getAsEntry((class_2378)class_7923.field_41190, (JsonObject)json, (String)"attribute");
        class_1322.class_1323 op = (class_1322.class_1323)JsonHelper.getAsEnum((JsonObject)json, (String)"operation", class_1322.class_1323.class);
        float amount = class_3518.method_15259((JsonObject)json, (String)"amount");
        List slots = JsonHelper.parseList((JsonObject)json, (String)"slots", (element, string) -> class_1304.method_5924((String)class_3518.method_15287((JsonElement)element, (String)string)));
        return new ModifierAttribute(unique, attribute, op, amount, slots);
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_10814(this.name);
        buffer.method_10812(class_7923.field_41190.method_10221((Object)this.attribute));
        buffer.method_10817((Enum)this.operation);
        buffer.writeFloat(this.amount);
        int packed = 0;
        for (class_1304 slot : class_1304.values()) {
            if (this.slotUUIDs[slot.method_5926()] == null) continue;
            packed |= 1 << slot.method_5926();
        }
        buffer.writeInt(packed);
    }

    public static ModifierAttribute fromNetwork(class_2540 buffer) {
        String name = buffer.method_10800(Short.MAX_VALUE);
        class_1320 attribute = (class_1320)class_7923.field_41190.method_10223(buffer.method_10810());
        class_1322.class_1323 operation = (class_1322.class_1323)buffer.method_10818(class_1322.class_1323.class);
        float amount = buffer.readFloat();
        int packed = buffer.readInt();
        UUID[] slotUUIDs = new UUID[6];
        for (class_1304 slot : class_1304.values()) {
            if ((packed & 1 << slot.method_5926()) <= 0) continue;
            slotUUIDs[slot.method_5926()] = ModifierAttribute.getUUID(name, slot);
        }
        return new ModifierAttribute(name, attribute, operation, amount, slotUUIDs);
    }

    public static UUID getUUID(String name, class_1304 slot) {
        return UUID.nameUUIDFromBytes((name + "." + slot.method_5923()).getBytes());
    }

    private ModifierAttribute(String name, class_1320 attribute, class_1322.class_1323 operation, float amount, UUID[] slotUUIDs) {
        this.name = name;
        this.attribute = attribute;
        this.operation = operation;
        this.amount = amount;
        this.slotUUIDs = slotUUIDs;
    }
}

