/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import io.github.fabricators_of_create.porting_lib.data.ConditionalRecipe;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.tags.Tags;
import io.github.fabricators_of_create.porting_lib.util.TrueCondition;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.recipe.v1.ingredient.DefaultCustomIngredients;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.MetalItemObject;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.data.recipe.ICastCreationHelper;
import slimeknights.tconstruct.library.json.TagDifferencePresentCondition;
import slimeknights.tconstruct.library.json.TagIntersectionPresentCondition;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public interface ISmelteryRecipeHelper
extends ICastCreationHelper {
    default public void tagMelting(Consumer<class_2444> consumer, class_3611 fluid, long amount, String tagName, float factor, String recipePath, boolean isOptional) {
        Consumer wrapped = isOptional ? this.withCondition(consumer, new ConditionJsonProvider[]{this.tagCondition(tagName)}) : consumer;
        MeltingRecipeBuilder.melting(class_1856.method_8106((class_6862)this.getItemTag("c", tagName)), fluid, amount, factor).save(wrapped, this.modResource(recipePath));
    }

    default public void oreMelting(Consumer<class_2444> consumer, class_3611 fluid, long amount, String tagName, @Nullable class_6862<class_1792> size, float factor, String recipePath, boolean isOptional, IMeltingContainer.OreRateType oreRate, float byproductScale, IByproduct ... byproducts) {
        Consumer wrapped;
        class_1856 ingredient;
        class_1856 baseIngredient = class_1856.method_8106((class_6862)this.getItemTag("c", tagName));
        if (size == Tags.Items.ORE_RATES_SINGULAR) {
            ingredient = DefaultCustomIngredients.difference((class_1856)baseIngredient, (class_1856)DefaultCustomIngredients.any((class_1856[])new class_1856[]{class_1856.method_8106((class_6862)Tags.Items.ORE_RATES_SPARSE), class_1856.method_8106((class_6862)Tags.Items.ORE_RATES_DENSE)}));
            wrapped = this.withCondition(consumer, new ConditionJsonProvider[]{TagDifferencePresentCondition.ofKeys((class_6862<class_1792>)this.getItemTag("c", tagName), Tags.Items.ORE_RATES_SPARSE, Tags.Items.ORE_RATES_DENSE)});
        } else if (size != null) {
            ingredient = DefaultCustomIngredients.all((class_1856[])new class_1856[]{baseIngredient, class_1856.method_8106(size)});
            wrapped = this.withCondition(consumer, new ConditionJsonProvider[]{TagIntersectionPresentCondition.ofKeys(this.getItemTag("c", tagName), size)});
        } else {
            ingredient = baseIngredient;
            wrapped = isOptional ? this.withCondition(consumer, new ConditionJsonProvider[]{this.tagCondition(tagName)}) : consumer;
        }
        Supplier<MeltingRecipeBuilder> supplier = () -> MeltingRecipeBuilder.melting(ingredient, fluid, amount, factor).setOre(oreRate, new IMeltingContainer.OreRateType[0]);
        class_2960 location = this.modResource(recipePath);
        if (byproducts.length == 0) {
            supplier.get().save(wrapped, location);
        } else if (byproducts[0].isAlwaysPresent()) {
            supplier.get().addByproduct(new FluidStack(byproducts[0].getFluid(), (long)((int)((float)byproducts[0].getAmount() * byproductScale)))).save(wrapped, location);
        } else {
            ConditionalRecipe.Builder builder = ConditionalRecipe.builder();
            boolean alwaysPresent = false;
            for (IByproduct byproduct : byproducts) {
                alwaysPresent = byproduct.isAlwaysPresent();
                if (alwaysPresent) {
                    builder.addCondition((ConditionJsonProvider)TrueCondition.INSTANCE);
                } else {
                    builder.addCondition(this.tagCondition(byproduct.getName() + "_ingots"));
                }
                builder.addRecipe(supplier.get().addByproduct(new FluidStack(byproduct.getFluid(), (long)((int)((float)byproduct.getAmount() * byproductScale))))::save);
                if (alwaysPresent) break;
            }
            if (!alwaysPresent) {
                builder.addCondition((ConditionJsonProvider)TrueCondition.INSTANCE);
                builder.addRecipe(supplier.get()::save);
            }
            builder.build(wrapped, location);
        }
    }

    default public void georeMelting(Consumer<class_2444> consumer, class_3611 fluid, long unit, String name, String folder) {
        this.tagMelting(consumer, fluid, unit, "geore_shards/" + name, 1.0f, folder + "geore/shard", true);
        this.tagMelting(consumer, fluid, unit * 4L, "geore_blocks/" + name, 2.0f, folder + "geore/block", true);
        this.tagMelting(consumer, fluid, unit * 4L, "geore_clusters/" + name, 2.5f, folder + "geore/cluster", true);
        this.tagMelting(consumer, fluid, unit, "geore_small_buds/" + name, 1.0f, folder + "geore/bud_small", true);
        this.tagMelting(consumer, fluid, unit * 2L, "geore_medium_buds/" + name, 1.5f, folder + "geore/bud_medium", true);
        this.tagMelting(consumer, fluid, unit * 3L, "geore_large_buds/" + name, 2.0f, folder + "geore/bud_large", true);
    }

    default public void metalMelting(Consumer<class_2444> consumer, class_3611 fluid, String name, boolean hasOre, boolean hasDust, String folder, boolean isOptional, IByproduct ... byproducts) {
        String prefix = folder + "/" + name + "/";
        this.tagMelting(consumer, fluid, 81000L, name + "_blocks", 3.0f, prefix + "block", isOptional);
        this.tagMelting(consumer, fluid, 9000L, name + "_ingots", 1.0f, prefix + "ingot", isOptional);
        this.tagMelting(consumer, fluid, 1000L, "nuggets/" + name, 0.33333334f, prefix + "nugget", isOptional);
        if (hasOre) {
            this.oreMelting(consumer, fluid, 9000L, "raw_" + name + "_ores", null, 1.5f, prefix + "raw", isOptional, IMeltingContainer.OreRateType.METAL, 1.0f, byproducts);
            this.oreMelting(consumer, fluid, 81000L, "raw_" + name + "_blocks", null, 6.0f, prefix + "raw_block", isOptional, IMeltingContainer.OreRateType.METAL, 9.0f, byproducts);
            this.oreMelting(consumer, fluid, 9000L, name + "_ores", (class_6862<class_1792>)Tags.Items.ORE_RATES_SPARSE, 1.5f, prefix + "ore_sparse", isOptional, IMeltingContainer.OreRateType.METAL, 1.0f, byproducts);
            this.oreMelting(consumer, fluid, 18000L, name + "_ores", (class_6862<class_1792>)Tags.Items.ORE_RATES_SINGULAR, 2.5f, prefix + "ore_singular", isOptional, IMeltingContainer.OreRateType.METAL, 2.0f, byproducts);
            this.oreMelting(consumer, fluid, 54000L, name + "_ores", (class_6862<class_1792>)Tags.Items.ORE_RATES_DENSE, 4.5f, prefix + "ore_dense", isOptional, IMeltingContainer.OreRateType.METAL, 6.0f, byproducts);
            this.georeMelting(consumer, fluid, 9000L, name, prefix);
        }
        if (hasDust) {
            this.tagMelting(consumer, fluid, 9000L, name + "_dusts", 0.75f, prefix + "dust", true);
        }
        this.tagMelting(consumer, fluid, 9000L, name + "_plates", 1.0f, prefix + "plates", true);
        this.tagMelting(consumer, fluid, 36000L, name + "_gears", 2.0f, prefix + "gear", true);
        this.tagMelting(consumer, fluid, 3000L, name + "_coins", 0.6666667f, prefix + "coin", true);
        this.tagMelting(consumer, fluid, 4500L, name + "_rods", 0.2f, prefix + "rod", true);
        this.tagMelting(consumer, fluid, 4500L, name + "_wires", 0.2f, prefix + "wire", true);
        this.tagMelting(consumer, fluid, 9000L, "sheetmetals/" + name, 1.0f, prefix + "sheetmetal", true);
    }

    default public void metalMelting(Consumer<class_2444> consumer, class_3611 fluid, String name, boolean hasOre, String folder, boolean isOptional, IByproduct ... byproducts) {
        this.metalMelting(consumer, fluid, name, hasOre, true, folder, isOptional, byproducts);
    }

    default public void gemMelting(Consumer<class_2444> consumer, class_3611 fluid, String name, boolean hasOre, int blockSize, String folder, boolean isOptional, IByproduct ... byproducts) {
        String prefix = folder + "/" + name + "/";
        this.tagMelting(consumer, fluid, 8100 * blockSize, name + "_blocks", (float)Math.sqrt(blockSize), prefix + "block", isOptional);
        this.tagMelting(consumer, fluid, 8100L, name + "_gems", 1.0f, prefix + "gem", isOptional);
        if (hasOre) {
            this.oreMelting(consumer, fluid, 4050L, name + "_ores", (class_6862<class_1792>)Tags.Items.ORE_RATES_SPARSE, 1.0f, prefix + "ore_sparse", isOptional, IMeltingContainer.OreRateType.GEM, 0.5f, byproducts);
            this.oreMelting(consumer, fluid, 8100L, name + "_ores", (class_6862<class_1792>)Tags.Items.ORE_RATES_SINGULAR, 1.5f, prefix + "ore_singular", isOptional, IMeltingContainer.OreRateType.GEM, 1.0f, byproducts);
            this.oreMelting(consumer, fluid, 24300L, name + "_ores", (class_6862<class_1792>)Tags.Items.ORE_RATES_DENSE, 4.5f, prefix + "ore_dense", isOptional, IMeltingContainer.OreRateType.GEM, 3.0f, byproducts);
            this.georeMelting(consumer, fluid, 8100L, name, prefix);
        }
    }

    default public void castingWithCast(Consumer<class_2444> consumer, FluidObject<?> fluid, boolean forgeTag, long amount, CastItemObject cast, ItemOutput output, String location) {
        ItemCastingRecipeBuilder.tableRecipe(output).setFluidAndTime(fluid, forgeTag, amount).setCast(cast.getMultiUseTag(), false).save(consumer, this.modResource(location + "_gold_cast"));
        ItemCastingRecipeBuilder.tableRecipe(output).setFluidAndTime(fluid, forgeTag, amount).setCast(cast.getSingleUseTag(), true).save(consumer, this.modResource(location + "_sand_cast"));
    }

    default public void castingWithCast(Consumer<class_2444> consumer, FluidObject<?> fluid, long amount, CastItemObject cast, ItemOutput output, String location) {
        this.castingWithCast(consumer, fluid, false, amount, cast, output, location);
    }

    default public void castingWithCast(Consumer<class_2444> consumer, FluidObject<?> fluid, boolean forgeTag, long amount, CastItemObject cast, class_1935 output, String location) {
        this.castingWithCast(consumer, fluid, forgeTag, amount, cast, ItemOutput.fromItem((class_1935)output), location);
    }

    default public void castingWithCast(Consumer<class_2444> consumer, FluidObject<?> fluid, long amount, CastItemObject cast, class_1935 output, String location) {
        this.castingWithCast(consumer, fluid, amount, cast, ItemOutput.fromItem((class_1935)output), location);
    }

    default public void tagCasting(Consumer<class_2444> consumer, FluidObject<?> fluid, boolean forgeTag, long amount, CastItemObject cast, String tagName, String recipeName, boolean optional) {
        if (optional) {
            consumer = this.withCondition(consumer, new ConditionJsonProvider[]{this.tagCondition(tagName)});
        }
        this.castingWithCast((Consumer<class_2444>)consumer, fluid, forgeTag, amount, cast, ItemOutput.fromTag((class_6862)this.getItemTag("c", tagName), (int)1), recipeName);
    }

    default public void tagCasting(Consumer<class_2444> consumer, FluidObject<?> fluid, int amount, CastItemObject cast, String tagName, String recipeName, boolean optional) {
        this.tagCasting(consumer, fluid, false, amount, cast, tagName, recipeName, optional);
    }

    default public void ingotCasting(Consumer<class_2444> consumer, FluidObject<?> fluid, boolean forgeTag, long amount, class_1935 ingot, String location) {
        this.castingWithCast(consumer, fluid, forgeTag, amount, TinkerSmeltery.ingotCast, ingot, location);
    }

    default public void ingotCasting(Consumer<class_2444> consumer, FluidObject<?> fluid, boolean forgeTag, class_1935 ingot, String location) {
        this.ingotCasting(consumer, fluid, forgeTag, 9000L, ingot, location);
    }

    default public void ingotCasting(Consumer<class_2444> consumer, FluidObject<?> fluid, long amount, class_1935 ingot, String location) {
        this.ingotCasting(consumer, fluid, false, amount, ingot, location);
    }

    default public void ingotCasting(Consumer<class_2444> consumer, FluidObject<?> fluid, class_1935 ingot, String location) {
        this.ingotCasting(consumer, fluid, 9000L, ingot, location);
    }

    default public void gemCasting(Consumer<class_2444> consumer, FluidObject<?> fluid, class_1935 gem, String location) {
        this.castingWithCast(consumer, fluid, 8100L, TinkerSmeltery.gemCast, gem, location);
    }

    default public void nuggetCasting(Consumer<class_2444> consumer, FluidObject<?> fluid, boolean forgeTag, class_1935 nugget, String location) {
        this.castingWithCast(consumer, fluid, forgeTag, 1000L, TinkerSmeltery.nuggetCast, nugget, location);
    }

    default public void nuggetCastingRecipe(Consumer<class_2444> consumer, FluidObject<?> fluid, class_1935 nugget, String location) {
        this.nuggetCasting(consumer, fluid, false, nugget, location);
    }

    default public void metalCasting(Consumer<class_2444> consumer, FluidObject<?> fluid, boolean forgeTag, @Nullable class_1935 block, @Nullable class_1935 ingot, @Nullable class_1935 nugget, String folder, String metal) {
        String metalFolder = folder + metal + "/";
        if (block != null) {
            ItemCastingRecipeBuilder.basinRecipe(block).setFluidAndTime(fluid, forgeTag, 81000L).save(consumer, this.modResource(metalFolder + "block"));
        }
        if (ingot != null) {
            this.ingotCasting(consumer, fluid, forgeTag, ingot, metalFolder + "ingot");
        }
        if (nugget != null) {
            this.nuggetCasting(consumer, fluid, forgeTag, nugget, metalFolder + "nugget");
        }
        this.tagCasting(consumer, fluid, forgeTag, 9000L, TinkerSmeltery.plateCast, metal + "_plates", folder + metal + "/plate", true);
        this.tagCasting(consumer, fluid, forgeTag, 36000L, TinkerSmeltery.gearCast, metal + "_gears", folder + metal + "/gear", true);
        this.tagCasting(consumer, fluid, forgeTag, 3000L, TinkerSmeltery.coinCast, metal + "_coins", folder + metal + "/coin", true);
        this.tagCasting(consumer, fluid, forgeTag, 4500L, TinkerSmeltery.rodCast, metal + "_rods", folder + metal + "/rod", true);
        this.tagCasting(consumer, fluid, forgeTag, 4500L, TinkerSmeltery.wireCast, metal + "_wires", folder + metal + "/wire", true);
    }

    default public void metalCasting(Consumer<class_2444> consumer, FluidObject<?> fluid, @Nullable class_1935 block, @Nullable class_1935 ingot, @Nullable class_1935 nugget, String folder, String metal) {
        this.metalCasting(consumer, fluid, false, block, ingot, nugget, folder, metal);
    }

    default public void metalCasting(Consumer<class_2444> consumer, FluidObject<?> fluid, MetalItemObject metal, String folder, String name) {
        this.metalCasting(consumer, fluid, metal.get(), (class_1935)metal.getIngot(), (class_1935)metal.getNugget(), folder, name);
    }

    default public void metalTagCasting(Consumer<class_2444> consumer, FluidObject<?> fluid, String name, String folder, boolean forceStandard) {
        this.tagCasting(consumer, fluid, true, 1000L, TinkerSmeltery.nuggetCast, name + "_nuggets", folder + name + "/nugget", !forceStandard);
        this.tagCasting(consumer, fluid, true, 9000L, TinkerSmeltery.ingotCast, name + "_ingots", folder + name + "/ingot", !forceStandard);
        this.tagCasting(consumer, fluid, true, 9000L, TinkerSmeltery.plateCast, name + "_plates", folder + name + "/plate", true);
        this.tagCasting(consumer, fluid, true, 36000L, TinkerSmeltery.gearCast, name + "_gears", folder + name + "/gear", true);
        this.tagCasting(consumer, fluid, true, 3000L, TinkerSmeltery.coinCast, name + "_coins", folder + name + "/coin", true);
        this.tagCasting(consumer, fluid, true, 4500L, TinkerSmeltery.rodCast, name + "_rods", folder + name + "/rod", true);
        this.tagCasting(consumer, fluid, true, 4500L, TinkerSmeltery.wireCast, name + "_wires", folder + name + "/wire", true);
        class_6862 block = this.getItemTag("c", name + "_blocks");
        Consumer wrapped = forceStandard ? consumer : this.withCondition(consumer, new ConditionJsonProvider[]{this.tagCondition(name + "_blocks")});
        ItemCastingRecipeBuilder.basinRecipe((class_6862<class_1792>)block).setFluidAndTime(fluid, true, 81000L).save(wrapped, this.modResource(folder + name + "/block"));
    }
}

