/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1093;
import net.minecraft.class_1100;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_7775;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_806;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.data.IModelData;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.client.model.block.TankModel;
import slimeknights.tconstruct.smeltery.block.entity.tank.IDisplayFluidListener;

public class FluidTextureModel
implements IUnbakedGeometry<FluidTextureModel> {
    public static final Loader LOADER = new Loader();
    private final ColoredBlockModel model;
    private final Set<String> fluids;
    private final Set<String> retextured;

    public void resolveParents(Function<class_2960, class_1100> modelGetter, class_793 owner) {
        this.model.resolveParents(modelGetter, owner);
    }

    private static String trimTextureName(String name) {
        if (name.charAt(0) == '#') {
            return name.substring(1);
        }
        return name;
    }

    public class_1087 bake(class_793 owner, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 transform, class_806 overrides, class_2960 modelLocation, boolean isGui3d) {
        class_1087 baked = this.model.bake(owner, baker, spriteGetter, transform, overrides, modelLocation, isGui3d);
        Set fluidTextures = this.fluids.isEmpty() ? Collections.emptySet() : RetexturedModel.getAllRetextured((class_793)owner, (SimpleBlockModel)this.model.getModel(), this.fluids);
        List elements = this.model.getElements();
        int size = elements.size();
        BitSet fluidParts = new BitSet(size);
        if (!fluidTextures.isEmpty()) {
            for (int i = 0; i < size; ++i) {
                class_785 part = (class_785)elements.get(i);
                long fluidFaces = part.field_4230.values().stream().filter(face -> fluidTextures.contains(FluidTextureModel.trimTextureName(face.field_4224))).count();
                if (fluidFaces <= 0L) continue;
                if (fluidFaces < (long)part.field_4230.size()) {
                    TConstruct.LOG.warn("Mixed fluid and non-fluid elements in model {}, may cause unexpected results", (Object)modelLocation);
                }
                fluidParts.set(i);
            }
        }
        Set retextured = this.retextured.isEmpty() ? Collections.emptySet() : RetexturedModel.getAllRetextured((class_793)owner, (SimpleBlockModel)this.model.getModel(), this.retextured);
        return new Baked(baked, elements, this.model.getColorData(), owner, transform, fluidTextures, fluidParts, retextured);
    }

    public FluidTextureModel(ColoredBlockModel model, Set<String> fluids, Set<String> retextured) {
        this.model = model;
        this.fluids = fluids;
        this.retextured = retextured;
    }

    private static class Baked
    extends DynamicBakedWrapper<class_1087> {
        private final Map<BakedCacheKey, class_1087> cache = new ConcurrentHashMap<BakedCacheKey, class_1087>();
        private final List<class_785> elements;
        private final List<ColoredBlockModel.ColorData> colorData;
        private final class_793 owner;
        private final class_3665 transform;
        private final Set<String> fluids;
        private final BitSet fluidParts;
        private final Set<String> retextured;

        protected Baked(class_1087 originalModel, List<class_785> elements, List<ColoredBlockModel.ColorData> colorData, class_793 owner, class_3665 transform, Set<String> fluids, BitSet fluidParts, Set<String> retextured) {
            super(originalModel);
            this.elements = elements;
            this.colorData = colorData;
            this.owner = owner;
            this.transform = transform;
            this.fluids = fluids;
            this.fluidParts = fluidParts;
            this.retextured = retextured;
        }

        private class_1087 getRetexturedModel(BakedCacheKey key) {
            Function<class_4730, class_1058> spriteGetter = class_4730::method_24148;
            class_793 textured = this.owner;
            if (key.texture != null) {
                textured = new RetexturedModel.RetexturedConfiguration(textured, this.retextured, key.texture);
            }
            int color = -1;
            int luminosity = 0;
            if (!key.fluid.isEmpty()) {
                color = FluidVariantRendering.getColor((FluidVariant)key.fluid.getType());
                luminosity = FluidVariantAttributes.getLuminance((FluidVariant)key.fluid.getType());
                textured = new RetexturedModel.RetexturedConfiguration(textured, this.fluids, FluidVariantRendering.getSprite((FluidVariant)key.fluid.getType()).method_45851().method_45816());
            }
            class_1058 particle = spriteGetter.apply(textured.method_24077("particle"));
            class_1093.class_1094 builder = new class_1093.class_1094(this.owner.method_3444(), this.owner.method_24298().method_24299(), true, this.owner.method_3443(), class_806.field_4292).method_4747(particle);
            boolean defaultUvLock = this.transform.method_3512();
            int size = this.elements.size();
            for (int i = 0; i < size; ++i) {
                class_785 element = this.elements.get(i);
                ColoredBlockModel.ColorData colors = (ColoredBlockModel.ColorData)LogicHelper.getOrDefault(this.colorData, (int)i, (Object)ColoredBlockModel.ColorData.DEFAULT);
                if (this.fluidParts.get(i)) {
                    ColoredBlockModel.bakePart((class_1093.class_1094)builder, (class_793)textured, (class_785)element, (int)color, (int)luminosity, (class_4590)this.transform.method_3509(), (boolean)colors.isUvLock(defaultUvLock), spriteGetter, (class_2960)TankModel.BAKE_LOCATION);
                    continue;
                }
                ColoredBlockModel.bakePart((class_1093.class_1094)builder, (class_793)textured, (class_785)element, (int)colors.color(), (int)colors.luminosity(), (class_4590)this.transform.method_3509(), (boolean)colors.isUvLock(defaultUvLock), spriteGetter, (class_2960)TankModel.BAKE_LOCATION);
            }
            return builder.method_4746();
        }

        private class_1087 getCachedModel(BakedCacheKey key) {
            return this.cache.computeIfAbsent(key, this::getRetexturedModel);
        }

        public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
            RenderAttachedBlockView renderAttachedBlockView;
            Object object;
            if (blockView instanceof RenderAttachedBlockView && (object = (renderAttachedBlockView = (RenderAttachedBlockView)blockView).getBlockEntityRenderAttachment(pos)) instanceof IModelData) {
                class_2248 block;
                FluidStack fluid;
                IModelData data = (IModelData)object;
                FluidStack fluidStack = fluid = this.fluids.isEmpty() ? FluidStack.EMPTY : (FluidStack)data.getData(IDisplayFluidListener.PROPERTY);
                if (fluid == null) {
                    fluid = FluidStack.EMPTY;
                }
                class_2248 class_22482 = block = this.retextured.isEmpty() ? null : (class_2248)data.getData(RetexturedHelper.BLOCK_PROPERTY);
                if (!fluid.isEmpty() || block != null) {
                    BakedCacheKey key = new BakedCacheKey(fluid, block != null ? slimeknights.mantle.client.model.util.ModelHelper.getParticleTexture((class_2248)block) : null);
                    this.getCachedModel(key).emitBlockQuads(blockView, state, pos, randomSupplier, context);
                    return;
                }
            }
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        }

        public class_806 method_4710() {
            return RetexturedOverride.INSTANCE;
        }
    }

    private static class Loader
    implements IGeometryLoader<FluidTextureModel> {
        private Loader() {
        }

        public FluidTextureModel read(JsonObject json, JsonDeserializationContext context) {
            ColoredBlockModel model = ColoredBlockModel.deserialize((JsonDeserializationContext)context, (JsonObject)json);
            ImmutableSet fluids = Collections.emptySet();
            if (json.has("fluids")) {
                fluids = ImmutableSet.copyOf((Collection)JsonHelper.parseList((JsonObject)json, (String)"fluids", class_3518::method_15287));
            }
            ImmutableSet retextured = Collections.emptySet();
            if (json.has("retextured")) {
                retextured = ImmutableSet.copyOf((Collection)JsonHelper.parseList((JsonObject)json, (String)"retextured", class_3518::method_15287));
            }
            return new FluidTextureModel(model, (Set<String>)fluids, (Set<String>)retextured);
        }
    }

    private static class RetexturedOverride
    extends class_806 {
        private static final RetexturedOverride INSTANCE = new RetexturedOverride();

        private RetexturedOverride() {
        }

        @Nullable
        public class_1087 method_3495(class_1087 originalModel, class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int pSeed) {
            if (stack.method_7960() || !stack.method_7985()) {
                return originalModel;
            }
            class_2248 block = RetexturedBlockItem.getTexture((class_1799)stack);
            if (block == class_2246.field_10124) {
                return originalModel;
            }
            if (originalModel instanceof Baked) {
                Baked baked = (Baked)originalModel;
                return baked.getCachedModel(new BakedCacheKey(FluidStack.EMPTY, slimeknights.mantle.client.model.util.ModelHelper.getParticleTexture((class_2248)block)));
            }
            return ModelHelper.unwrap(originalModel, Baked.class).getCachedModel(new BakedCacheKey(FluidStack.EMPTY, slimeknights.mantle.client.model.util.ModelHelper.getParticleTexture((class_2248)block)));
        }
    }

    private record BakedCacheKey(FluidStack fluid, @Nullable class_2960 texture) {
    }
}

