/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier0.block.blockplacer;

import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import reborncore.common.blockentity.RedstoneConfiguration;
import techreborn.blockentity.machine.tier0.block.BlockProcessable;
import techreborn.blockentity.machine.tier0.block.BlockProcessor;
import techreborn.blockentity.machine.tier0.block.BlockProcessorUtils;
import techreborn.blockentity.machine.tier0.block.ProcessingStatus;
import techreborn.blockentity.machine.tier0.block.blockplacer.BlockPlacerNbt;
import techreborn.blockentity.machine.tier0.block.blockplacer.BlockPlacerStatus;

public class BlockPlacerProcessor
extends BlockPlacerNbt
implements BlockProcessor {
    private final BlockProcessable processable;
    private final int inputSlot;
    private final int fakeOutputSlot;
    private final int basePlaceTime;
    private final int baseCostToPlace;

    public BlockPlacerProcessor(BlockProcessable processable, int inputSlot, int fakeOutputSlot, int basePlaceTime, int baseCostToPlace) {
        this.processable = processable;
        this.inputSlot = inputSlot;
        this.fakeOutputSlot = fakeOutputSlot;
        this.basePlaceTime = basePlaceTime;
        this.baseCostToPlace = baseCostToPlace;
    }

    @Override
    public ProcessingStatus getStatusEnum() {
        return this.status;
    }

    @Override
    public int getCurrentTickTime() {
        return this.getCurrentPlaceTime();
    }

    @Override
    public int getTickTime() {
        return this.getPlaceTime();
    }

    @Override
    public ProcessingStatus onTick(class_1937 world, class_2338 positionInFront) {
        if (!this.ensureRedstoneEnabled()) {
            return this.status;
        }
        if (!this.handleInterrupted()) {
            return this.status;
        }
        class_1799 inputItemStack = this.processable.getInventory().method_5438(this.inputSlot);
        if (!this.handleInputSlotEmptied(inputItemStack)) {
            return this.status;
        }
        class_2680 blockInFront = world.method_8320(positionInFront);
        if (!this.ensureEnoughItemsToPlace(inputItemStack)) {
            return this.status;
        }
        if (!this.ensureBlockCanBePlaced(blockInFront, inputItemStack, 1.0f)) {
            return this.status;
        }
        class_1792 currentPlacingItem = this.processable.getInventory().method_5438(this.fakeOutputSlot).method_7909();
        class_1799 fakeItem = inputItemStack.method_7972();
        if (fakeItem.method_31574(class_1802.field_8162)) {
            currentPlacingItem = null;
        }
        this.processable.getInventory().method_5447(this.fakeOutputSlot, fakeItem);
        class_2680 resultingBlockState = class_2248.method_9503((class_1792)inputItemStack.method_7909()).method_9564();
        float hardness = BlockProcessorUtils.getHardness(world, resultingBlockState, positionInFront);
        this.placeTime = BlockProcessorUtils.getProcessTimeWithHardness(this.processable, this.basePlaceTime, hardness);
        if (!this.ensureItemNotReplaced(currentPlacingItem, inputItemStack)) {
            return this.status;
        }
        if (!this.increasePlaceTime()) {
            return this.status;
        }
        BlockProcessorUtils.playSound(this.processable, this.currentPlaceTime);
        this.placeBlock(world, positionInFront, inputItemStack);
        this.status = BlockPlacerStatus.PROCESSING;
        return this.status;
    }

    private boolean ensureRedstoneEnabled() {
        if (!this.processable.isActive(RedstoneConfiguration.RECIPE_PROCESSING)) {
            return this.breakControlFlow(BlockPlacerStatus.IDLE_PAUSED);
        }
        return true;
    }

    private boolean handleInterrupted() {
        if (this.currentPlaceTime < 0) {
            ++this.currentPlaceTime;
            return false;
        }
        return true;
    }

    private boolean handleInputSlotEmptied(class_1799 inputStack) {
        if (inputStack.method_31574(class_1799.field_8037.method_7909())) {
            this.processable.getInventory().method_5447(this.fakeOutputSlot, class_1799.field_8037);
            this.resetProcessing(0);
        }
        return true;
    }

    private boolean ensureEnoughItemsToPlace(class_1799 currentStack) {
        if (currentStack.method_7947() <= 0) {
            return this.breakControlFlow(BlockPlacerStatus.IDLE);
        }
        return true;
    }

    private boolean ensureBlockCanBePlaced(class_2680 blockInFront, class_1799 fakeItem, float hardness) {
        class_2680 blockState = class_2248.method_9503((class_1792)fakeItem.method_7909()).method_9564();
        if (blockState.method_26215() || hardness < 0.0f) {
            return this.breakControlFlow(BlockPlacerStatus.IDLE);
        }
        if (!blockInFront.method_26215()) {
            return this.breakControlFlow(BlockPlacerStatus.OUTPUT_BLOCKED);
        }
        return true;
    }

    private boolean ensureItemNotReplaced(class_1792 currentPlacingItem, class_1799 item) {
        if (currentPlacingItem != null && !class_1799.field_8037.method_31574(currentPlacingItem) && !item.method_31574(currentPlacingItem)) {
            return this.breakControlFlow(BlockPlacerStatus.INTERRUPTED);
        }
        return true;
    }

    private boolean increasePlaceTime() {
        if (!this.processable.consumeEnergy(this.baseCostToPlace)) {
            return this.breakControlFlow(BlockPlacerStatus.NO_ENERGY);
        }
        ++this.currentPlaceTime;
        return true;
    }

    private void placeBlock(class_1937 world, class_2338 positionInFront, class_1799 currentStack) {
        if (this.currentPlaceTime >= this.placeTime) {
            class_1799 itemStack = this.processable.getInventory().method_5438(this.inputSlot);
            world.method_8501(positionInFront, class_2248.method_9503((class_1792)currentStack.method_7909()).method_9564());
            itemStack.method_7939(itemStack.method_7947() - 1);
            this.resetProcessing(0);
        }
    }

    private void resetProcessing(int tick) {
        this.currentPlaceTime = tick;
        this.placeTime = this.basePlaceTime;
        this.processable.getInventory().method_5447(this.fakeOutputSlot, class_1799.field_8037);
    }

    private boolean breakControlFlow(ProcessingStatus status) {
        this.resetProcessing(-20);
        this.status = status;
        return false;
    }
}

