/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.capabilities.CombinedEnergyStorage;
import com.supermartijn642.tesseract.capabilities.CombinedFluidHandler;
import com.supermartijn642.tesseract.capabilities.CombinedItemHandler;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class Channel {
    public final int id;
    public final EnumChannelType type;
    public UUID creator;
    public boolean isPrivate = false;
    public String name;
    public final Set<TesseractReference> tesseracts = new LinkedHashSet<TesseractReference>();
    public final Set<TesseractReference> sendingTesseracts = new LinkedHashSet<TesseractReference>();
    public final Set<TesseractReference> receivingTesseracts = new LinkedHashSet<TesseractReference>();

    public Channel(int id, EnumChannelType type, UUID creator, boolean isPrivate, String name) {
        this.id = id;
        this.type = type;
        this.creator = creator;
        this.isPrivate = isPrivate;
        this.name = name;
    }

    public Channel(int id, EnumChannelType type, class_2487 compound) {
        this.id = id;
        this.type = type;
        this.read(compound);
    }

    public String getName() {
        return this.name;
    }

    public void addTesseract(TesseractReference tesseract) {
        if (!this.tesseracts.contains(tesseract)) {
            this.tesseracts.add(tesseract);
            if (tesseract.canSend(this.type)) {
                this.sendingTesseracts.add(tesseract);
            }
            if (tesseract.canReceive(this.type)) {
                this.receivingTesseracts.add(tesseract);
            }
            if (tesseract.getChannelId(this.type) != this.id) {
                tesseract.setChannel(this.type, this.id);
            }
        }
    }

    public void removeTesseract(TesseractReference tesseract) {
        this.tesseracts.remove(tesseract);
        this.sendingTesseracts.remove(tesseract);
        this.receivingTesseracts.remove(tesseract);
    }

    public void updateTesseract(TesseractReference tesseract) {
        if (tesseract.canSend(this.type)) {
            this.sendingTesseracts.add(tesseract);
        } else {
            this.sendingTesseracts.remove(tesseract);
        }
        if (tesseract.canReceive(this.type)) {
            this.receivingTesseracts.add(tesseract);
        } else {
            this.receivingTesseracts.remove(tesseract);
        }
    }

    public class_2487 write() {
        class_2487 compound = new class_2487();
        compound.method_25927("creator", this.creator);
        compound.method_10556("private", this.isPrivate);
        compound.method_10582("name", this.name);
        class_2487 tesseractCompound = new class_2487();
        Iterator<TesseractReference> iterator = this.tesseracts.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            tesseractCompound.method_10566("tesseract" + i, (class_2520)TesseractTracker.SERVER.writeKey(iterator.next()));
            ++i;
        }
        compound.method_10566("references", (class_2520)tesseractCompound);
        return compound;
    }

    public void read(class_2487 compound) {
        this.creator = compound.method_25926("creator");
        this.isPrivate = compound.method_10577("private");
        this.name = compound.method_10558("name");
        this.tesseracts.clear();
        this.sendingTesseracts.clear();
        this.receivingTesseracts.clear();
        class_2487 tesseractCompound = compound.method_10562("references");
        for (String key : tesseractCompound.method_10541()) {
            TesseractReference reference = TesseractTracker.SERVER.fromKey(tesseractCompound.method_10562(key));
            if (reference == null) continue;
            this.addTesseract(reference);
        }
        if (compound.method_10545("tesseracts")) {
            tesseractCompound = compound.method_10562("tesseracts");
            for (String key : tesseractCompound.method_10541()) {
                class_2338 pos;
                class_2487 compound2 = tesseractCompound.method_10562(key);
                String dimension = compound2.method_10558("dim");
                TesseractReference reference = TesseractTracker.SERVER.getReference(dimension, pos = new class_2338(compound2.method_10550("posx"), compound2.method_10550("posy"), compound2.method_10550("posz")));
                if (reference == null) continue;
                this.addTesseract(reference);
            }
        }
    }

    public class_2487 writeClientChannel() {
        class_2487 tag = new class_2487();
        tag.method_10569("id", this.id);
        tag.method_10569("type", this.type.getIndex());
        tag.method_25927("creator", this.creator);
        tag.method_10556("private", this.isPrivate);
        tag.method_10582("name", this.name);
        return tag;
    }

    public static Channel readClientChannel(class_2487 tag) {
        int id = tag.method_10550("id");
        EnumChannelType type = EnumChannelType.byIndex(tag.method_10550("type"));
        UUID creator = tag.method_25926("creator");
        boolean isPrivate = tag.method_10577("private");
        String name = tag.method_10558("name");
        return new Channel(id, type, creator, isPrivate, name);
    }

    public CombinedItemHandler getItemHandler(TesseractBlockEntity self) {
        return new CombinedItemHandler(this, self);
    }

    public CombinedFluidHandler getFluidHandler(TesseractBlockEntity self) {
        return new CombinedFluidHandler(this, self);
    }

    public CombinedEnergyStorage getEnergyStorage(TesseractBlockEntity self) {
        return new CombinedEnergyStorage(this, self);
    }

    public int hashCode() {
        return this.id + 31 * this.type.hashCode();
    }

    public void delete() {
        for (TesseractReference location : this.tesseracts) {
            location.setChannel(this.type, -1);
        }
    }
}

