/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.capabilities;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.capabilities.FlatMapIterator;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import java.util.Collections;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class CombinedFluidHandler
implements Storage<FluidVariant> {
    private final Channel channel;
    private final TesseractBlockEntity requester;

    public CombinedFluidHandler(Channel channel, TesseractBlockEntity requester) {
        this.channel = channel;
        this.requester = requester;
    }

    public boolean supportsInsertion() {
        return this.requester.canSend(EnumChannelType.FLUID);
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.pushRecurrentCall()) {
            return 0L;
        }
        if (!this.requester.canSend(EnumChannelType.FLUID) || resource.isBlank()) {
            this.popRecurrentCall();
            return 0L;
        }
        long leftOver = maxAmount;
        block0: for (TesseractReference reference : this.channel.receivingTesseracts) {
            TesseractBlockEntity entity;
            if (!reference.canBeAccessed() || (entity = reference.getTesseract()) == this.requester) continue;
            for (Storage handler : entity.getSurroundingCapabilities(FluidStorage.SIDED)) {
                if (!handler.supportsInsertion() || (leftOver -= handler.insert((Object)resource, leftOver, transaction)) > 0L) continue;
                break block0;
            }
        }
        this.popRecurrentCall();
        return maxAmount - leftOver;
    }

    public boolean supportsExtraction() {
        return this.requester.canReceive(EnumChannelType.FLUID);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.pushRecurrentCall()) {
            return 0L;
        }
        if (!this.requester.canReceive(EnumChannelType.FLUID) || resource.isBlank()) {
            this.popRecurrentCall();
            return 0L;
        }
        long leftOver = maxAmount;
        block0: for (TesseractReference reference : this.channel.sendingTesseracts) {
            TesseractBlockEntity entity;
            if (!reference.canBeAccessed() || (entity = reference.getTesseract()) == this.requester) continue;
            for (Storage handler : entity.getSurroundingCapabilities(FluidStorage.SIDED)) {
                if (!handler.supportsExtraction() || (leftOver -= handler.extract((Object)resource, leftOver, transaction)) > 0L) continue;
                break block0;
            }
        }
        this.popRecurrentCall();
        return maxAmount - leftOver;
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        Iterator<TesseractReference> tesseracts = this.channel.tesseracts.iterator();
        return new FlatMapIterator(new FlatMapIterator(tesseracts, reference -> {
            TesseractBlockEntity entity;
            if (reference.canBeAccessed() && (entity = reference.getTesseract()) != this.requester) {
                return entity.getSurroundingCapabilities(FluidStorage.SIDED).iterator();
            }
            return Collections.emptyIterator();
        }, this::pushRecurrentCall, this::popRecurrentCall), Storage::iterator);
    }

    private boolean pushRecurrentCall() {
        if (this.requester.recurrentCalls >= 1) {
            return true;
        }
        ++this.requester.recurrentCalls;
        return false;
    }

    private void popRecurrentCall() {
        --this.requester.recurrentCalls;
    }
}

