/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.capabilities;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import team.reborn.energy.api.EnergyStorage;

public class CombinedEnergyStorage
implements EnergyStorage {
    private final Channel channel;
    private final TesseractBlockEntity requester;

    public CombinedEnergyStorage(Channel channel, TesseractBlockEntity requester) {
        this.channel = channel;
        this.requester = requester;
    }

    public boolean supportsInsertion() {
        return this.requester.canSend(EnumChannelType.ENERGY);
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        if (this.pushRecurrentCall()) {
            return 0L;
        }
        if (!this.requester.canSend(EnumChannelType.ENERGY) || maxAmount <= 0L) {
            this.popRecurrentCall();
            return 0L;
        }
        long leftOver = maxAmount;
        block0: for (TesseractReference reference : this.channel.receivingTesseracts) {
            TesseractBlockEntity entity;
            if (!reference.canBeAccessed() || (entity = reference.getTesseract()) == this.requester) continue;
            for (EnergyStorage handler : entity.getSurroundingCapabilities(EnergyStorage.SIDED)) {
                if (!handler.supportsInsertion() || (leftOver -= handler.insert(leftOver, transaction)) > 0L) continue;
                break block0;
            }
        }
        this.popRecurrentCall();
        return maxAmount - leftOver;
    }

    public boolean supportsExtraction() {
        return this.requester.canReceive(EnumChannelType.ENERGY);
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        if (this.pushRecurrentCall()) {
            return 0L;
        }
        if (!this.requester.canReceive(EnumChannelType.ENERGY) || maxAmount <= 0L) {
            this.popRecurrentCall();
            return 0L;
        }
        long leftOver = maxAmount;
        block0: for (TesseractReference reference : this.channel.receivingTesseracts) {
            TesseractBlockEntity entity;
            if (!reference.canBeAccessed() || (entity = reference.getTesseract()) == this.requester) continue;
            for (EnergyStorage handler : entity.getSurroundingCapabilities(EnergyStorage.SIDED)) {
                if (!handler.supportsExtraction() || (leftOver -= handler.extract(leftOver, transaction)) > 0L) continue;
                break block0;
            }
        }
        this.popRecurrentCall();
        return maxAmount - leftOver;
    }

    public long getAmount() {
        if (this.pushRecurrentCall()) {
            return 0L;
        }
        long energy = 0L;
        for (TesseractReference reference : this.channel.receivingTesseracts) {
            TesseractBlockEntity entity;
            if (!reference.canBeAccessed() || (entity = reference.getTesseract()) == this.requester) continue;
            for (EnergyStorage handler : entity.getSurroundingCapabilities(EnergyStorage.SIDED)) {
                energy += handler.getAmount();
            }
        }
        this.popRecurrentCall();
        return energy;
    }

    public long getCapacity() {
        if (this.pushRecurrentCall()) {
            return 0L;
        }
        long capacity = 0L;
        for (TesseractReference reference : this.channel.receivingTesseracts) {
            TesseractBlockEntity entity;
            if (!reference.canBeAccessed() || (entity = reference.getTesseract()) == this.requester) continue;
            for (EnergyStorage handler : entity.getSurroundingCapabilities(EnergyStorage.SIDED)) {
                capacity += handler.getCapacity();
            }
        }
        this.popRecurrentCall();
        return capacity;
    }

    private boolean pushRecurrentCall() {
        if (this.requester.recurrentCalls >= 1) {
            return true;
        }
        ++this.requester.recurrentCalls;
        return false;
    }

    private void popRecurrentCall() {
        --this.requester.recurrentCalls;
    }
}

