/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.RedstoneState;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TransferState;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public class TesseractBlockEntity
extends BaseBlockEntity {
    private TesseractReference reference;
    private final EnumMap<EnumChannelType, TransferState> transferState = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, Object> capabilities = new EnumMap(EnumChannelType.class);
    private RedstoneState redstoneState = RedstoneState.DISABLED;
    private boolean redstone;
    public int recurrentCalls = 0;
    private final Map<class_2350, Map<EnumChannelType, Boolean>> surroundingCapabilities = new HashMap<class_2350, Map<EnumChannelType, Boolean>>();

    public TesseractBlockEntity(class_2338 pos, class_2680 state) {
        super(Tesseract.tesseract_tile, pos, state);
        for (EnumChannelType enumChannelType : EnumChannelType.values()) {
            this.transferState.put(enumChannelType, TransferState.BOTH);
        }
        for (EnumChannelType enumChannelType : class_2350.values()) {
            this.surroundingCapabilities.put((class_2350)enumChannelType, new HashMap());
        }
    }

    public TesseractReference getReference() {
        if (this.reference == null) {
            this.reference = TesseractTracker.getInstance(this.field_11863).add(this);
        }
        return this.reference;
    }

    public void invalidateReference() {
        this.reference = null;
    }

    public void channelChanged(EnumChannelType type) {
        this.capabilities.remove((Object)type);
        this.notifyNeighbors();
    }

    public boolean renderOn() {
        return !this.isBlockedByRedstone();
    }

    public Storage<ItemVariant> getItemCapability() {
        return (Storage)this.capabilities.computeIfAbsent(EnumChannelType.ITEMS, o -> {
            Channel channel = this.getChannel(EnumChannelType.ITEMS);
            return channel == null ? null : channel.getItemHandler(this);
        });
    }

    public Storage<FluidVariant> getFluidCapability() {
        return (Storage)this.capabilities.computeIfAbsent(EnumChannelType.FLUID, o -> {
            Channel channel = this.getChannel(EnumChannelType.FLUID);
            return channel == null ? null : channel.getFluidHandler(this);
        });
    }

    public Object getEnergyCapability() {
        return this.capabilities.computeIfAbsent(EnumChannelType.ENERGY, o -> {
            Channel channel = this.getChannel(EnumChannelType.ENERGY);
            return channel == null ? null : channel.getEnergyStorage(this);
        });
    }

    public <T> Iterable<T> getSurroundingCapabilities(final BlockApiLookup<T, class_2350> apiLookup) {
        if (this.field_11863 == null) {
            return Collections::emptyIterator;
        }
        final class_2338 pos = this.method_11016();
        return () -> new Iterator<T>(){
            private int index;
            private T next;

            private void findNext() {
                while (this.next == null && this.index < 6) {
                    class_2350 facing = class_2350.values()[this.index++];
                    class_2338 facingPos = pos.method_10093(facing);
                    class_2680 state = TesseractBlockEntity.this.field_11863.method_8320(facingPos);
                    if (state.method_27852((class_2248)Tesseract.tesseract)) continue;
                    this.next = apiLookup.find(TesseractBlockEntity.this.field_11863, pos.method_10093(facing), state, TesseractBlockEntity.this.field_11863.method_8321(facingPos), (Object)facing.method_10153());
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.findNext();
                }
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    this.findNext();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                Object next = this.next;
                this.next = null;
                return next;
            }
        };
    }

    public boolean canSend(EnumChannelType type) {
        return this.transferState.get((Object)type).canSend() && !this.isBlockedByRedstone();
    }

    public boolean canReceive(EnumChannelType type) {
        return this.transferState.get((Object)type).canReceive() && !this.isBlockedByRedstone();
    }

    public boolean isBlockedByRedstone() {
        return this.redstoneState != RedstoneState.DISABLED && this.redstoneState == (this.redstone ? RedstoneState.LOW : RedstoneState.HIGH);
    }

    public int getChannelId(EnumChannelType type) {
        return this.getReference().getChannelId(type);
    }

    public TransferState getTransferState(EnumChannelType type) {
        return this.transferState.get((Object)type);
    }

    public void cycleTransferState(EnumChannelType type) {
        TransferState transferState = this.transferState.get((Object)type);
        this.transferState.put(type, transferState == TransferState.BOTH ? TransferState.SEND : (transferState == TransferState.SEND ? TransferState.RECEIVE : TransferState.BOTH));
        this.updateReference();
        this.dataChanged();
    }

    public RedstoneState getRedstoneState() {
        return this.redstoneState;
    }

    public void cycleRedstoneState() {
        this.redstoneState = this.redstoneState == RedstoneState.DISABLED ? RedstoneState.HIGH : (this.redstoneState == RedstoneState.HIGH ? RedstoneState.LOW : RedstoneState.DISABLED);
        this.updateReference();
        this.dataChanged();
    }

    public void setPowered(boolean powered) {
        if (this.redstone != powered) {
            this.redstone = powered;
            this.updateReference();
            this.dataChanged();
        }
    }

    private Channel getChannel(EnumChannelType type) {
        return this.getReference().getChannel(type);
    }

    public void onNeighborChanged(class_2338 neighbor) {
        class_2350 facing = class_2350.method_10147((float)(neighbor.method_10263() - this.field_11867.method_10263()), (float)(neighbor.method_10264() - this.field_11867.method_10264()), (float)(neighbor.method_10260() - this.field_11867.method_10260()));
        this.surroundingCapabilities.get(facing).clear();
    }

    private void notifyNeighbors() {
        this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
    }

    private void updateReference() {
        TesseractReference reference = this.getReference();
        if (reference != null) {
            reference.update(this);
        }
    }

    protected class_2487 writeData() {
        class_2487 compound = new class_2487();
        for (EnumChannelType type : EnumChannelType.values()) {
            compound.method_10582("transferState" + type.name(), this.transferState.get((Object)type).name());
        }
        compound.method_10582("redstoneState", this.redstoneState.name());
        compound.method_10556("powered", this.redstone);
        return compound;
    }

    protected void readData(class_2487 compound) {
        for (EnumChannelType type : EnumChannelType.values()) {
            if (!compound.method_10545("transferState" + type.name())) continue;
            this.transferState.put(type, TransferState.valueOf(compound.method_10558("transferState" + type.name())));
        }
        if (compound.method_10545("redstoneState")) {
            this.redstoneState = RedstoneState.valueOf(compound.method_10558("redstoneState"));
        }
        if (compound.method_10545("powered")) {
            this.redstone = compound.method_10577("powered");
        }
    }

    public void onReplaced() {
        if (!this.field_11863.field_9236) {
            TesseractTracker.SERVER.remove(this.field_11863, this.field_11867);
        }
    }
}

