/*
 * Decompiled with CFR 0.152.
 */
package uk.me.desert_island.rer;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.me.desert_island.rer.RERUtils;
import uk.me.desert_island.rer.RoughlyEnoughResources;

public class WorldGenState
extends class_18 {
    public static Map<class_5321<class_1937>, class_26> persistentStateManagerMap = new HashMap<class_5321<class_1937>, class_26>();
    private static final Logger LOGGER = LogManager.getFormatterLogger((String)"rer-wgs");
    public IntSet playerDirty = new IntOpenHashSet();
    private final ReentrantLock lock = new ReentrantLock();
    public Map<class_2248, AtomicLongArray> levelCountsMap = new ConcurrentHashMap<class_2248, AtomicLongArray>();
    public AtomicLongArray totalCountsAtLevelsMap = new AtomicLongArray(384);
    public final int CURRENT_VERSION = 0;

    public void lockPlayerDirty() {
        this.lock.lock();
    }

    public void unlockPlayerDirty() {
        this.lock.unlock();
    }

    public static void registerPsm(class_26 psm, class_5321<class_1937> world) {
        if (persistentStateManagerMap.containsKey(world)) {
            LOGGER.printf(Level.WARN, "Registering psm %s for already known world %s?", new Object[]{psm, world});
        }
        persistentStateManagerMap.put(world, psm);
    }

    public static WorldGenState byWorld(class_1937 world) {
        return WorldGenState.byWorld((class_5321<class_1937>)world.method_27983());
    }

    public static WorldGenState byWorld(class_5321<class_1937> world) {
        String name = "rer_worldgen";
        class_26 psm = persistentStateManagerMap.get(world);
        return (WorldGenState)psm.method_17924(nbt -> new WorldGenState((class_2487)nbt, name, world), () -> new WorldGenState(null, name, world), name);
    }

    public void markPlayerDirty(class_2248 block) {
        this.lockPlayerDirty();
        this.playerDirty.add(-1);
        this.playerDirty.add(class_7923.field_41175.method_10206((Object)block));
        this.unlockPlayerDirty();
    }

    public WorldGenState(class_2487 nbt, String string_1, class_5321<class_1937> type) {
        if (nbt != null) {
            this.fromNbt(nbt);
        }
    }

    public void sendToPlayers(Iterable<class_3222> player, class_2540 infoBuf, class_5321<class_1937> world) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        RoughlyEnoughResources.writeIdentifier(buf, world.method_29177());
        buf.writeBytes((ByteBuf)infoBuf);
        ByteBuf start_bb = Unpooled.buffer().writeInt(buf.readableBytes());
        class_2540 start_packet = new class_2540(start_bb);
        class_2540 done_packet = new class_2540(Unpooled.buffer());
        for (class_3222 entity : player) {
            NetworkManager.sendToPlayer((class_3222)entity, (class_2960)RoughlyEnoughResources.SEND_WORLD_GEN_STATE_START, (class_2540)start_packet);
            class_2540 player_packet = new class_2540(buf.retainedDuplicate());
            while (player_packet.readableBytes() > 0) {
                int this_size = player_packet.readableBytes();
                if (this_size > 1000000) {
                    this_size = 1000000;
                }
                ByteBuf sub_bb = Unpooled.buffer((int)this_size);
                player_packet.readBytes(sub_bb, this_size);
                NetworkManager.sendToPlayer((class_3222)entity, (class_2960)RoughlyEnoughResources.SEND_WORLD_GEN_STATE_CHUNK, (class_2540)new class_2540(sub_bb));
            }
            NetworkManager.sendToPlayer((class_3222)entity, (class_2960)RoughlyEnoughResources.SEND_WORLD_GEN_STATE_DONE, (class_2540)done_packet);
        }
    }

    public void fromNbt(class_2487 root) {
        if (!root.method_10573("Version", 3)) {
            RERUtils.LOGGER.error("Invalid save data. Expected a Version, found no Version, throwing out existing data in a huff.");
            return;
        }
        int version = root.method_10550("Version");
        if (version != 0) {
            RERUtils.LOGGER.error("Invalid save data. Expected Version 0, found " + version + ". Discarding save data.");
            return;
        }
        this.levelCountsMap.clear();
        this.totalCountsAtLevelsMap = new AtomicLongArray(384);
        long[] totalCountsAtLevels = root.method_10565("total_counts_at_level");
        for (int i = 0; i < totalCountsAtLevels.length; ++i) {
            this.totalCountsAtLevelsMap.set(i, totalCountsAtLevels[i]);
        }
        class_2487 levelCountsForBlock = root.method_10562("level_counts_for_block");
        for (String blockIdString : levelCountsForBlock.method_10541()) {
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(blockIdString));
            this.levelCountsMap.put(block, new AtomicLongArray(384));
            AtomicLongArray levelCount = this.levelCountsMap.get(block);
            long[] countsForBlockTag = levelCountsForBlock.method_10565(blockIdString);
            for (int i = 0; i < countsForBlockTag.length; ++i) {
                levelCount.set(i, countsForBlockTag[i]);
            }
        }
    }

    public class_2487 method_75(class_2487 rootTag) {
        rootTag.method_10569("Version", 0);
        long[] totalCountsAtLevelArray = new long[this.totalCountsAtLevelsMap.length()];
        for (int i = 0; i < totalCountsAtLevelArray.length; ++i) {
            totalCountsAtLevelArray[i] = this.totalCountsAtLevelsMap.get(i);
        }
        rootTag.method_10564("total_counts_at_level", totalCountsAtLevelArray);
        class_2487 tag = new class_2487();
        for (class_2248 block : this.levelCountsMap.keySet()) {
            AtomicLongArray countsForBlockMap = this.levelCountsMap.get(block);
            long[] countsForBlockTag = new long[countsForBlockMap.length()];
            for (int i = 0; i < countsForBlockTag.length; ++i) {
                countsForBlockTag[i] = countsForBlockMap.get(i);
            }
            tag.method_10564(class_7923.field_41175.method_10221((Object)block).toString(), countsForBlockTag);
        }
        rootTag.method_10566("level_counts_for_block", (class_2520)tag);
        return rootTag;
    }

    private static void writeVarLongArray(class_2540 buf, long[] array) {
        buf.method_10804(array.length);
        int length = array.length;
        for (int var4 = 0; var4 < length; ++var4) {
            buf.method_10791(array[var4]);
        }
    }

    public class_2540 toNetwork(boolean append, class_2540 buf, IntSet allLevels) {
        buf.writeBoolean(append);
        if (allLevels.contains(-1)) {
            long[] totalCountsAtLevelArray = new long[this.totalCountsAtLevelsMap.length()];
            for (int i = 0; i < totalCountsAtLevelArray.length; ++i) {
                totalCountsAtLevelArray[i] = this.totalCountsAtLevelsMap.get(i);
            }
            WorldGenState.writeVarLongArray(buf, totalCountsAtLevelArray);
            allLevels.remove(-1);
        }
        IntIterator intIterator = allLevels.iterator();
        while (intIterator.hasNext()) {
            int level = (Integer)intIterator.next();
            class_2248 block = (class_2248)class_7923.field_41175.method_10200(level);
            AtomicLongArray countsForBlockMap = this.levelCountsMap.get(block);
            if (countsForBlockMap == null) continue;
            long[] countsForBlockTag = new long[countsForBlockMap.length()];
            for (int i = 0; i < countsForBlockTag.length; ++i) {
                countsForBlockTag[i] = countsForBlockMap.get(i);
            }
            buf.method_10804(level);
            WorldGenState.writeVarLongArray(buf, countsForBlockTag);
        }
        return buf;
    }

    public IntSet buildEverythingLevels() {
        IntOpenHashSet levels = new IntOpenHashSet();
        levels.add(-1);
        for (class_2248 block : this.levelCountsMap.keySet()) {
            levels.add(class_7923.field_41175.method_10206((Object)block));
        }
        return levels;
    }
}

