/*
 * Decompiled with CFR 0.152.
 */
package uk.me.desert_island.rer;

import com.google.gson.JsonElement;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import uk.me.desert_island.rer.RERUtils;
import uk.me.desert_island.rer.RoughlyEnoughResources;
import uk.me.desert_island.rer.client.ClientLootCache;
import uk.me.desert_island.rer.client.ClientWorldGenState;

@Environment(value=EnvType.CLIENT)
public class RoughlyEnoughResourcesClient {
    private static CompositeByteBuf world_state_buf;

    public static void onInitializeClient() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)RoughlyEnoughResources.SEND_WORLD_GEN_STATE_START, (this_buf, context) -> {
            RERUtils.LOGGER.debug("got SEND_WORLD_GEN_STATE_START");
            world_state_buf = Unpooled.compositeBuffer();
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)RoughlyEnoughResources.SEND_WORLD_GEN_STATE_CHUNK, (this_buf, context) -> {
            RERUtils.LOGGER.debug("got SEND_WORLD_GEN_STATE_CHUNK");
            world_state_buf.addComponent(true, this_buf.retainedDuplicate());
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)RoughlyEnoughResources.SEND_WORLD_GEN_STATE_DONE, (this_buf, context) -> {
            RERUtils.LOGGER.debug("got SEND_WORLD_GEN_STATE_DONE");
            class_2540 buf = new class_2540((ByteBuf)world_state_buf);
            class_2960 worldId = buf.method_10810();
            class_5321 world = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)worldId);
            ClientWorldGenState state = ClientWorldGenState.byWorld((class_5321<class_1937>)world);
            state.fromNetwork(buf);
            RERUtils.LOGGER.debug("Received data for " + worldId);
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)RoughlyEnoughResources.SEND_LOOT_INFO, (buf, context) -> {
            int size = buf.readInt();
            RERUtils.LOGGER.debug("Received %d Loot Info", size);
            for (int i = 0; i < size; ++i) {
                class_2960 identifier = buf.method_10810();
                JsonElement json = RoughlyEnoughResources.readJson(buf);
                ClientLootCache.ID_TO_LOOT.put(identifier, json);
            }
        });
    }
}

