/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.options;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.options.CompositeOption;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import net.minecraft.class_2561;

public interface OptionValueEntry<T> {
    public class_2561 getOption(T var1);

    public static <T> OptionValueEntry<T> noOp() {
        return value -> ConfigUtils.literal(value.toString());
    }

    public static Selection<Boolean> ofBoolean(final class_2561 falseText, final class_2561 trueText) {
        return new Selection<Boolean>(){

            @Override
            public List<Boolean> getOptions() {
                return List.of(Boolean.valueOf(false), Boolean.valueOf(true));
            }

            @Override
            public class_2561 getOption(Boolean value) {
                return value != false ? trueText : falseText;
            }
        };
    }

    public static Selection<Boolean> trueFalse() {
        return OptionValueEntry.ofBoolean((class_2561)ConfigUtils.translatable("config.rei.value.trueFalse.false"), (class_2561)ConfigUtils.translatable("config.rei.value.trueFalse.true"));
    }

    public static Selection<Boolean> enabledDisabled() {
        return OptionValueEntry.ofBoolean((class_2561)ConfigUtils.translatable("config.rei.value.enabledDisabled.false"), (class_2561)ConfigUtils.translatable("config.rei.value.enabledDisabled.true"));
    }

    public static <T> Selection<T> enumOptions(T ... array) {
        final Class<?> type = array.getClass().getComponentType();
        final Object[] constants = type.getEnumConstants();
        return new Selection<T>(){

            @Override
            public List<T> getOptions() {
                return CollectionUtils.map(constants, type::cast);
            }

            @Override
            public class_2561 getOption(T value) {
                return ConfigUtils.literal(value.toString());
            }
        };
    }

    public static <T> Selection<T> options(final T ... options) {
        return new Selection<T>(){

            @Override
            public List<T> getOptions() {
                return Arrays.asList(options);
            }

            @Override
            public class_2561 getOption(T value) {
                return ConfigUtils.literal(value.toString());
            }
        };
    }

    public static <T> Configure<T> configure(final Configurator<T> configurator) {
        return new Configure<T>(){

            @Override
            public void configure(ConfigAccess access, CompositeOption<T> option, Runnable onClose) {
                configurator.configure(access, option, onClose);
            }

            @Override
            public class_2561 getOption(T value) {
                return ConfigUtils.translatable("config.rei.texts.configure");
            }
        };
    }

    public static <T> Configure<T> details(final Configurator<T> configurator) {
        return new Configure<T>(){

            @Override
            public void configure(ConfigAccess access, CompositeOption<T> option, Runnable onClose) {
                configurator.configure(access, option, onClose);
            }

            @Override
            public class_2561 getOption(T value) {
                return ConfigUtils.translatable("config.rei.texts.details");
            }
        };
    }

    public static <T> Configure<T> reload(final Configurator<T> configurator) {
        return new Configure<T>(){

            @Override
            public void configure(ConfigAccess access, CompositeOption<T> option, Runnable onClose) {
                configurator.configure(access, option, onClose);
            }

            @Override
            public class_2561 getOption(T value) {
                return ConfigUtils.translatable("config.rei.texts.reload");
            }
        };
    }

    public static OptionValueEntry<ModifierKeyCode> keybind() {
        return ModifierKeyCode::getLocalizedName;
    }

    public static String string() {
        return ConfigUtils::literal;
    }

    public static interface Selection<T>
    extends OptionValueEntry<T> {
        public List<T> getOptions();

        default public Selection<T> overrideText(final Function<T, class_2561> textFunction) {
            return new Selection<T>(){

                @Override
                public List<T> getOptions() {
                    return this.getOptions();
                }

                @Override
                public class_2561 getOption(T value) {
                    return (class_2561)textFunction.apply(value);
                }
            };
        }
    }

    public static interface Configurator<T> {
        public void configure(ConfigAccess var1, CompositeOption<T> var2, Runnable var3);
    }

    public static interface String
    extends OptionValueEntry<java.lang.String> {
    }

    public static interface Configure<T>
    extends OptionValueEntry<T>,
    Configurator<T> {
    }
}

