/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.util.DataSetObserver;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.widget.Filter;
import icyllis.modernui.widget.Filterable;
import icyllis.modernui.widget.ListAdapter;
import icyllis.modernui.widget.ListView;
import icyllis.modernui.widget.WrapperListAdapter;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HeaderViewListAdapter
implements WrapperListAdapter,
Filterable {
    private final ListAdapter mAdapter;
    ArrayList<ListView.FixedViewInfo> mHeaderViewInfos;
    ArrayList<ListView.FixedViewInfo> mFooterViewInfos;
    static final ArrayList<ListView.FixedViewInfo> EMPTY_INFO_LIST = new ArrayList();
    boolean mAreAllFixedViewsSelectable;
    private final boolean mIsFilterable;

    public HeaderViewListAdapter(@Nullable ArrayList<ListView.FixedViewInfo> headerViewInfos, @Nullable ArrayList<ListView.FixedViewInfo> footerViewInfos, @Nonnull ListAdapter adapter) {
        this.mAdapter = adapter;
        this.mIsFilterable = adapter instanceof Filterable;
        this.mHeaderViewInfos = Objects.requireNonNullElse(headerViewInfos, EMPTY_INFO_LIST);
        this.mFooterViewInfos = Objects.requireNonNullElse(footerViewInfos, EMPTY_INFO_LIST);
        this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
    }

    public int getHeadersCount() {
        return this.mHeaderViewInfos.size();
    }

    public int getFootersCount() {
        return this.mFooterViewInfos.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mAdapter == null || this.mAdapter.isEmpty();
    }

    private boolean areAllListInfosSelectable(ArrayList<ListView.FixedViewInfo> infos) {
        if (infos != null) {
            for (ListView.FixedViewInfo info : infos) {
                if (info.isSelectable) continue;
                return false;
            }
        }
        return true;
    }

    public boolean removeHeader(@Nonnull View v) {
        for (int i = 0; i < this.mHeaderViewInfos.size(); ++i) {
            ListView.FixedViewInfo info = this.mHeaderViewInfos.get(i);
            if (info.view != v) continue;
            this.mHeaderViewInfos.remove(i);
            this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
            return true;
        }
        return false;
    }

    public boolean removeFooter(@Nonnull View v) {
        for (int i = 0; i < this.mFooterViewInfos.size(); ++i) {
            ListView.FixedViewInfo info = this.mFooterViewInfos.get(i);
            if (info.view != v) continue;
            this.mFooterViewInfos.remove(i);
            this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
            return true;
        }
        return false;
    }

    @Override
    public int getCount() {
        if (this.mAdapter != null) {
            return this.getFootersCount() + this.getHeadersCount() + this.mAdapter.getCount();
        }
        return this.getFootersCount() + this.getHeadersCount();
    }

    @Override
    public boolean areAllItemsEnabled() {
        if (this.mAdapter != null) {
            return this.mAreAllFixedViewsSelectable && this.mAdapter.areAllItemsEnabled();
        }
        return true;
    }

    @Override
    public boolean isEnabled(int position) {
        int numHeaders = this.getHeadersCount();
        if (position < numHeaders) {
            return this.mHeaderViewInfos.get((int)position).isSelectable;
        }
        int adjPosition = position - numHeaders;
        int adapterCount = 0;
        if (this.mAdapter != null && adjPosition < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.isEnabled(adjPosition);
        }
        return this.mFooterViewInfos.get((int)(adjPosition - adapterCount)).isSelectable;
    }

    @Override
    public Object getItem(int position) {
        int numHeaders = this.getHeadersCount();
        if (position < numHeaders) {
            return this.mHeaderViewInfos.get((int)position).data;
        }
        int adjPosition = position - numHeaders;
        int adapterCount = 0;
        if (this.mAdapter != null && adjPosition < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.getItem(adjPosition);
        }
        return this.mFooterViewInfos.get((int)(adjPosition - adapterCount)).data;
    }

    @Override
    public long getItemId(int position) {
        int adapterCount;
        int adjPosition;
        int numHeaders = this.getHeadersCount();
        if (this.mAdapter != null && position >= numHeaders && (adjPosition = position - numHeaders) < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.getItemId(adjPosition);
        }
        return -1L;
    }

    @Override
    public boolean hasStableIds() {
        if (this.mAdapter != null) {
            return this.mAdapter.hasStableIds();
        }
        return false;
    }

    @Override
    @Nonnull
    public View getView(int position, @Nullable View convertView, @Nonnull ViewGroup parent) {
        int numHeaders = this.getHeadersCount();
        if (position < numHeaders) {
            return this.mHeaderViewInfos.get((int)position).view;
        }
        int adjPosition = position - numHeaders;
        int adapterCount = 0;
        if (this.mAdapter != null && adjPosition < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.getView(adjPosition, convertView, parent);
        }
        return this.mFooterViewInfos.get((int)(adjPosition - adapterCount)).view;
    }

    @Override
    public int getItemViewType(int position) {
        int adapterCount;
        int adjPosition;
        int numHeaders = this.getHeadersCount();
        if (this.mAdapter != null && position >= numHeaders && (adjPosition = position - numHeaders) < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.getItemViewType(adjPosition);
        }
        return -2;
    }

    @Override
    public int getViewTypeCount() {
        if (this.mAdapter != null) {
            return this.mAdapter.getViewTypeCount();
        }
        return 1;
    }

    @Override
    public void registerDataSetObserver(@Nonnull DataSetObserver observer) {
        if (this.mAdapter != null) {
            this.mAdapter.registerDataSetObserver(observer);
        }
    }

    @Override
    public void unregisterDataSetObserver(@Nonnull DataSetObserver observer) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(observer);
        }
    }

    @Override
    public Filter getFilter() {
        if (this.mIsFilterable) {
            return ((Filterable)((Object)this.mAdapter)).getFilter();
        }
        return null;
    }

    @Override
    public ListAdapter getWrappedAdapter() {
        return this.mAdapter;
    }
}

