/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.transition;

import icyllis.modernui.animation.Animator;
import icyllis.modernui.animation.AnimatorListener;
import icyllis.modernui.animation.TimeInterpolator;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.transition.TransitionListener;
import icyllis.modernui.transition.TransitionPropagation;
import icyllis.modernui.transition.TransitionSet;
import icyllis.modernui.transition.TransitionValues;
import icyllis.modernui.util.ArrayMap;
import icyllis.modernui.util.LongSparseArray;
import icyllis.modernui.util.SparseArray;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.view.ViewParent;
import icyllis.modernui.widget.ListView;
import it.unimi.dsi.fastutil.ints.Int2LongArrayMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Transition
implements Cloneable {
    public static final int MATCH_INSTANCE = 1;
    private static final int MATCH_FIRST = 1;
    public static final int MATCH_NAME = 2;
    public static final int MATCH_ID = 3;
    public static final int MATCH_ITEM_ID = 4;
    private static final int MATCH_LAST = 4;
    private static final int[] DEFAULT_MATCH_ORDER = new int[]{2, 1, 3, 4};
    private long mStartDelay = -1L;
    long mDuration = -1L;
    private TimeInterpolator mInterpolator;
    IntArrayList mTargetIds = new IntArrayList();
    ArrayList<View> mTargets = new ArrayList();
    private ArrayList<String> mTargetNames;
    private ArrayList<Class<?>> mTargetTypes;
    private IntArrayList mTargetIdExcludes;
    private ArrayList<View> mTargetExcludes;
    private ArrayList<Class<?>> mTargetTypeExcludes;
    private ArrayList<String> mTargetNameExcludes;
    private IntArrayList mTargetIdChildExcludes;
    private ArrayList<View> mTargetChildExcludes;
    private ArrayList<Class<?>> mTargetTypeChildExcludes;
    private TransitionValuesMaps mStartValues = new TransitionValuesMaps();
    private TransitionValuesMaps mEndValues = new TransitionValuesMaps();
    TransitionSet mParent;
    private int[] mMatchOrder = DEFAULT_MATCH_ORDER;
    private ArrayList<TransitionValues> mStartValuesList;
    private ArrayList<TransitionValues> mEndValuesList;
    private static final ThreadLocal<ArrayMap<Animator, AnimationInfo>> sRunningAnimators = ThreadLocal.withInitial(ArrayMap::new);
    boolean mCanRemoveViews = false;
    private final ArrayList<Animator> mCurrentAnimators = new ArrayList();
    private int mNumInstances = 0;
    private boolean mPaused = false;
    private boolean mEnded = false;
    private CopyOnWriteArrayList<TransitionListener> mListeners;
    private ArrayList<Animator> mAnimators = new ArrayList();
    TransitionPropagation mPropagation;
    private EpicenterCallback mEpicenterCallback;

    @Nonnull
    public Transition setDuration(long duration) {
        this.mDuration = duration;
        return this;
    }

    public long getDuration() {
        return this.mDuration;
    }

    @Nonnull
    public Transition setStartDelay(long startDelay) {
        this.mStartDelay = startDelay;
        return this;
    }

    public long getStartDelay() {
        return this.mStartDelay;
    }

    @Nonnull
    public Transition setInterpolator(@Nullable TimeInterpolator interpolator) {
        this.mInterpolator = interpolator;
        return this;
    }

    @Nullable
    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    @Nullable
    public String[] getTransitionProperties() {
        return null;
    }

    @Nullable
    public Animator createAnimator(@Nonnull ViewGroup sceneRoot, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        return null;
    }

    public void setMatchOrder(int ... matches) {
        if (matches == null || matches.length == 0) {
            this.mMatchOrder = DEFAULT_MATCH_ORDER;
        } else {
            for (int i = 0; i < matches.length; ++i) {
                int match = matches[i];
                if (!Transition.isValidMatch(match)) {
                    throw new IllegalArgumentException("matches contains invalid value");
                }
                if (!Transition.alreadyContains(matches, i)) continue;
                throw new IllegalArgumentException("matches contains a duplicate value");
            }
            this.mMatchOrder = (int[])matches.clone();
        }
    }

    private static boolean isValidMatch(int match) {
        return match >= 1 && match <= 4;
    }

    private static boolean alreadyContains(@Nonnull int[] array, int searchIndex) {
        int value = array[searchIndex];
        for (int i = 0; i < searchIndex; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    private void matchInstances(@Nonnull ArrayMap<View, TransitionValues> unmatchedStart, @Nonnull ArrayMap<View, TransitionValues> unmatchedEnd) {
        for (int i = unmatchedStart.size() - 1; i >= 0; --i) {
            TransitionValues end;
            View view = unmatchedStart.keyAt(i);
            if (view == null || !this.isValidTarget(view) || (end = unmatchedEnd.remove(view)) == null || !this.isValidTarget(end.view)) continue;
            TransitionValues start = unmatchedStart.removeAt(i);
            this.mStartValuesList.add(start);
            this.mEndValuesList.add(end);
        }
    }

    private void matchItemIds(@Nonnull ArrayMap<View, TransitionValues> unmatchedStart, @Nonnull ArrayMap<View, TransitionValues> unmatchedEnd, @Nonnull LongSparseArray<View> startItemIds, @Nonnull LongSparseArray<View> endItemIds) {
        int numStartIds = startItemIds.size();
        for (int i = 0; i < numStartIds; ++i) {
            View endView;
            View startView = startItemIds.valueAt(i);
            if (startView == null || !this.isValidTarget(startView) || (endView = endItemIds.get(startItemIds.keyAt(i))) == null || !this.isValidTarget(endView)) continue;
            TransitionValues startValues = unmatchedStart.get(startView);
            TransitionValues endValues = unmatchedEnd.get(endView);
            if (startValues == null || endValues == null) continue;
            this.mStartValuesList.add(startValues);
            this.mEndValuesList.add(endValues);
            unmatchedStart.remove(startView);
            unmatchedEnd.remove(endView);
        }
    }

    private void matchIds(@Nonnull ArrayMap<View, TransitionValues> unmatchedStart, @Nonnull ArrayMap<View, TransitionValues> unmatchedEnd, @Nonnull SparseArray<View> startIds, @Nonnull SparseArray<View> endIds) {
        int numStartIds = startIds.size();
        for (int i = 0; i < numStartIds; ++i) {
            View endView;
            View startView = startIds.valueAt(i);
            if (startView == null || !this.isValidTarget(startView) || (endView = endIds.get(startIds.keyAt(i))) == null || !this.isValidTarget(endView)) continue;
            TransitionValues startValues = unmatchedStart.get(startView);
            TransitionValues endValues = unmatchedEnd.get(endView);
            if (startValues == null || endValues == null) continue;
            this.mStartValuesList.add(startValues);
            this.mEndValuesList.add(endValues);
            unmatchedStart.remove(startView);
            unmatchedEnd.remove(endView);
        }
    }

    private void matchNames(@Nonnull ArrayMap<View, TransitionValues> unmatchedStart, @Nonnull ArrayMap<View, TransitionValues> unmatchedEnd, @Nonnull ArrayMap<String, View> startNames, @Nonnull ArrayMap<String, View> endNames) {
        int numStartNames = startNames.size();
        for (int i = 0; i < numStartNames; ++i) {
            View endView;
            View startView = startNames.valueAt(i);
            if (startView == null || !this.isValidTarget(startView) || (endView = endNames.get(startNames.keyAt(i))) == null || !this.isValidTarget(endView)) continue;
            TransitionValues startValues = unmatchedStart.get(startView);
            TransitionValues endValues = unmatchedEnd.get(endView);
            if (startValues == null || endValues == null) continue;
            this.mStartValuesList.add(startValues);
            this.mEndValuesList.add(endValues);
            unmatchedStart.remove(startView);
            unmatchedEnd.remove(endView);
        }
    }

    private void addUnmatched(@Nonnull ArrayMap<View, TransitionValues> unmatchedStart, @Nonnull ArrayMap<View, TransitionValues> unmatchedEnd) {
        int i;
        for (i = 0; i < unmatchedStart.size(); ++i) {
            TransitionValues start = unmatchedStart.valueAt(i);
            if (!this.isValidTarget(start.view)) continue;
            this.mStartValuesList.add(start);
            this.mEndValuesList.add(null);
        }
        for (i = 0; i < unmatchedEnd.size(); ++i) {
            TransitionValues end = unmatchedEnd.valueAt(i);
            if (!this.isValidTarget(end.view)) continue;
            this.mEndValuesList.add(end);
            this.mStartValuesList.add(null);
        }
    }

    private void matchStartAndEnd(@Nonnull TransitionValuesMaps startValues, @Nonnull TransitionValuesMaps endValues) {
        ArrayMap<View, TransitionValues> unmatchedStart = new ArrayMap<View, TransitionValues>(startValues.mViewValues);
        ArrayMap<View, TransitionValues> unmatchedEnd = new ArrayMap<View, TransitionValues>(endValues.mViewValues);
        block6: for (int j : this.mMatchOrder) {
            switch (j) {
                case 1: {
                    this.matchInstances(unmatchedStart, unmatchedEnd);
                    continue block6;
                }
                case 2: {
                    this.matchNames(unmatchedStart, unmatchedEnd, startValues.mNameValues, endValues.mNameValues);
                    continue block6;
                }
                case 3: {
                    this.matchIds(unmatchedStart, unmatchedEnd, startValues.mIdValues, endValues.mIdValues);
                    continue block6;
                }
                case 4: {
                    this.matchItemIds(unmatchedStart, unmatchedEnd, startValues.mItemIdValues, endValues.mItemIdValues);
                }
            }
        }
        this.addUnmatched(unmatchedStart, unmatchedEnd);
    }

    protected void createAnimators(@Nonnull ViewGroup sceneRoot, @Nonnull TransitionValuesMaps startValues, @Nonnull TransitionValuesMaps endValues, @Nonnull ArrayList<TransitionValues> startValuesList, @Nonnull ArrayList<TransitionValues> endValuesList) {
        ArrayMap<Animator, AnimationInfo> runningAnimators = sRunningAnimators.get();
        long minStartDelay = Long.MAX_VALUE;
        Int2LongArrayMap startDelays = new Int2LongArrayMap();
        int startValuesListCount = startValuesList.size();
        for (int i = 0; i < startValuesListCount; ++i) {
            View view;
            Animator animator;
            boolean isChanged;
            TransitionValues start = startValuesList.get(i);
            TransitionValues end = endValuesList.get(i);
            if (start != null && !start.mTargetedTransitions.contains(this)) {
                start = null;
            }
            if (end != null && !end.mTargetedTransitions.contains(this)) {
                end = null;
            }
            if (start == null && end == null) continue;
            boolean bl = isChanged = start == null || end == null || this.isTransitionRequired(start, end);
            if (!isChanged || (animator = this.createAnimator(sceneRoot, start, end)) == null) continue;
            TransitionValues infoValues = null;
            if (end != null) {
                view = end.view;
                String[] properties = this.getTransitionProperties();
                if (properties != null && properties.length > 0) {
                    infoValues = new TransitionValues(view);
                    TransitionValues newValues = endValues.mViewValues.get(view);
                    if (newValues != null) {
                        for (String property : properties) {
                            infoValues.values.put(property, newValues.values.get(property));
                        }
                    }
                    int numExistingAnimators = runningAnimators.size();
                    for (int j = 0; j < numExistingAnimators; ++j) {
                        Animator anim = runningAnimators.keyAt(j);
                        AnimationInfo info = runningAnimators.get(anim);
                        if (info.values == null || info.view != view || !info.name.equals(this.getName()) || !info.values.equals(infoValues)) continue;
                        animator = null;
                        break;
                    }
                }
            } else {
                view = start.view;
            }
            if (animator == null) continue;
            if (this.mPropagation != null) {
                long delay = this.mPropagation.getStartDelay(sceneRoot, this, start, end);
                startDelays.put(this.mAnimators.size(), (long)((int)delay));
                minStartDelay = Math.min(delay, minStartDelay);
            }
            AnimationInfo info = new AnimationInfo(view, this.getName(), this, infoValues);
            runningAnimators.put(animator, info);
            this.mAnimators.add(animator);
        }
        if (startDelays.size() > 0) {
            ObjectIterator it = startDelays.int2LongEntrySet().fastIterator();
            while (it.hasNext()) {
                Int2LongMap.Entry e = (Int2LongMap.Entry)it.next();
                int index = e.getIntKey();
                Animator animator = this.mAnimators.get(index);
                long delay = e.getLongValue() - minStartDelay + animator.getStartDelay();
                animator.setStartDelay(delay);
            }
        }
    }

    boolean isValidTarget(@Nonnull View target) {
        int targetId = target.getId();
        if (this.mTargetIdExcludes != null && this.mTargetIdExcludes.contains(targetId)) {
            return false;
        }
        if (this.mTargetExcludes != null && this.mTargetExcludes.contains(target)) {
            return false;
        }
        if (this.mTargetTypeExcludes != null) {
            for (Class<?> type : this.mTargetTypeExcludes) {
                if (!type.isInstance(target)) continue;
                return false;
            }
        }
        if (this.mTargetNameExcludes != null && target.getTransitionName() != null && this.mTargetNameExcludes.contains(target.getTransitionName())) {
            return false;
        }
        if (this.mTargetIds.size() == 0 && this.mTargets.size() == 0 && (this.mTargetTypes == null || this.mTargetTypes.isEmpty()) && (this.mTargetNames == null || this.mTargetNames.isEmpty())) {
            return true;
        }
        if (this.mTargetIds.contains(targetId) || this.mTargets.contains(target)) {
            return true;
        }
        if (this.mTargetNames != null && this.mTargetNames.contains(target.getTransitionName())) {
            return true;
        }
        if (this.mTargetTypes != null) {
            for (Class<?> targetType : this.mTargetTypes) {
                if (!targetType.isInstance(target)) continue;
                return true;
            }
        }
        return false;
    }

    protected void runAnimators() {
        this.start();
        ArrayMap<Animator, AnimationInfo> runningAnimators = sRunningAnimators.get();
        for (Animator anim : this.mAnimators) {
            if (!runningAnimators.containsKey(anim)) continue;
            this.start();
            this.runAnimator(anim, runningAnimators);
        }
        this.mAnimators.clear();
        this.end();
    }

    private void runAnimator(@Nullable Animator animator, final ArrayMap<Animator, AnimationInfo> runningAnimators) {
        if (animator != null) {
            animator.addListener(new AnimatorListener(){

                @Override
                public void onAnimationStart(@Nonnull Animator animation) {
                    Transition.this.mCurrentAnimators.add(animation);
                }

                @Override
                public void onAnimationEnd(@Nonnull Animator animation) {
                    runningAnimators.remove(animation);
                    Transition.this.mCurrentAnimators.remove(animation);
                }
            });
            this.animate(animator);
        }
    }

    public abstract void captureStartValues(@Nonnull TransitionValues var1);

    public abstract void captureEndValues(@Nonnull TransitionValues var1);

    @Nonnull
    public Transition addTarget(@Nonnull View target) {
        this.mTargets.add(target);
        return this;
    }

    @Nonnull
    public Transition addTarget(int targetId) {
        if (targetId > 0) {
            this.mTargetIds.add(targetId);
        }
        return this;
    }

    @Nonnull
    public Transition addTarget(@Nonnull String targetName) {
        if (this.mTargetNames == null) {
            this.mTargetNames = new ArrayList();
        }
        this.mTargetNames.add(targetName);
        return this;
    }

    @Nonnull
    public Transition addTarget(@Nonnull Class<?> targetType) {
        if (this.mTargetTypes == null) {
            this.mTargetTypes = new ArrayList();
        }
        this.mTargetTypes.add(targetType);
        return this;
    }

    @Nonnull
    public Transition removeTarget(@Nonnull View target) {
        this.mTargets.remove(target);
        return this;
    }

    @Nonnull
    public Transition removeTarget(int targetId) {
        if (targetId > 0) {
            this.mTargetIds.rem(targetId);
        }
        return this;
    }

    @Nonnull
    public Transition removeTarget(@Nonnull String targetName) {
        if (this.mTargetNames != null) {
            this.mTargetNames.remove(targetName);
        }
        return this;
    }

    @Nonnull
    public Transition removeTarget(@Nonnull Class<?> target) {
        if (this.mTargetTypes != null) {
            this.mTargetTypes.remove(target);
        }
        return this;
    }

    @Nullable
    private static <T> ArrayList<T> excludeObject(@Nullable ArrayList<T> list, T target, boolean exclude) {
        if (target != null) {
            list = exclude ? ArrayListManager.add(list, target) : ArrayListManager.remove(list, target);
        }
        return list;
    }

    @Nonnull
    public Transition excludeTarget(@Nonnull View target, boolean exclude) {
        this.mTargetExcludes = this.excludeView(this.mTargetExcludes, target, exclude);
        return this;
    }

    @Nonnull
    public Transition excludeTarget(int targetId, boolean exclude) {
        this.mTargetIdExcludes = this.excludeId(this.mTargetIdExcludes, targetId, exclude);
        return this;
    }

    @Nonnull
    public Transition excludeTarget(@Nonnull String targetName, boolean exclude) {
        this.mTargetNameExcludes = Transition.excludeObject(this.mTargetNameExcludes, targetName, exclude);
        return this;
    }

    @Nonnull
    public Transition excludeChildren(@Nonnull View target, boolean exclude) {
        this.mTargetChildExcludes = this.excludeView(this.mTargetChildExcludes, target, exclude);
        return this;
    }

    @Nonnull
    public Transition excludeChildren(int targetId, boolean exclude) {
        this.mTargetIdChildExcludes = this.excludeId(this.mTargetIdChildExcludes, targetId, exclude);
        return this;
    }

    @Nullable
    private IntArrayList excludeId(@Nullable IntArrayList list, int targetId, boolean exclude) {
        if (targetId > 0) {
            list = exclude ? ArrayListManager.add(list, targetId) : ArrayListManager.remove(list, targetId);
        }
        return list;
    }

    @Nullable
    private ArrayList<View> excludeView(@Nullable ArrayList<View> list, View target, boolean exclude) {
        if (target != null) {
            list = exclude ? ArrayListManager.add(list, target) : ArrayListManager.remove(list, target);
        }
        return list;
    }

    @Nonnull
    public Transition excludeTarget(@Nonnull Class<?> type, boolean exclude) {
        this.mTargetTypeExcludes = this.excludeType(this.mTargetTypeExcludes, type, exclude);
        return this;
    }

    @Nonnull
    public Transition excludeChildren(@Nonnull Class<?> type, boolean exclude) {
        this.mTargetTypeChildExcludes = this.excludeType(this.mTargetTypeChildExcludes, type, exclude);
        return this;
    }

    @Nullable
    private ArrayList<Class<?>> excludeType(@Nullable ArrayList<Class<?>> list, Class<?> type, boolean exclude) {
        if (type != null) {
            list = exclude ? ArrayListManager.add(list, type) : ArrayListManager.remove(list, type);
        }
        return list;
    }

    @Nonnull
    public IntList getTargetIds() {
        return this.mTargetIds;
    }

    @Nonnull
    public List<View> getTargets() {
        return this.mTargets;
    }

    @Nullable
    public List<String> getTargetNames() {
        return this.mTargetNames;
    }

    @Nullable
    public List<Class<?>> getTargetTypes() {
        return this.mTargetTypes;
    }

    void captureValues(ViewGroup sceneRoot, boolean start) {
        this.clearValues(start);
        if (!(this.mTargetIds.size() <= 0 && this.mTargets.size() <= 0 || this.mTargetNames != null && !this.mTargetNames.isEmpty() || this.mTargetTypes != null && !this.mTargetTypes.isEmpty())) {
            IntListIterator intListIterator = this.mTargetIds.iterator();
            while (intListIterator.hasNext()) {
                int id2 = (Integer)intListIterator.next();
                Object view = sceneRoot.findViewById(id2);
                if (view == null) continue;
                TransitionValues values = new TransitionValues((View)view);
                if (start) {
                    this.captureStartValues(values);
                } else {
                    this.captureEndValues(values);
                }
                values.mTargetedTransitions.add(this);
                this.capturePropagationValues(values);
                if (start) {
                    Transition.addViewValues(this.mStartValues, view, values);
                    continue;
                }
                Transition.addViewValues(this.mEndValues, view, values);
            }
            for (View view : this.mTargets) {
                TransitionValues values = new TransitionValues(view);
                if (start) {
                    this.captureStartValues(values);
                } else {
                    this.captureEndValues(values);
                }
                values.mTargetedTransitions.add(this);
                this.capturePropagationValues(values);
                if (start) {
                    Transition.addViewValues(this.mStartValues, view, values);
                    continue;
                }
                Transition.addViewValues(this.mEndValues, view, values);
            }
        } else {
            this.captureHierarchy(sceneRoot, start);
        }
    }

    private static void addViewValues(@Nonnull TransitionValuesMaps transitionValuesMaps, @Nonnull View view, TransitionValues transitionValues) {
        ListView listview;
        ViewParent viewParent;
        String name;
        transitionValuesMaps.mViewValues.put(view, transitionValues);
        int id2 = view.getId();
        if (id2 >= 0) {
            if (transitionValuesMaps.mIdValues.indexOfKey(id2) >= 0) {
                transitionValuesMaps.mIdValues.put(id2, null);
            } else {
                transitionValuesMaps.mIdValues.put(id2, view);
            }
        }
        if ((name = view.getTransitionName()) != null) {
            if (transitionValuesMaps.mNameValues.containsKey(name)) {
                transitionValuesMaps.mNameValues.put(name, null);
            } else {
                transitionValuesMaps.mNameValues.put(name, view);
            }
        }
        if ((viewParent = view.getParent()) instanceof ListView && (listview = (ListView)viewParent).getAdapter().hasStableIds()) {
            int position = listview.getPositionForView(view);
            long itemId = listview.getItemIdAtPosition(position);
            if (transitionValuesMaps.mItemIdValues.indexOfKey(itemId) >= 0) {
                View alreadyMatched = transitionValuesMaps.mItemIdValues.get(itemId);
                if (alreadyMatched != null) {
                    alreadyMatched.setHasTransientState(false);
                    transitionValuesMaps.mItemIdValues.put(itemId, null);
                }
            } else {
                view.setHasTransientState(true);
                transitionValuesMaps.mItemIdValues.put(itemId, view);
            }
        }
    }

    void clearValues(boolean start) {
        if (start) {
            this.mStartValues.mViewValues.clear();
            this.mStartValues.mIdValues.clear();
            this.mStartValues.mItemIdValues.clear();
            this.mStartValues.mNameValues.clear();
            this.mStartValuesList = null;
        } else {
            this.mEndValues.mViewValues.clear();
            this.mEndValues.mIdValues.clear();
            this.mEndValues.mItemIdValues.clear();
            this.mEndValues.mNameValues.clear();
            this.mEndValuesList = null;
        }
    }

    private void captureHierarchy(View view, boolean start) {
        if (view == null) {
            return;
        }
        int id2 = view.getId();
        if (this.mTargetIdExcludes != null && this.mTargetIdExcludes.contains(id2)) {
            return;
        }
        if (this.mTargetExcludes != null && this.mTargetExcludes.contains(view)) {
            return;
        }
        if (this.mTargetTypeExcludes != null) {
            for (Class<?> type : this.mTargetTypeExcludes) {
                if (!type.isInstance(view)) continue;
                return;
            }
        }
        if (view.getParent() instanceof ViewGroup) {
            TransitionValues values = new TransitionValues(view);
            if (start) {
                this.captureStartValues(values);
            } else {
                this.captureEndValues(values);
            }
            values.mTargetedTransitions.add(this);
            this.capturePropagationValues(values);
            if (start) {
                Transition.addViewValues(this.mStartValues, view, values);
            } else {
                Transition.addViewValues(this.mEndValues, view, values);
            }
        }
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            if (this.mTargetIdChildExcludes != null && this.mTargetIdChildExcludes.contains(id2)) {
                return;
            }
            if (this.mTargetChildExcludes != null && this.mTargetChildExcludes.contains(view)) {
                return;
            }
            if (this.mTargetTypeChildExcludes != null) {
                for (Class clazz : this.mTargetTypeChildExcludes) {
                    if (!clazz.isInstance(view)) continue;
                    return;
                }
            }
            for (int i = 0; i < parent.getChildCount(); ++i) {
                this.captureHierarchy(parent.getChildAt(i), start);
            }
        }
    }

    @Nullable
    public TransitionValues getTransitionValues(@Nonnull View view, boolean start) {
        if (this.mParent != null) {
            return this.mParent.getTransitionValues(view, start);
        }
        TransitionValuesMaps valuesMaps = start ? this.mStartValues : this.mEndValues;
        return valuesMaps.mViewValues.get(view);
    }

    @Nullable
    TransitionValues getMatchedTransitionValues(@Nonnull View view, boolean viewInStart) {
        ArrayList<TransitionValues> lookIn;
        if (this.mParent != null) {
            return this.mParent.getMatchedTransitionValues(view, viewInStart);
        }
        ArrayList<TransitionValues> arrayList = lookIn = viewInStart ? this.mStartValuesList : this.mEndValuesList;
        if (lookIn == null) {
            return null;
        }
        int count = lookIn.size();
        int index = -1;
        for (int i = 0; i < count; ++i) {
            TransitionValues values = lookIn.get(i);
            if (values == null) {
                return null;
            }
            if (values.view != view) continue;
            index = i;
            break;
        }
        TransitionValues values = null;
        if (index >= 0) {
            ArrayList<TransitionValues> matchIn = viewInStart ? this.mEndValuesList : this.mStartValuesList;
            values = matchIn.get(index);
        }
        return values;
    }

    public void pause(View sceneRoot) {
        if (!this.mEnded) {
            int numAnimators = this.mCurrentAnimators.size();
            for (int i = numAnimators - 1; i >= 0; --i) {
                Animator animator = this.mCurrentAnimators.get(i);
                animator.pause();
            }
            if (this.mListeners != null && this.mListeners.size() > 0) {
                for (TransitionListener listener : this.mListeners) {
                    listener.onTransitionPause(this);
                }
            }
            this.mPaused = true;
        }
    }

    protected void resume(@Nonnull View sceneRoot) {
        if (this.mPaused) {
            if (!this.mEnded) {
                for (int i = this.mCurrentAnimators.size() - 1; i >= 0; --i) {
                    this.mCurrentAnimators.get(i).resume();
                }
                if (this.mListeners != null && this.mListeners.size() > 0) {
                    for (TransitionListener listener : this.mListeners) {
                        listener.onTransitionResume(this);
                    }
                }
            }
            this.mPaused = false;
        }
    }

    void playTransition(@Nonnull ViewGroup sceneRoot) {
        this.mStartValuesList = new ArrayList();
        this.mEndValuesList = new ArrayList();
        this.matchStartAndEnd(this.mStartValues, this.mEndValues);
        ArrayMap<Animator, AnimationInfo> runningAnimators = sRunningAnimators.get();
        for (int i = runningAnimators.size() - 1; i >= 0; --i) {
            boolean cancel;
            AnimationInfo oldInfo;
            Animator anim = runningAnimators.keyAt(i);
            if (anim == null || (oldInfo = runningAnimators.get(anim)) == null || oldInfo.view == null) continue;
            TransitionValues oldValues = oldInfo.values;
            View oldView = oldInfo.view;
            TransitionValues startValues = this.getTransitionValues(oldView, true);
            TransitionValues endValues = this.getMatchedTransitionValues(oldView, true);
            if (startValues == null && endValues == null) {
                endValues = this.mEndValues.mViewValues.get(oldView);
            }
            boolean bl = cancel = (startValues != null || endValues != null) && oldInfo.transition.isTransitionRequired(oldValues, endValues);
            if (!cancel) continue;
            if (anim.isRunning() || anim.isStarted()) {
                anim.cancel();
                continue;
            }
            runningAnimators.remove(anim);
        }
        this.createAnimators(sceneRoot, this.mStartValues, this.mEndValues, this.mStartValuesList, this.mEndValuesList);
        this.runAnimators();
    }

    public boolean isTransitionRequired(@Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        boolean valuesChanged;
        block4: {
            valuesChanged = false;
            if (startValues == null || endValues == null) break block4;
            String[] properties = this.getTransitionProperties();
            if (properties != null) {
                for (String property : properties) {
                    if (!Transition.isValueChanged(startValues, endValues, property)) continue;
                    valuesChanged = true;
                    break;
                }
            } else {
                for (String key : startValues.values.keySet()) {
                    if (!Transition.isValueChanged(startValues, endValues, key)) continue;
                    valuesChanged = true;
                    break;
                }
            }
        }
        return valuesChanged;
    }

    private static boolean isValueChanged(@Nonnull TransitionValues oldValues, @Nonnull TransitionValues newValues, @Nonnull String key) {
        if (oldValues.values.containsKey(key) != newValues.values.containsKey(key)) {
            return false;
        }
        Object oldValue = oldValues.values.get(key);
        Object newValue = newValues.values.get(key);
        boolean changed = oldValue == null && newValue == null ? false : (oldValue == null || newValue == null ? true : !oldValue.equals(newValue));
        return changed;
    }

    protected void animate(@Nullable Animator animator) {
        if (animator == null) {
            this.end();
        } else {
            if (this.getDuration() >= 0L) {
                animator.setDuration(this.getDuration());
            }
            if (this.getStartDelay() >= 0L) {
                animator.setStartDelay(this.getStartDelay() + animator.getStartDelay());
            }
            if (this.getInterpolator() != null) {
                animator.setInterpolator(this.getInterpolator());
            }
            animator.addListener(new AnimatorListener(){

                @Override
                public void onAnimationEnd(@Nonnull Animator animation) {
                    Transition.this.end();
                    animation.removeListener(this);
                }
            });
            animator.start();
        }
    }

    protected void start() {
        if (this.mNumInstances == 0) {
            if (this.mListeners != null && this.mListeners.size() > 0) {
                for (TransitionListener listener : this.mListeners) {
                    listener.onTransitionStart(this);
                }
            }
            this.mEnded = false;
        }
        ++this.mNumInstances;
    }

    protected void end() {
        --this.mNumInstances;
        if (this.mNumInstances == 0) {
            View view;
            int i;
            if (this.mListeners != null && this.mListeners.size() > 0) {
                for (TransitionListener listener : this.mListeners) {
                    listener.onTransitionEnd(this);
                }
            }
            for (i = 0; i < this.mStartValues.mItemIdValues.size(); ++i) {
                view = this.mStartValues.mItemIdValues.valueAt(i);
                if (view == null) continue;
                view.setHasTransientState(false);
            }
            for (i = 0; i < this.mEndValues.mItemIdValues.size(); ++i) {
                view = this.mEndValues.mItemIdValues.valueAt(i);
                if (view == null) continue;
                view.setHasTransientState(false);
            }
            this.mEnded = true;
        }
    }

    void forceToEnd(@Nonnull ViewGroup sceneRoot) {
        ArrayMap<Animator, AnimationInfo> runningAnimators = sRunningAnimators.get();
        int size = runningAnimators.size();
        if (size == 0) {
            return;
        }
        ArrayMap<Animator, AnimationInfo> animators = new ArrayMap<Animator, AnimationInfo>(runningAnimators);
        runningAnimators.clear();
        for (int i = size - 1; i >= 0; --i) {
            AnimationInfo info = animators.valueAt(i);
            if (info.view == null) continue;
            animators.keyAt(i).end();
        }
    }

    public void cancel() {
        for (int i = this.mCurrentAnimators.size() - 1; i >= 0; --i) {
            this.mCurrentAnimators.get(i).cancel();
        }
        if (this.mListeners != null && this.mListeners.size() > 0) {
            for (TransitionListener listener : this.mListeners) {
                listener.onTransitionCancel(this);
            }
        }
    }

    @Nonnull
    public Transition addListener(@Nonnull TransitionListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new CopyOnWriteArrayList();
        }
        this.mListeners.addIfAbsent(listener);
        return this;
    }

    @Nonnull
    public Transition removeListener(@Nonnull TransitionListener listener) {
        if (this.mListeners == null) {
            return this;
        }
        this.mListeners.remove(listener);
        if (this.mListeners.isEmpty()) {
            this.mListeners = null;
        }
        return this;
    }

    public void setEpicenterCallback(@Nullable EpicenterCallback epicenterCallback) {
        this.mEpicenterCallback = epicenterCallback;
    }

    @Nullable
    public EpicenterCallback getEpicenterCallback() {
        return this.mEpicenterCallback;
    }

    @Nullable
    public Rect getEpicenter() {
        if (this.mEpicenterCallback == null) {
            return null;
        }
        return this.mEpicenterCallback.onGetEpicenter(this);
    }

    public void setPropagation(@Nullable TransitionPropagation transitionPropagation) {
        this.mPropagation = transitionPropagation;
    }

    @Nullable
    public TransitionPropagation getPropagation() {
        return this.mPropagation;
    }

    void capturePropagationValues(@Nonnull TransitionValues transitionValues) {
        if (this.mPropagation != null && !transitionValues.values.isEmpty()) {
            String[] propertyNames = this.mPropagation.getPropagationProperties();
            if (propertyNames == null) {
                return;
            }
            boolean containsAll = true;
            for (String propertyName : propertyNames) {
                if (transitionValues.values.containsKey(propertyName)) continue;
                containsAll = false;
                break;
            }
            if (!containsAll) {
                this.mPropagation.captureValues(transitionValues);
            }
        }
    }

    void setCanRemoveViews(boolean canRemoveViews) {
        this.mCanRemoveViews = canRemoveViews;
    }

    @Nonnull
    public String getName() {
        return this.getClass().getName();
    }

    public String toString() {
        return this.toString("");
    }

    String toString(String indent) {
        StringBuilder sb = new StringBuilder(indent + this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": ");
        if (this.mDuration != -1L) {
            sb.append("duration(").append(this.mDuration).append(") ");
        }
        if (this.mStartDelay != -1L) {
            sb.append("delay(").append(this.mStartDelay).append(") ");
        }
        if (this.mInterpolator != null) {
            sb.append("interpolator(").append(this.mInterpolator).append(") ");
        }
        if (this.mTargetIds.size() > 0 || this.mTargets.size() > 0) {
            int i;
            sb.append("targets(");
            if (this.mTargetIds.size() > 0) {
                for (i = 0; i < this.mTargetIds.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.mTargetIds.getInt(i));
                }
            }
            if (this.mTargets.size() > 0) {
                for (i = 0; i < this.mTargets.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.mTargets.get(i));
                }
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public Transition clone() {
        try {
            Transition clone = (Transition)super.clone();
            clone.mAnimators = new ArrayList();
            clone.mStartValues = new TransitionValuesMaps();
            clone.mEndValues = new TransitionValuesMaps();
            clone.mStartValuesList = null;
            clone.mEndValuesList = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    static final class TransitionValuesMaps {
        final ArrayMap<View, TransitionValues> mViewValues = new ArrayMap();
        final SparseArray<View> mIdValues = new SparseArray();
        final LongSparseArray<View> mItemIdValues = new LongSparseArray();
        final ArrayMap<String, View> mNameValues = new ArrayMap();

        TransitionValuesMaps() {
        }
    }

    private record AnimationInfo(View view, String name, Transition transition, TransitionValues values) {
    }

    private static class ArrayListManager {
        private ArrayListManager() {
        }

        @Nonnull
        static <T> ArrayList<T> add(@Nullable ArrayList<T> list, T item) {
            if (list == null) {
                list = new ArrayList();
            }
            if (!list.contains(item)) {
                list.add(item);
            }
            return list;
        }

        @Nonnull
        static IntArrayList add(@Nullable IntArrayList list, int item) {
            if (list == null) {
                list = new IntArrayList();
            }
            if (!list.contains(item)) {
                list.add(item);
            }
            return list;
        }

        @Nullable
        static <T> ArrayList<T> remove(@Nullable ArrayList<T> list, T item) {
            if (list != null) {
                list.remove(item);
                if (list.isEmpty()) {
                    list = null;
                }
            }
            return list;
        }

        @Nullable
        static IntArrayList remove(@Nullable IntArrayList list, int item) {
            if (list != null) {
                list.rem(item);
                if (list.isEmpty()) {
                    list = null;
                }
            }
            return list;
        }
    }

    @FunctionalInterface
    public static interface EpicenterCallback {
        @Nullable
        public Rect onGetEpicenter(@Nonnull Transition var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MatchOrder {
    }
}

