/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.text.style;

import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.text.ParcelableSpan;
import icyllis.modernui.text.TextPaint;
import icyllis.modernui.text.style.MetricAffectingSpan;
import icyllis.modernui.util.Parcel;
import java.util.Locale;
import java.util.Objects;

public class LocaleSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    @Nullable
    private final Locale mLocale;

    public LocaleSpan(@Nullable Locale locale) {
        this.mLocale = locale;
    }

    public LocaleSpan(@NonNull Parcel source) {
        String tag = source.readString8();
        this.mLocale = tag == null || tag.isEmpty() ? null : Locale.forLanguageTag(tag);
    }

    @Override
    public int getSpanTypeId() {
        return 23;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString8(this.mLocale != null ? this.mLocale.toLanguageTag() : "");
    }

    @Override
    public void updateMeasureState(@NonNull TextPaint paint) {
        paint.setTextLocale(Objects.requireNonNull(this.mLocale, "locale cannot be null"));
    }

    @Nullable
    public Locale getLocale() {
        return this.mLocale;
    }
}

