/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.engine.SamplerDesc;
import icyllis.arc3d.opengl.GLCaps;
import icyllis.arc3d.opengl.GLSampler;
import icyllis.modernui.ModernUI;
import icyllis.modernui.core.Core;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.MuiModApi;
import icyllis.modernui.mc.text.TextLayoutEngine;
import icyllis.modernui.mc.text.mixin.AccessRenderBuffers;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3268;
import net.minecraft.class_327;
import net.minecraft.class_3298;
import net.minecraft.class_4668;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.lwjgl.opengl.GL33C;

public class TextRenderType
extends class_1921 {
    public static final int MODE_NORMAL = 0;
    public static final int MODE_SDF_FILL = 1;
    public static final int MODE_SDF_STROKE = 2;
    public static final int MODE_SEE_THROUGH = 3;
    public static final int MODE_UNIFORM_SCALE = 4;
    private static volatile class_5944 sShaderNormal;
    private static volatile class_5944 sCurrentShaderSDFFill;
    private static volatile class_5944 sCurrentShaderSDFStroke;
    private static volatile class_5944 sShaderSDFFill;
    private static volatile class_5944 sShaderSDFStroke;
    @Nullable
    private static volatile class_5944 sShaderSDFFillSmart;
    @Nullable
    private static volatile class_5944 sShaderSDFStrokeSmart;
    private static boolean sSmartShadersLoaded;
    static final class_4668.class_5942 RENDERTYPE_MODERN_TEXT_NORMAL;
    static final class_4668.class_5942 RENDERTYPE_MODERN_TEXT_SDF_FILL;
    static final class_4668.class_5942 RENDERTYPE_MODERN_TEXT_SDF_STROKE;
    private static final ImmutableList<class_4668> NORMAL_STATES;
    private static final ImmutableList<class_4668> SDF_FILL_STATES;
    private static final ImmutableList<class_4668> SDF_STROKE_STATES;
    static final ImmutableList<class_4668> VANILLA_STATES;
    static final ImmutableList<class_4668> SEE_THROUGH_STATES;
    static final ImmutableList<class_4668> POLYGON_OFFSET_STATES;
    private static final Int2ObjectOpenHashMap<TextRenderType> sNormalTypes;
    private static final Int2ObjectOpenHashMap<TextRenderType> sSDFFillTypes;
    private static final Int2ObjectOpenHashMap<TextRenderType> sSDFStrokeTypes;
    private static final Int2ObjectOpenHashMap<TextRenderType> sVanillaTypes;
    private static final Int2ObjectOpenHashMap<TextRenderType> sSeeThroughTypes;
    private static final Int2ObjectOpenHashMap<TextRenderType> sPolygonOffsetTypes;
    private static TextRenderType sFirstSDFFillType;
    private static final class_287 sFirstSDFFillBuffer;
    private static TextRenderType sFirstSDFStrokeType;
    private static final class_287 sFirstSDFStrokeBuffer;
    @SharedPtr
    private static GLSampler sLinearFontSampler;

    private TextRenderType(String name, int bufferSize, Runnable setupState, Runnable clearState) {
        super(name, class_290.field_20888, class_293.class_5596.field_27382, bufferSize, false, true, setupState, clearState);
    }

    @Nonnull
    public static TextRenderType getOrCreate(int texture, int mode) {
        return switch (mode) {
            case 1 -> (TextRenderType)((Object)sSDFFillTypes.computeIfAbsent(texture, TextRenderType::makeSDFFillType));
            case 2 -> (TextRenderType)((Object)sSDFStrokeTypes.computeIfAbsent(texture, TextRenderType::makeSDFStrokeType));
            case 3 -> (TextRenderType)((Object)sSeeThroughTypes.computeIfAbsent(texture, TextRenderType::makeSeeThroughType));
            default -> (TextRenderType)((Object)sNormalTypes.computeIfAbsent(texture, TextRenderType::makeNormalType));
        };
    }

    @Nonnull
    public static TextRenderType getOrCreate(int texture, class_327.class_6415 mode, boolean isBitmapFont) {
        return switch (mode) {
            case class_327.class_6415.field_33994 -> (TextRenderType)((Object)sSeeThroughTypes.computeIfAbsent(texture, TextRenderType::makeSeeThroughType));
            case class_327.class_6415.field_33995 -> (TextRenderType)((Object)sPolygonOffsetTypes.computeIfAbsent(texture, TextRenderType::makePolygonOffsetType));
            default -> isBitmapFont ? (TextRenderType)((Object)sVanillaTypes.computeIfAbsent(texture, TextRenderType::makeVanillaType)) : (TextRenderType)((Object)sNormalTypes.computeIfAbsent(texture, TextRenderType::makeNormalType));
        };
    }

    @Nonnull
    private static TextRenderType makeNormalType(int texture) {
        return new TextRenderType("modern_text_normal", 256, () -> {
            NORMAL_STATES.forEach(class_4668::method_23516);
            RenderSystem.setShaderTexture((int)0, (int)texture);
        }, () -> NORMAL_STATES.forEach(class_4668::method_23518));
    }

    private static void ensureLinearFontSampler() {
        if (sLinearFontSampler == null) {
            ImmediateContext context = Core.requireImmediateContext();
            sLinearFontSampler = (GLSampler)context.getResourceProvider().findOrCreateCompatibleSampler(SamplerDesc.make(1, 2));
            Objects.requireNonNull(sLinearFontSampler, "Failed to create sampler object");
        }
    }

    @Nonnull
    private static TextRenderType makeSDFFillType(int texture) {
        TextRenderType.ensureLinearFontSampler();
        TextRenderType renderType = new TextRenderType("modern_text_sdf_fill", 256, () -> {
            SDF_FILL_STATES.forEach(class_4668::method_23516);
            RenderSystem.setShaderTexture((int)0, (int)texture);
            if (!TextLayoutEngine.sCurrentInWorldRendering || TextLayoutEngine.sUseTextShadersInWorld) {
                GL33C.glBindSampler((int)0, (int)sLinearFontSampler.getHandle());
            }
        }, () -> {
            SDF_FILL_STATES.forEach(class_4668::method_23518);
            if (!TextLayoutEngine.sCurrentInWorldRendering || TextLayoutEngine.sUseTextShadersInWorld) {
                GL33C.glBindSampler((int)0, (int)0);
            }
        });
        if (sFirstSDFFillType == null) {
            assert (sSDFFillTypes.isEmpty());
            sFirstSDFFillType = renderType;
            if (TextLayoutEngine.sUseTextShadersInWorld) {
                try {
                    ((AccessRenderBuffers)class_310.method_1551().method_22940()).getFixedBuffers().put(renderType, sFirstSDFFillBuffer);
                }
                catch (Exception e) {
                    ModernUI.LOGGER.warn(TextLayoutEngine.MARKER, "Failed to add SDF fill to fixed buffers", (Throwable)e);
                }
            }
        }
        return renderType;
    }

    @Nonnull
    private static TextRenderType makeSDFStrokeType(int texture) {
        TextRenderType.ensureLinearFontSampler();
        TextRenderType renderType = new TextRenderType("modern_text_sdf_stroke", 256, () -> {
            SDF_STROKE_STATES.forEach(class_4668::method_23516);
            RenderSystem.setShaderTexture((int)0, (int)texture);
            if (!TextLayoutEngine.sCurrentInWorldRendering || TextLayoutEngine.sUseTextShadersInWorld) {
                GL33C.glBindSampler((int)0, (int)sLinearFontSampler.getHandle());
            }
        }, () -> {
            SDF_STROKE_STATES.forEach(class_4668::method_23518);
            if (!TextLayoutEngine.sCurrentInWorldRendering || TextLayoutEngine.sUseTextShadersInWorld) {
                GL33C.glBindSampler((int)0, (int)0);
            }
        });
        if (sFirstSDFStrokeType == null) {
            assert (sSDFStrokeTypes.isEmpty());
            sFirstSDFStrokeType = renderType;
            if (TextLayoutEngine.sUseTextShadersInWorld) {
                try {
                    ((AccessRenderBuffers)class_310.method_1551().method_22940()).getFixedBuffers().put(renderType, sFirstSDFStrokeBuffer);
                }
                catch (Exception e) {
                    ModernUI.LOGGER.warn(TextLayoutEngine.MARKER, "Failed to add SDF stroke to fixed buffers", (Throwable)e);
                }
            }
        }
        return renderType;
    }

    @Nonnull
    private static TextRenderType makeVanillaType(int texture) {
        return new TextRenderType("modern_text_vanilla", 256, () -> {
            VANILLA_STATES.forEach(class_4668::method_23516);
            RenderSystem.setShaderTexture((int)0, (int)texture);
        }, () -> VANILLA_STATES.forEach(class_4668::method_23518));
    }

    @Nonnull
    private static TextRenderType makeSeeThroughType(int texture) {
        return new TextRenderType("modern_text_see_through", 256, () -> {
            SEE_THROUGH_STATES.forEach(class_4668::method_23516);
            RenderSystem.setShaderTexture((int)0, (int)texture);
        }, () -> SEE_THROUGH_STATES.forEach(class_4668::method_23518));
    }

    @Nonnull
    private static TextRenderType makePolygonOffsetType(int texture) {
        return new TextRenderType("modern_text_polygon_offset", 256, () -> {
            POLYGON_OFFSET_STATES.forEach(class_4668::method_23516);
            RenderSystem.setShaderTexture((int)0, (int)texture);
        }, () -> POLYGON_OFFSET_STATES.forEach(class_4668::method_23518));
    }

    @Nullable
    public static TextRenderType getFirstSDFFillType() {
        return sFirstSDFFillType;
    }

    @Nullable
    public static TextRenderType getFirstSDFStrokeType() {
        return sFirstSDFStrokeType;
    }

    public static synchronized void clear(boolean cleanup) {
        AccessRenderBuffers access;
        if (sFirstSDFFillType != null) {
            assert (!sSDFFillTypes.isEmpty());
            access = (AccessRenderBuffers)class_310.method_1551().method_22940();
            try {
                access.getFixedBuffers().remove((Object)sFirstSDFFillType, sFirstSDFFillBuffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sFirstSDFFillType = null;
        }
        if (sFirstSDFStrokeType != null) {
            assert (!sSDFStrokeTypes.isEmpty());
            access = (AccessRenderBuffers)class_310.method_1551().method_22940();
            try {
                access.getFixedBuffers().remove((Object)sFirstSDFStrokeType, sFirstSDFStrokeBuffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sFirstSDFStrokeType = null;
        }
        sNormalTypes.clear();
        sSDFFillTypes.clear();
        sSDFStrokeTypes.clear();
        sVanillaTypes.clear();
        sSeeThroughTypes.clear();
        sPolygonOffsetTypes.clear();
        sFirstSDFFillBuffer.method_1343();
        sFirstSDFStrokeBuffer.method_1343();
        if (cleanup) {
            sLinearFontSampler = RefCnt.move(sLinearFontSampler);
            if (sShaderNormal != null) {
                sShaderNormal.close();
            }
            if (sShaderSDFFill != null) {
                sShaderSDFFill.close();
            }
            if (sShaderSDFStroke != null) {
                sShaderSDFStroke.close();
            }
            if (sShaderSDFFillSmart != null) {
                sShaderSDFFillSmart.close();
            }
            if (sShaderSDFStrokeSmart != null) {
                sShaderSDFStrokeSmart.close();
            }
            sShaderNormal = null;
            sShaderSDFFill = null;
            sShaderSDFStroke = null;
            sShaderSDFFillSmart = null;
            sShaderSDFStrokeSmart = null;
            sCurrentShaderSDFFill = null;
            sCurrentShaderSDFStroke = null;
        }
    }

    public static class_5944 getShaderNormal() {
        if (TextLayoutEngine.sCurrentInWorldRendering && !TextLayoutEngine.sUseTextShadersInWorld) {
            return class_757.method_34529();
        }
        return sShaderNormal;
    }

    public static class_5944 getShaderSDFFill() {
        if (TextLayoutEngine.sCurrentInWorldRendering && !TextLayoutEngine.sUseTextShadersInWorld) {
            return class_757.method_34529();
        }
        return sCurrentShaderSDFFill;
    }

    public static class_5944 getShaderSDFStroke() {
        return sCurrentShaderSDFStroke;
    }

    public static synchronized void toggleSDFShaders(boolean smart) {
        if (smart) {
            if (!sSmartShadersLoaded) {
                sSmartShadersLoaded = true;
                if (((GLCaps)Core.requireImmediateContext().getCaps()).getGLSLVersion() >= 400) {
                    class_5912 provider = TextRenderType.obtainResourceProvider();
                    try {
                        sShaderSDFFillSmart = MuiModApi.get().makeShaderInstance(provider, ModernUIMod.location("rendertype_modern_text_sdf_fill_400"), class_290.field_20888);
                        sShaderSDFStrokeSmart = MuiModApi.get().makeShaderInstance(provider, ModernUIMod.location("rendertype_modern_text_sdf_stroke_400"), class_290.field_20888);
                        ModernUI.LOGGER.info(TextLayoutEngine.MARKER, "Loaded smart SDF text shaders");
                    }
                    catch (IOException e) {
                        ModernUI.LOGGER.error(TextLayoutEngine.MARKER, "Failed to load smart SDF text shaders", (Throwable)e);
                    }
                } else {
                    ModernUI.LOGGER.info(TextLayoutEngine.MARKER, "No GLSL 400, smart SDF text shaders disabled");
                }
            }
            if (sShaderSDFStrokeSmart != null) {
                sCurrentShaderSDFFill = sShaderSDFFillSmart;
                sCurrentShaderSDFStroke = sShaderSDFStrokeSmart;
                return;
            }
        }
        sCurrentShaderSDFFill = sShaderSDFFill;
        sCurrentShaderSDFStroke = sShaderSDFStroke;
    }

    public static synchronized void preloadShaders() {
        if (sShaderNormal != null) {
            return;
        }
        class_5912 provider = TextRenderType.obtainResourceProvider();
        try {
            sShaderNormal = MuiModApi.get().makeShaderInstance(provider, ModernUIMod.location("rendertype_modern_text_normal"), class_290.field_20888);
            sShaderSDFFill = MuiModApi.get().makeShaderInstance(provider, ModernUIMod.location("rendertype_modern_text_sdf_fill"), class_290.field_20888);
            sShaderSDFStroke = MuiModApi.get().makeShaderInstance(provider, ModernUIMod.location("rendertype_modern_text_sdf_stroke"), class_290.field_20888);
        }
        catch (IOException e) {
            throw new IllegalStateException("Bad text shaders", e);
        }
        TextRenderType.toggleSDFShaders(false);
        ModernUI.LOGGER.info(TextLayoutEngine.MARKER, "Preloaded modern text shaders");
    }

    @Nonnull
    private static class_5912 obtainResourceProvider() {
        class_3268 source = class_310.method_1551().method_45573();
        class_5912 fallback = source.method_43032();
        return location -> {
            InputStream stream = TextRenderType.class.getResourceAsStream("/assets/" + location.method_12836() + "/" + location.method_12832());
            if (stream == null) {
                return fallback.method_14486(location);
            }
            return Optional.of(new class_3298((class_3262)source, () -> stream));
        };
    }

    static {
        sSmartShadersLoaded = false;
        RENDERTYPE_MODERN_TEXT_NORMAL = new class_4668.class_5942(TextRenderType::getShaderNormal);
        RENDERTYPE_MODERN_TEXT_SDF_FILL = new class_4668.class_5942(TextRenderType::getShaderSDFFill);
        RENDERTYPE_MODERN_TEXT_SDF_STROKE = new class_4668.class_5942(TextRenderType::getShaderSDFStroke);
        sNormalTypes = new Int2ObjectOpenHashMap();
        sSDFFillTypes = new Int2ObjectOpenHashMap();
        sSDFStrokeTypes = new Int2ObjectOpenHashMap();
        sVanillaTypes = new Int2ObjectOpenHashMap();
        sSeeThroughTypes = new Int2ObjectOpenHashMap();
        sPolygonOffsetTypes = new Int2ObjectOpenHashMap();
        sFirstSDFFillBuffer = new class_287(131072);
        sFirstSDFStrokeBuffer = new class_287(131072);
        NORMAL_STATES = ImmutableList.of((Object)RENDERTYPE_MODERN_TEXT_NORMAL, (Object)field_21370, (Object)field_21348, (Object)field_21344, (Object)field_21383, (Object)field_21386, (Object)field_21352, (Object)field_21358, (Object)field_21379, (Object)field_21349, (Object)field_21360);
        SDF_FILL_STATES = ImmutableList.of((Object)RENDERTYPE_MODERN_TEXT_SDF_FILL, (Object)field_21370, (Object)field_21348, (Object)field_21344, (Object)field_21383, (Object)field_21386, (Object)field_21353, (Object)field_21358, (Object)field_21379, (Object)field_21349, (Object)field_21360);
        SDF_STROKE_STATES = ImmutableList.of((Object)RENDERTYPE_MODERN_TEXT_SDF_STROKE, (Object)field_21370, (Object)field_21348, (Object)field_21344, (Object)field_21383, (Object)field_21386, (Object)field_21353, (Object)field_21358, (Object)field_21379, (Object)field_21349, (Object)field_21360);
        VANILLA_STATES = ImmutableList.of((Object)field_29427, (Object)field_21370, (Object)field_21348, (Object)field_21344, (Object)field_21383, (Object)field_21386, (Object)field_21352, (Object)field_21358, (Object)field_21379, (Object)field_21349, (Object)field_21360);
        SEE_THROUGH_STATES = ImmutableList.of((Object)field_29428, (Object)field_21370, (Object)field_21346, (Object)field_21344, (Object)field_21383, (Object)field_21386, (Object)field_21352, (Object)field_21358, (Object)field_21379, (Object)field_21350, (Object)field_21360);
        POLYGON_OFFSET_STATES = ImmutableList.of((Object)field_29427, (Object)field_21370, (Object)field_21348, (Object)field_21344, (Object)field_21383, (Object)field_21386, (Object)field_21353, (Object)field_21358, (Object)field_21379, (Object)field_21349, (Object)field_21360);
    }
}

