/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import icyllis.arc3d.core.ColorInfo;
import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.RectanglePacker;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.Engine;
import icyllis.arc3d.engine.ImageDesc;
import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.opengl.GLCaps;
import icyllis.arc3d.opengl.GLDevice;
import icyllis.arc3d.opengl.GLTexture;
import icyllis.modernui.ModernUI;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.core.Core;
import icyllis.modernui.graphics.Bitmap;
import icyllis.modernui.mc.text.GLBakedGlyph;
import icyllis.modernui.mc.text.GlyphManager;
import icyllis.modernui.text.TextUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GL45C;

@RenderThread
public class GLFontAtlas
implements AutoCloseable {
    public static final int CHUNK_SIZE = 512;
    private final Long2ObjectOpenHashMap<GLBakedGlyph> mGlyphs = new Long2ObjectOpenHashMap();
    @SharedPtr
    GLTexture mTexture = null;
    private final List<Chunk> mChunks = new ArrayList<Chunk>();
    private int mWidth = 0;
    private int mHeight = 0;
    private final Rect2i mRect = new Rect2i();
    private final ImmediateContext mContext;
    private final int mMaskFormat;
    private final int mBorderWidth;
    private final int mMaxTextureSize;
    public static volatile boolean sLinearSamplingA8Atlas = false;
    private final boolean mLinearSampling;
    private int mLastCompactChunkIndex;

    @RenderThread
    public GLFontAtlas(ImmediateContext context, int maskFormat, int borderWidth, boolean linearSampling) {
        this.mContext = context;
        this.mMaskFormat = maskFormat;
        this.mBorderWidth = borderWidth;
        this.mMaxTextureSize = Math.min(this.mContext.getMaxTextureSize(), maskFormat == 0 ? 8192 : 4096);
        this.mLinearSampling = linearSampling;
        assert (this.mMaxTextureSize >= 1024);
        assert (this.mBorderWidth >= 0 && this.mBorderWidth <= 2);
    }

    @Nullable
    public GLBakedGlyph getGlyph(long key) {
        return (GLBakedGlyph)this.mGlyphs.computeIfAbsent(key, __ -> new GLBakedGlyph());
    }

    public void setNoPixels(long key) {
        this.mGlyphs.put(key, null);
    }

    public boolean stitch(@NonNull GLBakedGlyph glyph, long pixels) {
        boolean invalidated = false;
        if (this.mWidth == 0) {
            this.resize();
        }
        Rect2i rect = this.mRect;
        rect.set(0, 0, glyph.width + this.mBorderWidth * 2, glyph.height + this.mBorderWidth * 2);
        boolean inserted = false;
        for (Chunk chunk : this.mChunks) {
            if (!chunk.packer.addRect(rect)) continue;
            inserted = true;
            rect.offset(chunk.x, chunk.y);
            break;
        }
        if (!inserted) {
            invalidated = this.resize();
            for (Chunk chunk : this.mChunks) {
                if (!chunk.packer.addRect(rect)) continue;
                inserted = true;
                rect.offset(chunk.x, chunk.y);
                break;
            }
        }
        if (!inserted) {
            return invalidated;
        }
        int colorType = this.mMaskFormat == 2 ? 6 : 19;
        int rowBytes = rect.width() * ColorInfo.bytesPerPixel(colorType);
        boolean res = ((GLDevice)this.mContext.getDevice()).writePixels(this.mTexture, rect.x(), rect.y(), rect.width(), rect.height(), colorType, colorType, rowBytes, pixels);
        if (!res) {
            ModernUI.LOGGER.warn(GlyphManager.MARKER, "Failed to write glyph pixels");
        }
        glyph.u1 = (float)(rect.mLeft + this.mBorderWidth) / (float)this.mWidth;
        glyph.v1 = (float)(rect.mTop + this.mBorderWidth) / (float)this.mHeight;
        glyph.u2 = (float)(rect.mRight - this.mBorderWidth) / (float)this.mWidth;
        glyph.v2 = (float)(rect.mBottom - this.mBorderWidth) / (float)this.mHeight;
        return invalidated;
    }

    private boolean resize() {
        if (this.mTexture == null) {
            this.mHeight = this.mMaskFormat == 0 ? 2048 : 1024;
            this.mWidth = this.mHeight;
            this.mTexture = this.createTexture();
            for (int x = 0; x < this.mWidth; x += 512) {
                for (int y = 0; y < this.mHeight; y += 512) {
                    this.mChunks.add(new Chunk(x, y, RectanglePacker.make(512, 512)));
                }
            }
        } else {
            boolean vertical;
            int oldWidth = this.mWidth;
            int oldHeight = this.mHeight;
            if (oldWidth == this.mMaxTextureSize && oldHeight == this.mMaxTextureSize) {
                ModernUI.LOGGER.warn(GlyphManager.MARKER, "Font atlas reached max texture size, mask format: {}, max size: {}, current texture: {}", (Object)this.mMaskFormat, (Object)this.mMaxTextureSize, (Object)this.mTexture);
                return false;
            }
            if (this.mHeight != this.mWidth) {
                this.mWidth <<= 1;
                for (x = this.mWidth / 2; x < this.mWidth; x += 512) {
                    for (y = 0; y < this.mHeight; y += 512) {
                        this.mChunks.add(new Chunk(x, y, RectanglePacker.make(512, 512)));
                    }
                }
                vertical = false;
            } else {
                this.mHeight <<= 1;
                for (x = 0; x < this.mWidth; x += 512) {
                    for (y = this.mHeight / 2; y < this.mHeight; y += 512) {
                        this.mChunks.add(new Chunk(x, y, RectanglePacker.make(512, 512)));
                    }
                }
                vertical = true;
            }
            GLTexture newTexture = this.createTexture();
            boolean res = ((GLDevice)this.mContext.getDevice()).copyImage(this.mTexture, 0, 0, newTexture, 0, 0, oldWidth, oldHeight);
            if (!res) {
                ModernUI.LOGGER.warn(GlyphManager.MARKER, "Failed to copy to new texture");
            }
            this.mTexture = RefCnt.move(this.mTexture, newTexture);
            if (vertical) {
                for (GLBakedGlyph glyph : this.mGlyphs.values()) {
                    if (glyph == null) continue;
                    glyph.v1 *= 0.5f;
                    glyph.v2 *= 0.5f;
                }
            } else {
                for (GLBakedGlyph glyph : this.mGlyphs.values()) {
                    if (glyph == null) continue;
                    glyph.u1 *= 0.5f;
                    glyph.u2 *= 0.5f;
                }
            }
        }
        int boundTexture = GL33C.glGetInteger((int)32873);
        GL33C.glBindTexture((int)3553, (int)this.mTexture.getHandle());
        GL33C.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL33C.glTexParameteri((int)3553, (int)10241, (int)(this.mLinearSampling && (sLinearSamplingA8Atlas || this.mMaskFormat == 2) ? 9987 : 9728));
        if (this.mMaskFormat == 0) {
            GL33C.glTexParameteri((int)3553, (int)36418, (int)1);
            GL33C.glTexParameteri((int)3553, (int)36419, (int)1);
            GL33C.glTexParameteri((int)3553, (int)36420, (int)1);
            GL33C.glTexParameteri((int)3553, (int)36421, (int)6403);
        }
        GL33C.glBindTexture((int)3553, (int)boundTexture);
        return true;
    }

    private GLTexture createTexture() {
        ImageDesc desc = this.mContext.getCaps().getDefaultColorImageDesc(1, Engine.maskFormatToColorType(this.mMaskFormat), this.mWidth, this.mHeight, 1, 8 | (this.mLinearSampling ? 4 : 0));
        Objects.requireNonNull(desc, "No suitable image descriptor");
        return (GLTexture)Objects.requireNonNull(this.mContext.getResourceProvider().findOrCreateImage(desc, true, "FontAtlas" + this.mMaskFormat), "Failed to create font atlas");
    }

    public GLTexture getTexture() {
        return this.mTexture;
    }

    public int getMaskFormat() {
        return this.mMaskFormat;
    }

    public boolean compact() {
        if (this.mWidth < this.mMaxTextureSize && this.mHeight < this.mMaxTextureSize) {
            return false;
        }
        assert (this.mChunks.size() > 1);
        double coverage = 0.0;
        for (Chunk chunk : this.mChunks) {
            coverage += chunk.packer.getCoverage();
        }
        int chunksPerDim = this.mMaxTextureSize / 512;
        double maxCoverage = (float)(chunksPerDim * chunksPerDim) * 0.25f;
        if (coverage <= maxCoverage) {
            return false;
        }
        double coverageToClean = Math.max(coverage - maxCoverage, maxCoverage);
        boolean cleared = false;
        for (int iChunk = 0; iChunk < Math.min(16, this.mChunks.size()) && coverageToClean > 0.0; ++iChunk) {
            assert (MathUtil.isPow2(this.mChunks.size()));
            int index = this.mLastCompactChunkIndex++ & this.mChunks.size() - 1;
            Chunk chunk = this.mChunks.get(index);
            double cc = chunk.packer.getCoverage();
            if (cc == 0.0) continue;
            coverageToClean -= cc;
            chunk.packer.clear();
            float cu1 = (float)chunk.x / (float)this.mWidth;
            float cv1 = (float)chunk.y / (float)this.mHeight;
            float cu2 = cu1 + 512.0f / (float)this.mWidth;
            float cv2 = cv1 + 512.0f / (float)this.mHeight;
            for (GLBakedGlyph glyph : this.mGlyphs.values()) {
                if (glyph == null || !(glyph.u1 >= cu1) || !(glyph.u2 < cu2) || !(glyph.v1 >= cv1) || !(glyph.v2 < cv2)) continue;
                glyph.x = Integer.MIN_VALUE;
            }
            cleared = true;
        }
        return cleared;
    }

    public void debug(String name, @Nullable String path) {
        if (path == null) {
            ModernUI.LOGGER.info(GlyphManager.MARKER, name);
            for (Long2ObjectMap.Entry glyph : this.mGlyphs.long2ObjectEntrySet()) {
                ModernUI.LOGGER.info(GlyphManager.MARKER, "Key 0x{}: {}", (Object)Long.toHexString(glyph.getLongKey()), glyph.getValue());
            }
        } else if (Core.isOnRenderThread()) {
            ModernUI.LOGGER.info(GlyphManager.MARKER, "{}, Glyphs: {}", (Object)name, (Object)this.mGlyphs.size());
            if (this.mTexture == null) {
                return;
            }
            GLFontAtlas.dumpAtlas((GLCaps)this.mContext.getCaps(), this.mTexture, this.mMaskFormat == 2 ? Bitmap.Format.RGBA_8888 : Bitmap.Format.GRAY_8, path);
        }
    }

    @RenderThread
    public static void dumpAtlas(GLCaps caps, GLTexture texture, Bitmap.Format format, String path) {
        if (caps.hasDSASupport()) {
            int width = texture.getWidth();
            int height = texture.getHeight();
            Bitmap bitmap = Bitmap.createBitmap(width, height, format);
            GL33C.glPixelStorei((int)3330, (int)0);
            GL33C.glPixelStorei((int)3331, (int)0);
            GL33C.glPixelStorei((int)3332, (int)0);
            GL33C.glPixelStorei((int)3333, (int)1);
            int externalGlFormat = switch (format) {
                case Bitmap.Format.GRAY_8 -> 6403;
                case Bitmap.Format.GRAY_ALPHA_88 -> 33319;
                case Bitmap.Format.RGB_888 -> 6407;
                case Bitmap.Format.RGBA_8888 -> 6408;
                default -> throw new IllegalArgumentException();
            };
            GL33C.glBindBuffer((int)35051, (int)0);
            GL45C.glGetTextureImage((int)texture.getHandle(), (int)0, (int)externalGlFormat, (int)5121, (int)((int)bitmap.getSize()), (long)bitmap.getAddress());
            CompletableFuture.runAsync(() -> {
                try (Bitmap bitmap2 = bitmap;){
                    bitmap.saveToPath(Bitmap.SaveFormat.PNG, 0, Path.of(path, new String[0]));
                }
                catch (IOException e) {
                    ModernUI.LOGGER.warn(GlyphManager.MARKER, "Failed to save font atlas", (Throwable)e);
                }
            });
        }
    }

    @Override
    public void close() {
        this.mTexture = RefCnt.move(this.mTexture);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getGlyphCount() {
        return this.mGlyphs.size();
    }

    public long getMemorySize() {
        return this.mTexture != null ? this.mTexture.getMemorySize() : 0L;
    }

    public void dumpInfo(PrintWriter pw, String name) {
        int validGlyphs = 0;
        int emptyGlyphs = 0;
        int evictedGlyphs = 0;
        for (GLBakedGlyph glyph : this.mGlyphs.values()) {
            if (glyph == null) {
                ++emptyGlyphs;
                continue;
            }
            if (glyph.x == Integer.MIN_VALUE) {
                ++evictedGlyphs;
                continue;
            }
            ++validGlyphs;
        }
        pw.print(name);
        pw.printf(": NumGlyphs=%d (in-use: %d, empty: %d, evicted: %d)", this.getGlyphCount(), validGlyphs, emptyGlyphs, evictedGlyphs);
        pw.print(", Coverage=");
        pw.printf("%.4f", this.getCoverage());
        pw.print(", GPUMemorySize=");
        long memorySize = this.getMemorySize();
        TextUtils.binaryCompact(pw, memorySize);
        pw.print(" (");
        pw.print(memorySize);
        pw.println(" bytes)");
    }

    public double getCoverage() {
        if (this.mChunks.isEmpty()) {
            return 0.0;
        }
        double coverage = 0.0;
        for (Chunk chunk : this.mChunks) {
            coverage += chunk.packer.getCoverage();
        }
        return coverage / (double)this.mChunks.size();
    }

    private record Chunk(int x, int y, RectanglePacker packer) {
    }
}

