/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.ImageInfo;
import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.Matrix4;
import icyllis.arc3d.core.Pair;
import icyllis.arc3d.core.PixelUtils;
import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.Surface;
import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.engine.SamplerDesc;
import icyllis.arc3d.granite.GraniteDevice;
import icyllis.arc3d.granite.GraniteSurface;
import icyllis.arc3d.granite.RootTask;
import icyllis.arc3d.opengl.GLDevice;
import icyllis.arc3d.opengl.GLSampler;
import icyllis.arc3d.opengl.GLTexture;
import icyllis.modernui.ModernUI;
import icyllis.modernui.animation.LayoutTransition;
import icyllis.modernui.annotation.MainThread;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.annotation.UiThread;
import icyllis.modernui.audio.AudioManager;
import icyllis.modernui.core.Core;
import icyllis.modernui.core.Handler;
import icyllis.modernui.core.Looper;
import icyllis.modernui.core.Message;
import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.fragment.FragmentContainerView;
import icyllis.modernui.fragment.FragmentController;
import icyllis.modernui.fragment.FragmentHostCallback;
import icyllis.modernui.fragment.OnBackPressedDispatcher;
import icyllis.modernui.fragment.OnBackPressedDispatcherOwner;
import icyllis.modernui.graphics.ArcCanvas;
import icyllis.modernui.graphics.Bitmap;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.ImageStore;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.graphics.text.LayoutCache;
import icyllis.modernui.lifecycle.Lifecycle;
import icyllis.modernui.lifecycle.LifecycleOwner;
import icyllis.modernui.lifecycle.LifecycleRegistry;
import icyllis.modernui.lifecycle.ViewModelStore;
import icyllis.modernui.lifecycle.ViewModelStoreOwner;
import icyllis.modernui.mc.BlurHandler;
import icyllis.modernui.mc.FontResourceManager;
import icyllis.modernui.mc.MinecraftDrawHandler;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.MuiModApi;
import icyllis.modernui.mc.MuiScreen;
import icyllis.modernui.mc.OptiFineIntegration;
import icyllis.modernui.mc.TooltipRenderer;
import icyllis.modernui.mc.text.GlyphManager;
import icyllis.modernui.mc.text.TextLayoutEngine;
import icyllis.modernui.text.Editable;
import icyllis.modernui.text.Selection;
import icyllis.modernui.text.TextUtils;
import icyllis.modernui.view.KeyEvent;
import icyllis.modernui.view.MotionEvent;
import icyllis.modernui.view.PointerIcon;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewRoot;
import icyllis.modernui.view.WindowGroup;
import icyllis.modernui.view.WindowManager;
import icyllis.modernui.view.menu.ContextMenuBuilder;
import icyllis.modernui.view.menu.MenuHelper;
import icyllis.modernui.view.menu.MenuPopupHelper;
import icyllis.modernui.widget.EditText;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_128;
import net.minecraft.class_156;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5684;
import net.minecraft.class_5944;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL33C;

@ApiStatus.Internal
public abstract class UIManager
implements LifecycleOwner {
    protected static final Marker MARKER = MarkerManager.getMarker((String)"UIManager");
    public static volatile boolean sDingEnabled;
    public static volatile boolean sZoomEnabled;
    protected static volatile UIManager sInstance;
    protected static final int fragment_container = 16908295;
    private static final Field SURFACE_DEVICE;
    protected final class_310 minecraft = class_310.method_1551();
    protected final class_1041 mWindow = this.minecraft.method_22683();
    private final class_4587 mEmptyPoseStack = new class_4587();
    private final Thread mUiThread;
    private volatile Looper mLooper;
    private volatile boolean mRunning;
    protected volatile ViewRootImpl mRoot;
    protected WindowGroup mDecor;
    private FragmentContainerView mFragmentContainerView;
    private volatile boolean mDebugLayout = false;
    protected long mElapsedTimeMillis;
    protected long mFrameTimeNanos;
    private final Matrix4 mProjectionMatrix = new Matrix4();
    protected boolean mNoRender = false;
    protected boolean mClearNextMainTarget = false;
    protected boolean mAlwaysClearMainTarget = false;
    private long mLastPurgeNanos;
    protected final TooltipRenderer mTooltipRenderer = new TooltipRenderer();
    @Nullable
    protected volatile MuiScreen mScreen;
    protected boolean mZoomMode = false;
    protected boolean mZoomSmoothCamera;
    protected LifecycleRegistry mFragmentLifecycleRegistry;
    private final OnBackPressedDispatcher mOnBackPressedDispatcher = new OnBackPressedDispatcher(() -> this.minecraft.method_18858(this::onBackPressed));
    private ViewModelStore mViewModelStore;
    protected volatile FragmentController mFragmentController;
    protected int mButtonState;
    private final StringBuilder mCharInputBuffer = new StringBuilder();
    private final Runnable mCommitCharInput = this::commitCharInput;

    protected UIManager() {
        MuiModApi.addOnScrollListener(this::onScroll);
        MuiModApi.addOnScreenChangeListener(this::onScreenChange);
        MuiModApi.addOnWindowResizeListener((width, height, guiScale, oldGuiScale) -> this.resize(width, height));
        MuiModApi.addOnPreKeyInputListener((window, keyCode, scanCode, action, mods) -> {
            if (window == this.minecraft.method_22683().method_4490()) {
                this.onPreKeyInput(keyCode, scanCode, action, mods);
            }
        });
        this.mUiThread = new Thread(this::run, "UI thread");
        this.mUiThread.start();
        AudioManager.getInstance().initialize(true);
        this.mRunning = true;
    }

    @RenderThread
    public static void initializeRenderer() {
        Core.checkRenderThread();
        if (ModernUIMod.isDeveloperMode()) {
            Core.glSetupDebugCallback();
        }
        Objects.requireNonNull(sInstance);
        Core.requireImmediateContext();
        class_286.method_43436();
        ModernUI.LOGGER.info(MARKER, "UI renderer initialized");
    }

    @Nonnull
    public static UIManager getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("UI manager was never initialized. Please check whether mod loader threw an exception before.");
        }
        return sInstance;
    }

    @UiThread
    private void run() {
        try {
            this.init();
        }
        catch (Throwable e) {
            ModernUI.LOGGER.fatal(MARKER, "UI manager failed to initialize", e);
            return;
        }
        while (this.mRunning) {
            try {
                Looper.loop();
                break;
            }
            catch (Throwable e) {
                ModernUI.LOGGER.error(MARKER, "An error occurred on UI thread", e);
                if (this.mRunning && ModernUIMod.isDeveloperMode()) continue;
                this.minecraft.method_18858(this::dump);
                this.minecraft.method_18858(() -> class_310.method_1565((class_128)class_128.method_560((Throwable)e, (String)"Exception on UI thread")));
                break;
            }
        }
        this.mRoot.mSurface = RefCnt.move(this.mRoot.mSurface);
        Core.requireUiRecordingContext().unref();
        ModernUI.LOGGER.debug(MARKER, "Quited UI thread");
    }

    @MainThread
    protected abstract void open(@Nonnull Fragment var1);

    @MainThread
    void onBackPressed() {
        MuiScreen screen = this.mScreen;
        if (screen == null) {
            return;
        }
        if (screen.getCallback() != null && !screen.getCallback().shouldClose()) {
            return;
        }
        if (screen.isMenuScreen()) {
            if (this.minecraft.field_1724 != null) {
                this.minecraft.field_1724.method_7346();
            }
        } else {
            this.minecraft.method_1507(screen.getPreviousScreen());
        }
    }

    static long getElapsedTime() {
        if (sInstance == null) {
            return Core.timeMillis();
        }
        return UIManager.sInstance.mElapsedTimeMillis;
    }

    static long getFrameTimeNanos() {
        if (sInstance == null) {
            return Core.timeNanos();
        }
        return UIManager.sInstance.mFrameTimeNanos;
    }

    public WindowGroup getDecorView() {
        return this.mDecor;
    }

    public FragmentController getFragmentController() {
        return this.mFragmentController;
    }

    public void setShowingLayoutBounds(boolean debugLayout) {
        this.mDebugLayout = debugLayout;
        this.mRoot.loadSystemProperties(() -> this.mDebugLayout);
    }

    public boolean isShowingLayoutBounds() {
        return this.mDebugLayout;
    }

    public OnBackPressedDispatcher getOnBackPressedDispatcher() {
        return this.mOnBackPressedDispatcher;
    }

    @Override
    @Nonnull
    public Lifecycle getLifecycle() {
        return this.mFragmentLifecycleRegistry;
    }

    @MainThread
    public void initScreen(@Nonnull MuiScreen screen) {
        if (this.mScreen != screen) {
            if (this.mScreen != null) {
                ModernUI.LOGGER.warn(MARKER, "You cannot set multiple screens.");
                return;
            }
            this.mRoot.mHandler.post(this::suppressLayoutTransition);
            this.mFragmentController.getFragmentManager().beginTransaction().add(16908295, screen.getFragment(), "main").setTransition(4097).setReorderingAllowed(true).commit();
            this.mRoot.mHandler.post(this::restoreLayoutTransition);
        }
        this.mScreen = screen;
        this.resize(this.minecraft.method_22683().method_4489(), this.minecraft.method_22683().method_4506());
    }

    @UiThread
    void suppressLayoutTransition() {
        LayoutTransition transition = this.mDecor.getLayoutTransition();
        transition.disableTransitionType(2);
        transition.disableTransitionType(3);
    }

    @UiThread
    void restoreLayoutTransition() {
        LayoutTransition transition = this.mDecor.getLayoutTransition();
        transition.enableTransitionType(2);
        transition.enableTransitionType(3);
    }

    protected void onScreenChange(@Nullable class_437 oldScreen, @Nullable class_437 newScreen) {
        BlurHandler.INSTANCE.blur(newScreen);
    }

    @UiThread
    private void init() {
        long startTime = System.nanoTime();
        this.mLooper = Core.initUiThread();
        this.mRoot = new ViewRootImpl();
        this.mDecor = new WindowGroup(ModernUI.getInstance());
        this.mDecor.setWillNotDraw(true);
        this.mDecor.setId(0x1020002);
        this.updateLayoutDir(false);
        this.mFragmentContainerView = new FragmentContainerView(ModernUI.getInstance());
        this.mFragmentContainerView.setLayoutParams(new WindowManager.LayoutParams());
        this.mFragmentContainerView.setWillNotDraw(true);
        this.mFragmentContainerView.setId(16908295);
        this.mDecor.addView(this.mFragmentContainerView);
        this.mDecor.setLayoutTransition(new LayoutTransition());
        this.mRoot.setView(this.mDecor);
        this.resize(this.minecraft.method_22683().method_4489(), this.minecraft.method_22683().method_4506());
        this.mDecor.getViewTreeObserver().addOnScrollChangedListener(() -> this.onHoverMove(false));
        this.mFragmentLifecycleRegistry = new LifecycleRegistry(this);
        this.mViewModelStore = new ViewModelStore();
        this.mFragmentController = FragmentController.createController(new HostCallbacks());
        this.mFragmentController.attachHost(null);
        this.mFragmentLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
        this.mFragmentController.dispatchCreate();
        this.mFragmentController.dispatchActivityCreated();
        this.mFragmentController.execPendingActions();
        this.mFragmentLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_START);
        this.mFragmentController.dispatchStart();
        this.mFragmentLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
        this.mFragmentController.dispatchResume();
        ModernUI.LOGGER.info(MARKER, "UI thread initialized in {}ms", (Object)((System.nanoTime() - startTime) / 1000000L));
    }

    @UiThread
    private void finish() {
        ModernUI.LOGGER.debug(MARKER, "Quiting UI thread");
        this.mFragmentController.dispatchStop();
        this.mFragmentLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_STOP);
        this.mFragmentController.dispatchDestroy();
        this.mFragmentLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
        this.mRoot.mHandler.postDelayed(this.mLooper::quitSafely, 60L);
    }

    @MainThread
    public void onHoverMove(boolean natural) {
        long now = Core.timeNanos();
        float x = (float)(this.minecraft.field_1729.method_1603() * (double)this.mWindow.method_4489() / (double)this.mWindow.method_4480());
        float y = (float)(this.minecraft.field_1729.method_1604() * (double)this.mWindow.method_4506() / (double)this.mWindow.method_4507());
        MotionEvent event = MotionEvent.obtain(now, 7, x, y, 0);
        this.mRoot.enqueueInputEvent(event);
        if (natural && this.mButtonState > 0) {
            event = MotionEvent.obtain(now, 2, 0, x, y, 0, this.mButtonState, 0);
            this.mRoot.enqueueInputEvent(event);
        }
    }

    private void onScroll(double scrollX, double scrollY) {
        if (this.mScreen != null) {
            long now = Core.timeNanos();
            class_1041 window = this.mWindow;
            class_312 mouseHandler = this.minecraft.field_1729;
            float x = (float)(mouseHandler.method_1603() * (double)window.method_4489() / (double)window.method_4480());
            float y = (float)(mouseHandler.method_1604() * (double)window.method_4506() / (double)window.method_4507());
            int mods = 0;
            if (class_437.method_25441()) {
                mods |= KeyEvent.META_CTRL_ON;
            }
            if (class_437.method_25442()) {
                mods |= 1;
            }
            MotionEvent event = MotionEvent.obtain(now, 8, x, y, mods);
            event.setAxisValue(10, (float)scrollX);
            event.setAxisValue(9, (float)scrollY);
            this.mRoot.enqueueInputEvent(event);
        }
    }

    public void onPostMouseInput(int button, int action, int mods) {
        if (this.minecraft.method_18506() == null && this.mScreen != null) {
            long now = Core.timeNanos();
            float x = (float)(this.minecraft.field_1729.method_1603() * (double)this.mWindow.method_4489() / (double)this.mWindow.method_4480());
            float y = (float)(this.minecraft.field_1729.method_1604() * (double)this.mWindow.method_4506() / (double)this.mWindow.method_4507());
            int buttonState = 0;
            for (int i = 0; i < 5; ++i) {
                if (GLFW.glfwGetMouseButton((long)this.mWindow.method_4490(), (int)i) != 1) continue;
                buttonState |= 1 << i;
            }
            this.mButtonState = buttonState;
            int hoverAction = action == 1 ? 11 : 12;
            int touchAction = action == 1 ? 0 : 1;
            int actionButton = 1 << button;
            MotionEvent ev = MotionEvent.obtain(now, hoverAction, actionButton, x, y, mods, buttonState, 0);
            this.mRoot.enqueueInputEvent(ev);
            if (touchAction == 0 && (buttonState ^ actionButton) == 0 || touchAction == 1 && buttonState == 0) {
                ev = MotionEvent.obtain(now, touchAction, actionButton, x, y, mods, buttonState, 0);
                this.mRoot.enqueueInputEvent(ev);
            }
        }
    }

    public void onKeyPress(int keyCode, int scanCode, int mods) {
        KeyEvent keyEvent = KeyEvent.obtain(Core.timeNanos(), 0, keyCode, 0, mods, scanCode, 0);
        this.mRoot.enqueueInputEvent(keyEvent);
    }

    public void onKeyRelease(int keyCode, int scanCode, int mods) {
        KeyEvent keyEvent = KeyEvent.obtain(Core.timeNanos(), 1, keyCode, 0, mods, scanCode, 0);
        this.mRoot.enqueueInputEvent(keyEvent);
    }

    protected void onPreKeyInput(int keyCode, int scanCode, int action, int mods) {
        if (TooltipRenderer.sTooltip && mods == 0 && action != 0) {
            switch (keyCode) {
                case 265: {
                    this.mTooltipRenderer.updateArrowMovement(-1);
                    break;
                }
                case 264: {
                    this.mTooltipRenderer.updateArrowMovement(1);
                }
            }
        }
        if (!(class_437.method_25441() && class_437.method_25442() && ModernUIMod.isDeveloperMode())) {
            return;
        }
        if (action == 1) {
            switch (keyCode) {
                case 89: {
                    this.takeScreenshot();
                    break;
                }
                case 85: {
                    this.mClearNextMainTarget = true;
                    break;
                }
                case 78: {
                    this.mDecor.postInvalidate();
                    break;
                }
                case 80: {
                    this.dump();
                    break;
                }
                case 77: {
                    this.changeRadialBlur();
                    break;
                }
                case 84: {
                    if (!ModernUIMod.isTextEngineEnabled()) break;
                    TextLayoutEngine.getInstance().dumpLayoutCache();
                    break;
                }
                case 71: {
                    GlyphManager.getInstance().debug();
                    break;
                }
                case 86: {
                    if (!ModernUIMod.isTextEngineEnabled()) break;
                    TextLayoutEngine.getInstance().dumpBitmapFonts();
                    break;
                }
                case 79: {
                    this.mNoRender = !this.mNoRender;
                    break;
                }
                case 70: {
                    System.gc();
                }
            }
        }
    }

    public void onGameLoadFinished() {
        if (sDingEnabled) {
            GLFW.glfwRequestWindowAttention((long)this.minecraft.method_22683().method_4490());
            this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14627, (float)1.0f));
        }
        if (ModernUIMod.isOptiFineLoaded() && ModernUIMod.isTextEngineEnabled()) {
            OptiFineIntegration.setFastRender(false);
            ModernUI.LOGGER.info(MARKER, "Disabled OptiFine Fast Render");
        }
    }

    public void takeScreenshot() {
        GLTexture layer;
        @SharedPtr Surface surface = this.mRoot.getSurface();
        if (surface == null) {
            return;
        }
        try {
            @RawPtr GraniteDevice device = (GraniteDevice)SURFACE_DEVICE.get(surface);
            layer = (GLTexture)device.getReadView().getImage();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        int width = layer.getWidth();
        int height = layer.getHeight();
        Bitmap bitmap = Bitmap.createBitmap(width, height, Bitmap.Format.RGBA_8888);
        bitmap.setPremultiplied(true);
        GL33C.glPixelStorei((int)3330, (int)0);
        GL33C.glPixelStorei((int)3331, (int)0);
        GL33C.glPixelStorei((int)3332, (int)0);
        GL33C.glPixelStorei((int)3333, (int)1);
        GL33C.glBindBuffer((int)35051, (int)0);
        int boundTexture = GL33C.glGetInteger((int)32873);
        GL33C.glBindTexture((int)3553, (int)layer.getHandle());
        GL33C.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (long)bitmap.getAddress());
        GL33C.glBindTexture((int)3553, (int)boundTexture);
        surface.unref();
        class_156.method_27958().execute(() -> {
            @SharedPtr Bitmap converted = Bitmap.createBitmap(bitmap.getWidth(), bitmap.getHeight(), Bitmap.Format.RGBA_8888);
            converted.setPremultiplied(false);
            try (Bitmap bitmap2 = bitmap;){
                PixelUtils.convertPixels(bitmap.getPixmap(), converted.getPixmap(), true);
            }
            try {
                bitmap2 = converted;
                try {
                    converted.saveDialog(Bitmap.SaveFormat.PNG, 0, null);
                }
                finally {
                    if (bitmap2 != null) {
                        bitmap2.close();
                    }
                }
            }
            catch (IOException e) {
                ModernUI.LOGGER.warn(MARKER, "Failed to save UI screenshot", (Throwable)e);
            }
        });
    }

    protected void changeRadialBlur() {
        if (this.minecraft.field_1773.method_3183() == null) {
            ModernUI.LOGGER.info(MARKER, "Load post-processing effect");
            class_2960 effect = class_3675.method_15987((long)this.mWindow.method_4490(), (int)344) ? new class_2960("shaders/post/grayscale.json") : new class_2960("shaders/post/radial_blur.json");
            MuiModApi.get().loadEffect(this.minecraft.field_1773, effect);
        } else {
            ModernUI.LOGGER.info(MARKER, "Stop post-processing effect");
            this.minecraft.field_1773.method_3207();
        }
    }

    public void dump() {
        StringBuilder builder = new StringBuilder();
        try (PrintWriter w = new PrintWriter((Writer)new StringBuilderWriter(builder));){
            this.dump(w, true);
        }
        String str = builder.toString();
        if (this.minecraft.field_1687 != null) {
            this.minecraft.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)str).method_27692(class_124.field_1080));
        }
        ModernUI.LOGGER.info(MARKER, str);
    }

    public void dump(@Nonnull PrintWriter pw, boolean fragments) {
        pw.println(">>> Modern UI dump data <<<");
        pw.print("Container Menu: ");
        class_746 player = this.minecraft.field_1724;
        class_1703 menu = null;
        if (player != null) {
            menu = player.field_7512;
        }
        if (menu != null) {
            pw.println(menu.getClass().getSimpleName());
            try {
                class_2960 name = class_7923.field_41187.method_10221((Object)menu.method_17358());
                pw.print("  Registry Name: ");
                pw.println(name);
            }
            catch (Exception name) {}
        } else {
            pw.println((Object)null);
        }
        class_437 screen = this.minecraft.field_1755;
        if (screen != null) {
            pw.print("Screen: ");
            pw.println(screen.getClass());
        }
        if (fragments && this.mFragmentController != null) {
            this.mFragmentController.getFragmentManager().dump("", null, pw, new String[0]);
        }
        int coreN = LayoutCache.getSize();
        int coreMem = LayoutCache.getMemoryUsage();
        pw.printf("LayoutCore: Count=%d, Size=%s (%d bytes)\n", coreN, TextUtils.binaryCompact(coreMem), coreMem);
        GlyphManager.getInstance().dumpInfo(pw);
        MuiModApi.dispatchOnDebugDump(pw);
    }

    @MainThread
    public boolean onCharTyped(char ch) {
        if (ch == '\u0000' || ch == '\u007f') {
            return false;
        }
        this.mCharInputBuffer.append(ch);
        Core.postOnMainThread(this.mCommitCharInput);
        return true;
    }

    private void commitCharInput() {
        if (this.mCharInputBuffer.isEmpty()) {
            return;
        }
        String input = this.mCharInputBuffer.toString();
        this.mCharInputBuffer.setLength(0);
        Message msg = Message.obtain(this.mRoot.mHandler, () -> {
            View patt31872$temp = this.mDecor.findFocus();
            if (patt31872$temp instanceof EditText) {
                EditText text = (EditText)patt31872$temp;
                Editable content = text.getText();
                int selStart = text.getSelectionStart();
                int selEnd = text.getSelectionEnd();
                if (selStart >= 0 && selEnd >= 0) {
                    Selection.setSelection(content, Math.max(selStart, selEnd));
                    content.replace(Math.min(selStart, selEnd), Math.max(selStart, selEnd), input);
                }
            }
        });
        msg.setAsynchronous(true);
        msg.sendToTarget();
    }

    @RenderThread
    public void render(@Nullable class_332 gr, int mouseX, int mouseY, float deltaTick) {
        int i;
        if (this.mNoRender) {
            return;
        }
        int oldVertexArray = 0;
        int oldProgram = 0;
        @RawPtr ImmediateContext context = Core.requireImmediateContext();
        Pair<RootTask, Surface> frameTask = this.mRoot.swapFrameTask();
        @SharedPtr RootTask rootTask = frameTask.getLeft();
        @SharedPtr Surface surface = frameTask.getRight();
        if (rootTask != null) {
            oldVertexArray = GL33C.glGetInteger((int)34229);
            oldProgram = GL33C.glGetInteger((int)35725);
            boolean added = context.addTask(rootTask);
            rootTask.unref();
            if (!added) {
                ModernUI.LOGGER.error("Failed to add draw commands");
            }
        }
        ((GLDevice)context.getDevice()).flushRenderCalls();
        if (rootTask != null) {
            context.submit();
            GL33C.glBindFramebuffer((int)36160, (int)this.minecraft.method_1522().field_1476);
            GL33C.glBindVertexArray((int)oldVertexArray);
            GL33C.glUseProgram((int)oldProgram);
        } else {
            context.checkForFinishedWork();
        }
        class_286.method_43436();
        for (i = 0; i <= 3; ++i) {
            GL33C.glBindSampler((int)i, (int)0);
        }
        GL33C.glDisable((int)2960);
        RenderSystem.disableScissor();
        GL33C.glDisable((int)3089);
        RenderSystem.defaultBlendFunc();
        GL33C.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.enableBlend();
        GL33C.glEnable((int)3042);
        RenderSystem.blendEquation((int)32774);
        GL33C.glBlendEquation((int)32774);
        RenderSystem.disableDepthTest();
        GL33C.glDisable((int)2929);
        RenderSystem.depthFunc((int)515);
        GL33C.glDepthFunc((int)515);
        RenderSystem.depthMask((boolean)true);
        GL33C.glDepthMask((boolean)true);
        for (i = 3; i >= 0; --i) {
            RenderSystem.activeTexture((int)(33984 + i));
            RenderSystem.bindTexture((int)0);
        }
        GL33C.glActiveTexture((int)33984);
        RenderSystem.disableCull();
        RenderSystem.lineWidth((float)1.0f);
        int width = this.minecraft.method_22683().method_4489();
        int height = this.minecraft.method_22683().method_4506();
        RenderSystem.viewport((int)0, (int)0, (int)width, (int)height);
        if (surface != null) {
            GLTexture layer;
            try {
                @RawPtr GraniteDevice device = (GraniteDevice)SURFACE_DEVICE.get(surface);
                layer = (GLTexture)device.getReadView().getImage();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (layer != null) {
                class_5944 blitShader = this.minecraft.field_1773.field_29403;
                blitShader.method_34583("DiffuseSampler", (Object)layer.getHandle());
                @SharedPtr GLSampler sampler = (GLSampler)context.getResourceProvider().findOrCreateCompatibleSampler(SamplerDesc.NEAREST);
                if (sampler != null) {
                    GL33C.glBindSampler((int)0, (int)sampler.getHandle());
                }
                Matrix4f projection = new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, 3000.0f);
                if (blitShader.field_29470 != null) {
                    blitShader.field_29470.method_1250(new Matrix4f().translation(0.0f, 0.0f, -2000.0f));
                }
                if (blitShader.field_29471 != null) {
                    blitShader.field_29471.method_1250(projection);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (blitShader.field_29474 != null) {
                    blitShader.field_29474.method_1253(RenderSystem.getShaderColor());
                }
                blitShader.method_34586();
                RenderSystem.blendFuncSeparate((int)1, (int)771, (int)1, (int)771);
                class_287 bufferBuilder = class_289.method_1348().method_1349();
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                bufferBuilder.method_22912(0.0, (double)height, 0.0).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
                bufferBuilder.method_22912((double)width, (double)height, 0.0).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
                bufferBuilder.method_22912((double)width, 0.0, 0.0).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, 255).method_1344();
                bufferBuilder.method_22912(0.0, 0.0, 0.0).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, 255).method_1344();
                class_286.method_43437((class_287.class_7433)bufferBuilder.method_1326());
                blitShader.method_34585();
                if (sampler != null) {
                    GL33C.glBindSampler((int)0, (int)0);
                    sampler.unref();
                }
            }
        }
        RenderSystem.defaultBlendFunc();
        RefCnt.move(surface);
        if (gr != null) {
            for (MinecraftDrawHandler handler : this.mRoot.mRawDrawHandlers) {
                handler.render(gr, mouseX, mouseY, deltaTick, this.mWindow);
            }
        }
    }

    @MainThread
    void resize(int width, int height) {
        if (this.mRoot != null) {
            this.mRoot.mHandler.post(() -> this.mRoot.setFrame(width, height));
        }
    }

    @UiThread
    public void updateLayoutDir(boolean forceRTL) {
        if (this.mDecor == null) {
            return;
        }
        boolean layoutRtl = forceRTL || TextUtils.getLayoutDirectionFromLocale(ModernUI.getSelectedLocale()) == 1;
        this.mDecor.setLayoutDirection(layoutRtl ? 1 : 3);
        this.mDecor.requestLayout();
        this.mTooltipRenderer.mLayoutRTL = layoutRtl;
    }

    @MainThread
    public void removed(@Nonnull class_437 target) {
        MuiScreen screen = this.mScreen;
        if (target != screen) {
            ModernUI.LOGGER.warn(MARKER, "No screen to remove, try to remove {}, but have {}", (Object)target, (Object)screen);
            return;
        }
        this.mRoot.mHandler.post(this::suppressLayoutTransition);
        this.mFragmentController.getFragmentManager().beginTransaction().remove(screen.getFragment()).setReorderingAllowed(true).commit();
        this.mRoot.mHandler.post(this::restoreLayoutTransition);
        this.mRoot.mRawDrawHandlers.clear();
        this.mScreen = null;
        GLFW.glfwSetCursor((long)this.mWindow.method_4490(), (long)0L);
    }

    public void drawExtTooltip(class_1799 itemStack, class_332 graphics, List<class_5684> components, int x, int y, class_327 font, int screenWidth, int screenHeight, class_8000 positioner) {
        float partialY;
        float partialX;
        class_1041 window = this.mWindow;
        class_312 mouseHandler = this.minecraft.field_1729;
        double cursorX = mouseHandler.method_1603() * (double)window.method_4486() / (double)window.method_4480();
        double cursorY = mouseHandler.method_1604() * (double)window.method_4502() / (double)window.method_4507();
        int mouseX = (int)cursorX;
        int mouseY = (int)cursorY;
        if (TooltipRenderer.sExactPositioning && positioner instanceof class_8001) {
            positioner = null;
        }
        if (x == mouseX && y == mouseY && positioner == null && UIManager.isIdentity(graphics.method_51448().method_23760().method_23761())) {
            partialX = (float)(cursorX - (double)mouseX);
            partialY = (float)(cursorY - (double)mouseY);
        } else {
            partialX = 0.0f;
            partialY = 0.0f;
        }
        this.mTooltipRenderer.drawTooltip(itemStack, graphics, components, x, y, font, screenWidth, screenHeight, partialX, partialY, positioner);
    }

    private static boolean isIdentity(Matrix4f ctm) {
        if ((ctm.properties() & 4) != 0) {
            return true;
        }
        return MathUtil.isApproxEqual(ctm.m00(), 1.0f) && MathUtil.isApproxZero(ctm.m01()) && MathUtil.isApproxZero(ctm.m02()) && MathUtil.isApproxZero(ctm.m03()) && MathUtil.isApproxZero(ctm.m10()) && MathUtil.isApproxEqual(ctm.m11(), 1.0f) && MathUtil.isApproxZero(ctm.m12()) && MathUtil.isApproxZero(ctm.m13()) && MathUtil.isApproxZero(ctm.m20()) && MathUtil.isApproxZero(ctm.m21()) && MathUtil.isApproxEqual(ctm.m22(), 1.0f) && MathUtil.isApproxZero(ctm.m23()) && MathUtil.isApproxZero(ctm.m30()) && MathUtil.isApproxZero(ctm.m31()) && MathUtil.isApproxEqual(ctm.m33(), 1.0f);
    }

    protected void onRenderTick(boolean isEnd) {
        if (!isEnd) {
            long lastFrameTime = this.mFrameTimeNanos;
            this.mFrameTimeNanos = Core.timeNanos();
            long deltaMillis = (this.mFrameTimeNanos - lastFrameTime) / 1000000L;
            this.mElapsedTimeMillis += deltaMillis;
            if (this.mRunning) {
                BlurHandler.INSTANCE.onRenderTick(this.mElapsedTimeMillis);
                if (TooltipRenderer.sTooltip) {
                    this.mTooltipRenderer.update(deltaMillis, this.mFrameTimeNanos / 1000000L);
                }
            }
        } else {
            ImmediateContext context = Core.requireImmediateContext();
            if (this.mFrameTimeNanos - this.mLastPurgeNanos >= 20000000000L) {
                this.mLastPurgeNanos = this.mFrameTimeNanos;
                context.performDeferredCleanup(120000L);
                GlyphManager.getInstance().compact();
            }
            if (!this.minecraft.method_22108() && this.mRunning) {
                this.mRunning = false;
                this.mRoot.mHandler.post(this::finish);
            } else if (this.minecraft.method_22108() && this.mRunning && this.mScreen == null && this.minecraft.method_18506() == null) {
                this.render(null, 0, 0, 0.0f);
            }
        }
    }

    protected void onClientTick(boolean isEnd) {
        if (isEnd) {
            BlurHandler.INSTANCE.onClientTick();
        }
    }

    public static void destroy() {
        ModernUI.LOGGER.debug(MARKER, "Quiting Modern UI");
        BlurHandler.INSTANCE.closeEffect();
        FontResourceManager.getInstance().close();
        ImageStore.getInstance().clear();
        System.gc();
        Core.requireImmediateContext().unref();
        if (sInstance != null) {
            AudioManager.getInstance().close();
            try {
                UIManager.sInstance.mUiThread.join(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        ModernUI.LOGGER.debug(MARKER, "Quited Modern UI");
    }

    static {
        try {
            SURFACE_DEVICE = GraniteSurface.class.getDeclaredField("mDevice");
            SURFACE_DEVICE.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @UiThread
    protected class ViewRootImpl
    extends ViewRoot {
        private final Rect mGlobalRect = new Rect();
        ContextMenuBuilder mContextMenu;
        MenuHelper mContextMenuHelper;
        Surface mSurface;
        RootTask mLastFrameTask;
        private long mLastPurgeNanos;
        ArrayList<MinecraftDrawHandler.Operation> mPendingRawDrawHandlerOperations = new ArrayList();
        ArrayList<MinecraftDrawHandler> mRawDrawHandlers = new ArrayList();

        protected ViewRootImpl() {
        }

        @Override
        protected boolean dispatchTouchEvent(MotionEvent event) {
            View v;
            if (UIManager.this.mScreen != null && event.getAction() == 0 && (v = UIManager.this.mDecor.findFocus()) instanceof EditText) {
                v.getGlobalVisibleRect(this.mGlobalRect);
                if (!this.mGlobalRect.contains((int)event.getRawX(), (int)event.getRawY())) {
                    v.clearFocus();
                }
            }
            return super.dispatchTouchEvent(event);
        }

        @Override
        protected void onKeyEvent(KeyEvent event) {
            MuiScreen screen = UIManager.this.mScreen;
            if (screen != null && event.getAction() == 0) {
                boolean back;
                if (screen.getCallback() != null) {
                    back = screen.getCallback().isBackKey(event.getKeyCode(), event);
                } else if (screen.isMenuScreen()) {
                    if (event.getKeyCode() == 256) {
                        back = true;
                    } else {
                        class_3675.class_306 key = class_3675.method_15985((int)event.getKeyCode(), (int)event.getScanCode());
                        back = MuiModApi.get().isKeyBindingMatches(UIManager.this.minecraft.field_1690.field_1822, key);
                    }
                } else {
                    boolean bl = back = event.getKeyCode() == 256;
                }
                if (back) {
                    View v = UIManager.this.mDecor.findFocus();
                    if (v instanceof EditText) {
                        if (event.getKeyCode() == 256) {
                            v.clearFocus();
                        }
                    } else {
                        UIManager.this.mOnBackPressedDispatcher.onBackPressed();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Canvas beginDrawLocked(int width, int height) {
            Object object = this.mRenderLock;
            synchronized (object) {
                if ((this.mSurface == null || this.mSurface.getWidth() != width || this.mSurface.getHeight() != height) && width > 0 && height > 0) {
                    this.mSurface = RefCnt.move(this.mSurface, GraniteSurface.makeRenderTarget(Core.requireUiRecordingContext(), ImageInfo.make(width, height, 6, 2, ColorSpace.get(ColorSpace.Named.SRGB)), false, 1, null));
                }
                if (this.mSurface != null && width > 0 && height > 0) {
                    this.mSurface.getCanvas().clear(0);
                    return new ArcCanvas(this.mSurface.getCanvas());
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void endDrawLocked(@Nonnull Canvas canvas) {
            canvas.restoreToCount(1);
            RootTask task = Core.requireUiRecordingContext().snap();
            Object object = this.mRenderLock;
            synchronized (object) {
                this.mLastFrameTask = RefCnt.move(this.mLastFrameTask, task);
                try {
                    this.mRenderLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.mLastFrameTask = RefCnt.move(this.mLastFrameTask);
            }
            RecordingContext context = Core.requireUiRecordingContext();
            if (System.nanoTime() - this.mLastPurgeNanos >= 20000000000L) {
                this.mLastPurgeNanos = System.nanoTime();
                context.performDeferredCleanup(120000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SharedPtr
        private Surface getSurface() {
            Object object = this.mRenderLock;
            synchronized (object) {
                return RefCnt.create(this.mSurface);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addRawDrawHandlerOperation(MinecraftDrawHandler.Operation op) {
            Object object = this.mRenderLock;
            synchronized (object) {
                this.mPendingRawDrawHandlerOperations.add(op);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RenderThread
        private Pair<@SharedPtr RootTask, @SharedPtr Surface> swapFrameTask() {
            RootTask task;
            Surface surface;
            Object object = this.mRenderLock;
            synchronized (object) {
                surface = RefCnt.create(this.mSurface);
                task = this.mLastFrameTask;
                this.mLastFrameTask = null;
                block8: for (int i = 0; i < this.mPendingRawDrawHandlerOperations.size(); ++i) {
                    MinecraftDrawHandler.Operation operation = this.mPendingRawDrawHandlerOperations.get(i);
                    switch (operation.mOp) {
                        case 0: {
                            this.mRawDrawHandlers.add(operation.mTarget);
                            continue block8;
                        }
                        case 1: {
                            this.mRawDrawHandlers.remove(operation.mTarget);
                            continue block8;
                        }
                        case 2: {
                            operation.mTarget.syncProperties();
                        }
                    }
                }
                this.mPendingRawDrawHandlerOperations.clear();
                this.mRenderLock.notifyAll();
            }
            return Pair.of(task, surface);
        }

        @Override
        public void playSoundEffect(int effectId) {
        }

        @Override
        public boolean performHapticFeedback(int effectId, boolean always) {
            return false;
        }

        @Override
        @MainThread
        protected void applyPointerIcon(int pointerType) {
            UIManager.this.minecraft.method_18858(() -> GLFW.glfwSetCursor((long)UIManager.this.mWindow.method_4490(), (long)PointerIcon.getSystemIcon(pointerType).getHandle()));
        }

        @Override
        public boolean showContextMenuForChild(View originalView, float x, float y) {
            if (this.mContextMenuHelper != null) {
                this.mContextMenuHelper.dismiss();
                this.mContextMenuHelper = null;
            }
            if (this.mContextMenu == null) {
                this.mContextMenu = new ContextMenuBuilder(ModernUI.getInstance());
            } else {
                this.mContextMenu.clearAll();
            }
            boolean isPopup = !Float.isNaN(x) && !Float.isNaN(y);
            MenuPopupHelper helper = isPopup ? this.mContextMenu.showPopup(ModernUI.getInstance(), originalView, x, y) : this.mContextMenu.showPopup(ModernUI.getInstance(), originalView, 0.0f, 0.0f);
            this.mContextMenuHelper = helper;
            return helper != null;
        }
    }

    @UiThread
    protected class HostCallbacks
    extends FragmentHostCallback<Object>
    implements ViewModelStoreOwner,
    OnBackPressedDispatcherOwner {
        HostCallbacks() {
            super(ModernUI.getInstance(), new Handler(Looper.myLooper()));
            assert (Core.isOnUiThread());
        }

        @Override
        @Nullable
        public Object onGetHost() {
            return null;
        }

        @Override
        @Nullable
        public View onFindViewById(int id2) {
            return UIManager.this.mDecor.findViewById(id2);
        }

        @Override
        @Nonnull
        public ViewModelStore getViewModelStore() {
            return UIManager.this.mViewModelStore;
        }

        @Override
        @Nonnull
        public OnBackPressedDispatcher getOnBackPressedDispatcher() {
            return UIManager.this.mOnBackPressedDispatcher;
        }

        @Override
        @Nonnull
        public Lifecycle getLifecycle() {
            return UIManager.this.mFragmentLifecycleRegistry;
        }
    }
}

