/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import icyllis.modernui.ModernUI;
import icyllis.modernui.annotation.MainThread;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.core.Core;
import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.graphics.MathUtil;
import icyllis.modernui.graphics.text.GraphemeBreak;
import icyllis.modernui.mc.MuiScreen;
import icyllis.modernui.mc.ScreenCallback;
import icyllis.modernui.mc.UIManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_757;

public abstract class MuiModApi {
    static final CopyOnWriteArrayList<OnScrollListener> sOnScrollListeners = new CopyOnWriteArrayList();
    static final CopyOnWriteArrayList<OnScreenChangeListener> sOnScreenChangeListeners = new CopyOnWriteArrayList();
    static final CopyOnWriteArrayList<OnWindowResizeListener> sOnWindowResizeListeners = new CopyOnWriteArrayList();
    static final CopyOnWriteArrayList<OnDebugDumpListener> sOnDebugDumpListeners = new CopyOnWriteArrayList();
    static final CopyOnWriteArrayList<OnPreKeyInputListener> sOnPreKeyInputListeners = new CopyOnWriteArrayList();
    static final MuiModApi INSTANCE = ServiceLoader.load(MuiModApi.class).findFirst().orElseThrow();
    public static final int MAX_GUI_SCALE = 8;
    public static final Pattern EMOJI_SHORTCODE_PATTERN = Pattern.compile("(:(\\w|\\+|-)+:)(?=|[!.?]|$)");
    private static final class_124[] FORMATTING_TABLE = new class_124[128];

    public static MuiModApi get() {
        return INSTANCE;
    }

    @MainThread
    public static void openScreen(@Nonnull Fragment fragment) {
        UIManager.getInstance().open(fragment);
    }

    @Nonnull
    public final <T extends class_437> T createScreen(@Nonnull Fragment fragment) {
        return this.createScreen(fragment, null, null, null);
    }

    @Nonnull
    public final <T extends class_437> T createScreen(@Nonnull Fragment fragment, @Nullable ScreenCallback callback) {
        return this.createScreen(fragment, callback, null, null);
    }

    @Nonnull
    public final <T extends class_437> T createScreen(@Nonnull Fragment fragment, @Nullable ScreenCallback callback, @Nullable class_437 previousScreen) {
        return this.createScreen(fragment, callback, previousScreen, null);
    }

    @Nonnull
    public abstract <T extends class_437> T createScreen(@Nonnull Fragment var1, @Nullable ScreenCallback var2, @Nullable class_437 var3, @Nullable CharSequence var4);

    @Nonnull
    public abstract <T extends class_1703, U extends class_437 & MuiScreen> U createMenuScreen(@Nonnull Fragment var1, @Nullable ScreenCallback var2, @Nonnull T var3, @Nonnull class_1661 var4, @Nonnull class_2561 var5);

    @RenderThread
    public static long getElapsedTime() {
        return UIManager.getElapsedTime();
    }

    @RenderThread
    public static long getFrameTime() {
        return MuiModApi.getFrameTimeNanos() / 1000000L;
    }

    @RenderThread
    public static long getFrameTimeNanos() {
        return UIManager.getFrameTimeNanos();
    }

    public static void postToUiThread(@Nonnull Runnable r) {
        Core.getUiHandlerAsync().post(r);
    }

    public static int calcGuiScales() {
        return MuiModApi.calcGuiScales(class_310.method_1551().method_22683());
    }

    public static int calcGuiScales(@Nonnull class_1041 window) {
        return MuiModApi.calcGuiScales(window.method_4489(), window.method_4506());
    }

    public static int calcGuiScales(int framebufferWidth, int framebufferHeight) {
        int auto;
        double w = (double)framebufferWidth / 16.0;
        double h = (double)framebufferHeight / 9.0;
        double base = Math.min(w, h);
        int det = (int)(Math.min((double)framebufferWidth, h * 12.0) / 320.0);
        int min = det >= 2 ? MathUtil.clamp((int)(base / 64.0), 2, 8) : 2;
        int max = MathUtil.clamp(det, 2, 8);
        if (min >= 2) {
            double step = base > 216.0 ? 42.0 : (base > 120.0 ? 36.0 : 30.0);
            int i = (int)(base / step);
            int j = (int)(Math.max(w, h) / step);
            double v1 = base / ((double)i * 30.0);
            auto = v1 > 1.4 || j > i ? MathUtil.clamp(i + 1, min, max) : MathUtil.clamp(i, min, max);
        } else {
            auto = 2;
        }
        assert (min <= auto && auto <= max);
        return min << 8 | auto << 4 | max;
    }

    public static int offsetByGrapheme(String value, int cursor, int dir) {
        int op = dir < 0 ? 2 : (dir == 0 ? 3 : 0);
        int offset = class_156.method_27761((String)value, (int)cursor, (int)dir);
        cursor = GraphemeBreak.getTextRunCursor(value, ModernUI.getSelectedLocale(), 0, value.length(), cursor, op);
        if (dir > 0) {
            return Math.max(offset, cursor);
        }
        return Math.min(offset, cursor);
    }

    @Nullable
    public static class_124 getFormattingByCode(char code) {
        return code < '\u0080' ? FORMATTING_TABLE[code] : null;
    }

    public abstract boolean isGLVersionPromoted();

    public abstract void loadEffect(class_757 var1, class_2960 var2);

    public abstract class_5944 makeShaderInstance(class_5912 var1, class_2960 var2, class_293 var3) throws IOException;

    public abstract boolean isKeyBindingMatches(class_304 var1, class_3675.class_306 var2);

    public abstract class_2583 applyRarityTo(class_1814 var1, class_2583 var2);

    public static void addOnScrollListener(@Nonnull OnScrollListener listener) {
        sOnScrollListeners.addIfAbsent(listener);
    }

    public static void removeOnScrollListener(@Nonnull OnScrollListener listener) {
        sOnScrollListeners.remove(listener);
    }

    public static void addOnScreenChangeListener(@Nonnull OnScreenChangeListener listener) {
        sOnScreenChangeListeners.addIfAbsent(listener);
    }

    public static void removeOnScreenChangeListener(@Nonnull OnScreenChangeListener listener) {
        sOnScreenChangeListeners.remove(listener);
    }

    public static void addOnWindowResizeListener(@Nonnull OnWindowResizeListener listener) {
        sOnWindowResizeListeners.addIfAbsent(listener);
    }

    public static void removeOnWindowResizeListener(@Nonnull OnWindowResizeListener listener) {
        sOnWindowResizeListeners.remove(listener);
    }

    public static void addOnDebugDumpListener(@Nonnull OnDebugDumpListener listener) {
        sOnDebugDumpListeners.addIfAbsent(listener);
    }

    public static void removeOnDebugDumpListener(@Nonnull OnDebugDumpListener listener) {
        sOnDebugDumpListeners.remove(listener);
    }

    public static void addOnPreKeyInputListener(@Nonnull OnPreKeyInputListener listener) {
        sOnPreKeyInputListeners.addIfAbsent(listener);
    }

    public static void removeOnPreKeyInputListener(@Nonnull OnPreKeyInputListener listener) {
        sOnPreKeyInputListeners.remove(listener);
    }

    public static void dispatchOnScroll(double scrollX, double scrollY) {
        for (OnScrollListener l : sOnScrollListeners) {
            l.onScroll(scrollX, scrollY);
        }
    }

    public static void dispatchOnScreenChange(@Nullable class_437 oldScreen, @Nullable class_437 newScreen) {
        for (OnScreenChangeListener l : sOnScreenChangeListeners) {
            l.onScreenChange(oldScreen, newScreen);
        }
    }

    public static void dispatchOnWindowResize(int width, int height, int guiScale, int oldGuiScale) {
        for (OnWindowResizeListener l : sOnWindowResizeListeners) {
            l.onWindowResize(width, height, guiScale, oldGuiScale);
        }
    }

    public static void dispatchOnDebugDump(@Nonnull PrintWriter writer) {
        for (OnDebugDumpListener l : sOnDebugDumpListeners) {
            l.onDebugDump(writer);
        }
    }

    public static void dispatchOnPreKeyInput(long window, int keyCode, int scanCode, int action, int mods) {
        for (OnPreKeyInputListener l : sOnPreKeyInputListeners) {
            l.onPreKeyInput(window, keyCode, scanCode, action, mods);
        }
    }

    static {
        class_124[] class_124Array = class_124.values();
        int n = class_124Array.length;
        for (int i = 0; i < n; ++i) {
            class_124 f;
            MuiModApi.FORMATTING_TABLE[f.method_36145()] = f = class_124Array[i];
            MuiModApi.FORMATTING_TABLE[Character.toUpperCase((char)f.method_36145())] = f;
        }
    }

    @FunctionalInterface
    public static interface OnScrollListener {
        public void onScroll(double var1, double var3);
    }

    @FunctionalInterface
    public static interface OnScreenChangeListener {
        public void onScreenChange(@Nullable class_437 var1, @Nullable class_437 var2);
    }

    @FunctionalInterface
    public static interface OnWindowResizeListener {
        public void onWindowResize(int var1, int var2, int var3, int var4);
    }

    @FunctionalInterface
    public static interface OnDebugDumpListener {
        public void onDebugDump(@Nonnull PrintWriter var1);
    }

    @FunctionalInterface
    public static interface OnPreKeyInputListener {
        public void onPreKeyInput(long var1, int var3, int var4, int var5, int var6);
    }
}

