/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.modernui.ModernUI;
import icyllis.modernui.animation.ColorEvaluator;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.MuiModApi;
import icyllis.modernui.mc.MuiScreen;
import icyllis.modernui.mc.ScreenCallback;
import icyllis.modernui.mc.mixin.AccessPostChain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1921;
import net.minecraft.class_279;
import net.minecraft.class_283;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_757;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

public final class BlurHandler
extends Enum<BlurHandler> {
    public static final /* enum */ BlurHandler INSTANCE = new BlurHandler();
    private static final class_2960 GAUSSIAN_BLUR;
    public static volatile boolean sBlurEffect;
    public static volatile boolean sBlurWithBackground;
    public static volatile int sBlurRadius;
    public static volatile int sBackgroundDuration;
    public static volatile int[] sBackgroundColor;
    public static volatile int sFramerateInactive;
    public static volatile int sFramerateMinimized;
    public static volatile float sMasterVolumeInactive;
    public static volatile float sMasterVolumeMinimized;
    private final class_310 minecraft = class_310.method_1551();
    private volatile ArrayList<Class<? extends class_437>> mBlacklist = new ArrayList();
    private final int[] mBackgroundColor = new int[4];
    private boolean mFadingIn;
    private boolean mBlurring;
    private boolean mBlurLoaded;
    private float mBlurRadius;
    private boolean mHasScreen;
    @Nullable
    private class_279 mBlurEffect;
    private boolean mBlurEffectLoaded;
    private float mVolumeMultiplier = 1.0f;
    private static final /* synthetic */ BlurHandler[] $VALUES;

    public static BlurHandler[] values() {
        return (BlurHandler[])$VALUES.clone();
    }

    public static BlurHandler valueOf(String name) {
        return Enum.valueOf(BlurHandler.class, name);
    }

    public void blur(@Nullable class_437 nextScreen) {
        boolean blocked;
        boolean hasScreen;
        block21: {
            block22: {
                if (this.minecraft.field_1687 == null) {
                    return;
                }
                hasScreen = nextScreen != null;
                blocked = false;
                if (!hasScreen || !sBlurEffect) break block21;
                if (!(nextScreen instanceof MuiScreen)) break block22;
                MuiScreen screen = (MuiScreen)nextScreen;
                ScreenCallback callback = screen.getCallback();
                if (callback == null) break block21;
                blocked = !callback.shouldBlurBackground();
                break block21;
            }
            Class<?> t = nextScreen.getClass();
            for (Class<? extends class_437> c : this.mBlacklist) {
                if (!c.isAssignableFrom(t)) continue;
                blocked = true;
                break;
            }
        }
        if (blocked && this.mBlurring) {
            if (this.mBlurLoaded) {
                this.minecraft.field_1773.method_3207();
            }
            this.mBlurring = false;
            this.mBlurLoaded = false;
        }
        class_757 gr = this.minecraft.field_1773;
        if (hasScreen && !this.mHasScreen) {
            if (!blocked && sBlurEffect && !this.mBlurring && sBlurRadius >= 1) {
                if (sBlurWithBackground) {
                    if (!this.mBlurEffectLoaded) {
                        this.loadEffect();
                        assert (this.mBlurEffectLoaded);
                    }
                    if (this.mBlurEffect != null) {
                        this.mBlurring = true;
                    }
                } else if (gr.method_3183() == null) {
                    this.mBlurring = true;
                    this.mBlurLoaded = true;
                    MuiModApi.get().loadEffect(this.minecraft.field_1773, GAUSSIAN_BLUR);
                }
                if (this.mBlurring) {
                    if (sBackgroundDuration > 0) {
                        this.updateRadius(1.0f);
                    } else {
                        this.updateRadius(sBlurRadius);
                    }
                }
            }
            if (sBackgroundDuration > 0) {
                this.mFadingIn = true;
                Arrays.fill(this.mBackgroundColor, 0);
            } else {
                this.mFadingIn = false;
                System.arraycopy(sBackgroundColor, 0, this.mBackgroundColor, 0, 4);
            }
        } else if (!hasScreen) {
            if (this.mBlurring) {
                if (this.mBlurLoaded) {
                    gr.method_3207();
                }
                this.mBlurring = false;
                this.mBlurLoaded = false;
            }
            this.mFadingIn = false;
        }
        this.mHasScreen = hasScreen;
    }

    public void closeEffect() {
        if (this.mBlurEffect != null) {
            this.mBlurEffect.close();
        }
        this.mBlurEffect = null;
    }

    public void loadEffect() {
        this.closeEffect();
        if (sBlurEffect && sBlurWithBackground) {
            this.mBlurEffectLoaded = true;
            try {
                this.mBlurEffect = new class_279(this.minecraft.method_1531(), this.minecraft.method_1478(), this.minecraft.method_1522(), GAUSSIAN_BLUR);
                this.mBlurEffect.method_1259(this.minecraft.method_22683().method_4489(), this.minecraft.method_22683().method_4506());
            }
            catch (Exception e) {
                ModernUI.LOGGER.warn(ModernUI.MARKER, "Failed to load blur effect", (Throwable)e);
            }
            if (this.mBlurEffect == null) {
                this.mBlurring = false;
            }
        }
    }

    public void resize(int width, int height) {
        if (this.mBlurEffect != null) {
            this.mBlurEffect.method_1259(width, height);
        }
    }

    public void loadBlacklist(@Nullable List<? extends String> names) {
        ArrayList blacklist = new ArrayList();
        if (names != null) {
            for (String string : names) {
                if (StringUtils.isEmpty((CharSequence)string)) continue;
                try {
                    Class<?> clazz = Class.forName(string, false, ModernUIMod.class.getClassLoader());
                    blacklist.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    ModernUI.LOGGER.warn(ModernUI.MARKER, "Failed to add blur blacklist {}: make sure class name exists", (Object)string, (Object)e);
                }
                catch (ClassCastException e) {
                    ModernUI.LOGGER.warn(ModernUI.MARKER, "Failed to add blur blacklist {}: make sure class is a valid subclass of Screen", (Object)string, (Object)e);
                }
            }
            blacklist.trimToSize();
        }
        this.mBlacklist = blacklist;
    }

    public void onRenderTick(long elapsedTimeMillis) {
        if (this.mFadingIn) {
            float p = Math.min((float)elapsedTimeMillis / (float)sBackgroundDuration, 1.0f);
            if (this.mBlurring) {
                this.updateRadius(Math.max(p * (float)sBlurRadius, 1.0f));
            }
            for (int i = 0; i < 4; ++i) {
                this.mBackgroundColor[i] = ColorEvaluator.evaluate(p, 0, sBackgroundColor[i]);
            }
            if (p == 1.0f) {
                this.mFadingIn = false;
            }
        }
    }

    private void updateRadius(float radius) {
        this.mBlurRadius = radius;
        if (sBlurWithBackground) {
            return;
        }
        class_279 effect = this.minecraft.field_1773.method_3183();
        if (effect == null) {
            return;
        }
        this.updateRadius(effect, radius);
    }

    private void updateRadius(@Nonnull class_279 effect, float radius) {
        List<class_283> passes = ((AccessPostChain)effect).getPasses();
        for (class_283 s : passes) {
            s.method_1295().method_1275("Progress").method_1251(radius);
        }
    }

    public void onClientTick() {
        float targetVolumeMultiplier = this.minecraft.method_1569() ? 1.0f : (sMasterVolumeMinimized < sMasterVolumeInactive && GLFW.glfwGetWindowAttrib((long)this.minecraft.method_22683().method_4490(), (int)131074) != 0 ? sMasterVolumeMinimized : sMasterVolumeInactive);
        if (this.mVolumeMultiplier != targetVolumeMultiplier) {
            this.mVolumeMultiplier = this.mVolumeMultiplier < targetVolumeMultiplier ? Math.min(this.mVolumeMultiplier + 0.5f, targetVolumeMultiplier) : Math.max(this.mVolumeMultiplier - 0.05f, targetVolumeMultiplier);
            float volume = this.minecraft.field_1690.method_1630(class_3419.field_15250);
            this.minecraft.method_1483().method_4865(class_3419.field_15250, volume * this.mVolumeMultiplier);
        }
    }

    public void drawScreenBackground(@Nonnull class_332 gr, int x1, int y1, int x2, int y2) {
        class_4588 consumer = gr.method_51450().getBuffer(class_1921.method_51784());
        Matrix4f pose = gr.method_51448().method_23760().method_23761();
        boolean z = false;
        if (this.minecraft.field_1687 == null) {
            consumer.method_22918(pose, (float)x2, (float)y1, (float)z).method_1336(30, 31, 34, 255).method_1344();
            consumer.method_22918(pose, (float)x1, (float)y1, (float)z).method_1336(30, 31, 34, 255).method_1344();
            consumer.method_22918(pose, (float)x1, (float)y2, (float)z).method_1336(30, 31, 34, 255).method_1344();
            consumer.method_22918(pose, (float)x2, (float)y2, (float)z).method_1336(30, 31, 34, 255).method_1344();
        } else {
            if (this.mBlurring && sBlurWithBackground && this.mBlurEffect != null) {
                this.updateRadius(this.mBlurEffect, this.mBlurRadius);
                RenderSystem.disableDepthTest();
                this.mBlurEffect.method_1258(0.0f);
                this.minecraft.method_1522().method_1235(false);
            }
            int color = this.mBackgroundColor[1];
            consumer.method_22918(pose, (float)x2, (float)y1, (float)z).method_1336(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >>> 24).method_1344();
            color = this.mBackgroundColor[0];
            consumer.method_22918(pose, (float)x1, (float)y1, (float)z).method_1336(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >>> 24).method_1344();
            color = this.mBackgroundColor[3];
            consumer.method_22918(pose, (float)x1, (float)y2, (float)z).method_1336(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >>> 24).method_1344();
            color = this.mBackgroundColor[2];
            consumer.method_22918(pose, (float)x2, (float)y2, (float)z).method_1336(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >>> 24).method_1344();
        }
        gr.method_51452();
    }

    private static /* synthetic */ BlurHandler[] $values() {
        return new BlurHandler[]{INSTANCE};
    }

    static {
        $VALUES = BlurHandler.$values();
        GAUSSIAN_BLUR = new class_2960("shaders/post/modern_gaussian_blur.json");
        sBackgroundColor = new int[4];
        sMasterVolumeInactive = 1.0f;
        sMasterVolumeMinimized = 1.0f;
    }
}

