/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.lifecycle;

import icyllis.modernui.annotation.UiThread;
import icyllis.modernui.core.Core;
import icyllis.modernui.lifecycle.Lifecycle;
import icyllis.modernui.lifecycle.LifecycleObserver;
import icyllis.modernui.lifecycle.LifecycleOwner;
import icyllis.modernui.lifecycle.Observer;
import icyllis.modernui.lifecycle.SafeLinkedList;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class LiveData<T> {
    final Object mDataLock = new Object();
    static final int START_VERSION = -1;
    static final Object NOT_SET = new Object();
    private final SafeLinkedList<Observer<? super T>, ObserverWrapper> mObservers = new SafeLinkedList();
    int mActiveCount = 0;
    private volatile Object mData;
    volatile Object mPendingData = NOT_SET;
    private int mVersion;
    private boolean mDispatchingValue;
    private boolean mDispatchInvalidated;
    private final Runnable mPostValueRunnable = () -> {
        Object newValue;
        Object object = this.mDataLock;
        synchronized (object) {
            newValue = this.mPendingData;
            this.mPendingData = NOT_SET;
        }
        this.setValue(newValue);
    };

    public LiveData(T value) {
        this.mData = value;
        this.mVersion = 0;
    }

    public LiveData() {
        this.mData = NOT_SET;
        this.mVersion = -1;
    }

    private void considerNotify(@Nonnull ObserverWrapper observer) {
        if (!observer.mActive) {
            return;
        }
        if (!observer.shouldBeActive()) {
            observer.activeStateChanged(false);
            return;
        }
        if (observer.mLastVersion >= this.mVersion) {
            return;
        }
        observer.mLastVersion = this.mVersion;
        observer.mObserver.onChanged(this.mData);
    }

    void dispatchingValue(@Nullable ObserverWrapper initiator) {
        if (this.mDispatchingValue) {
            this.mDispatchInvalidated = true;
            return;
        }
        this.mDispatchingValue = true;
        do {
            this.mDispatchInvalidated = false;
            if (initiator != null) {
                this.considerNotify(initiator);
                initiator = null;
                continue;
            }
            Iterator<ObserverWrapper> iterator = this.mObservers.iteratorWithAdditions();
            while (iterator.hasNext()) {
                this.considerNotify(iterator.next());
                if (!this.mDispatchInvalidated) continue;
            }
        } while (this.mDispatchInvalidated);
        this.mDispatchingValue = false;
    }

    @UiThread
    public void observe(@Nonnull LifecycleOwner owner, @Nonnull Observer<? super T> observer) {
        Core.checkUiThread();
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        LifecycleBoundObserver wrapper = new LifecycleBoundObserver(owner, observer);
        ObserverWrapper existing = this.mObservers.putIfAbsent(wrapper);
        if (existing != null && !existing.isAttachedTo(owner)) {
            throw new IllegalArgumentException("Cannot add the same observer with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        owner.getLifecycle().addObserver(wrapper);
    }

    @UiThread
    public void observeForever(@Nonnull Observer<? super T> observer) {
        Core.checkUiThread();
        AlwaysActiveObserver wrapper = new AlwaysActiveObserver(observer);
        ObserverWrapper existing = this.mObservers.putIfAbsent(wrapper);
        if (existing instanceof LifecycleBoundObserver) {
            throw new IllegalArgumentException("Cannot add the same observer with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        wrapper.activeStateChanged(true);
    }

    @UiThread
    public void removeObserver(@Nonnull Observer<? super T> observer) {
        Core.checkUiThread();
        ObserverWrapper removed = this.mObservers.remove(observer);
        if (removed == null) {
            return;
        }
        removed.detachObserver();
        removed.activeStateChanged(false);
    }

    @UiThread
    public void removeObservers(@Nonnull LifecycleOwner owner) {
        Core.checkUiThread();
        for (ObserverWrapper entry : this.mObservers) {
            if (!entry.isAttachedTo(owner)) continue;
            this.removeObserver(entry.mObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postValue(T value) {
        boolean postTask;
        Object object = this.mDataLock;
        synchronized (object) {
            postTask = this.mPendingData == NOT_SET;
            this.mPendingData = value;
        }
        if (!postTask) {
            return;
        }
        Core.getUiHandlerAsync().post(this.mPostValueRunnable);
    }

    @UiThread
    protected void setValue(T value) {
        Core.checkUiThread();
        ++this.mVersion;
        this.mData = value;
        this.dispatchingValue(null);
    }

    @Nullable
    public T getValue() {
        Object data = this.mData;
        if (data != NOT_SET) {
            return (T)data;
        }
        return null;
    }

    int getVersion() {
        return this.mVersion;
    }

    protected void onActive() {
    }

    protected void onInactive() {
    }

    public boolean hasObservers() {
        return this.mObservers.size() > 0;
    }

    public boolean hasActiveObservers() {
        return this.mActiveCount > 0;
    }

    private abstract class ObserverWrapper
    implements Supplier<Observer<? super T>> {
        final Observer<? super T> mObserver;
        boolean mActive;
        int mLastVersion = -1;

        ObserverWrapper(Observer<? super T> observer) {
            this.mObserver = observer;
        }

        @Override
        public final Observer<? super T> get() {
            return this.mObserver;
        }

        abstract boolean shouldBeActive();

        boolean isAttachedTo(LifecycleOwner owner) {
            return false;
        }

        void detachObserver() {
        }

        void activeStateChanged(boolean newActive) {
            if (newActive == this.mActive) {
                return;
            }
            this.mActive = newActive;
            boolean wasInactive = LiveData.this.mActiveCount == 0;
            LiveData.this.mActiveCount = LiveData.this.mActiveCount + (this.mActive ? 1 : -1);
            if (wasInactive && this.mActive) {
                LiveData.this.onActive();
            }
            if (LiveData.this.mActiveCount == 0 && !this.mActive) {
                LiveData.this.onInactive();
            }
            if (this.mActive) {
                LiveData.this.dispatchingValue(this);
            }
        }
    }

    class LifecycleBoundObserver
    extends ObserverWrapper
    implements LifecycleObserver {
        @Nonnull
        final LifecycleOwner mOwner;

        LifecycleBoundObserver(LifecycleOwner owner, Observer<? super T> observer) {
            super(observer);
            this.mOwner = owner;
        }

        @Override
        boolean shouldBeActive() {
            return this.mOwner.getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED);
        }

        @Override
        public void onStateChanged(@Nonnull LifecycleOwner source, @Nonnull Lifecycle.Event event) {
            if (this.mOwner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
                LiveData.this.removeObserver(this.mObserver);
                return;
            }
            this.activeStateChanged(this.shouldBeActive());
        }

        @Override
        boolean isAttachedTo(LifecycleOwner owner) {
            return this.mOwner == owner;
        }

        @Override
        void detachObserver() {
            this.mOwner.getLifecycle().removeObserver(this);
        }
    }

    private class AlwaysActiveObserver
    extends ObserverWrapper {
        AlwaysActiveObserver(Observer<? super T> observer) {
            super(observer);
        }

        @Override
        boolean shouldBeActive() {
            return true;
        }
    }
}

