/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.text;

import icyllis.arc3d.core.Typeface;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.graphics.text.FontMetricsInt;
import icyllis.modernui.graphics.text.FontPaint;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;

public interface Font {
    public int getStyle();

    default public String getFullName() {
        return this.getFullName(Locale.ROOT);
    }

    public String getFullName(@NonNull Locale var1);

    default public String getFamilyName() {
        return this.getFamilyName(Locale.ROOT);
    }

    public String getFamilyName(@NonNull Locale var1);

    public int getMetrics(@NonNull FontPaint var1, @Nullable FontMetricsInt var2);

    @ApiStatus.Internal
    public boolean hasGlyph(int var1, int var2);

    @ApiStatus.Internal
    default public int calcGlyphScore(char[] buf, int start, int limit) {
        for (int i = start; i < limit; ++i) {
            char c = buf[i];
            if (this.hasGlyph(c, 0)) continue;
            if (!Character.isHighSurrogate(c)) {
                return i;
            }
            if (!this.hasGlyph(Character.codePointAt(buf, i, limit), 0)) {
                return i;
            }
            ++i;
        }
        return limit;
    }

    @ApiStatus.Internal
    public float doSimpleLayout(char[] var1, int var2, int var3, FontPaint var4, IntArrayList var5, FloatArrayList var6, float var7, float var8);

    @ApiStatus.Internal
    public float doComplexLayout(char[] var1, int var2, int var3, int var4, int var5, boolean var6, FontPaint var7, IntArrayList var8, FloatArrayList var9, float[] var10, int var11, Rect var12, float var13, float var14);

    @ApiStatus.Internal
    public Typeface getNativeTypeface();
}

