/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics;

import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.RawPtr;
import icyllis.modernui.annotation.ColorInt;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.annotation.Size;
import icyllis.modernui.core.Core;
import icyllis.modernui.graphics.BlendMode;
import icyllis.modernui.graphics.ColorFilter;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

public final class BlendModeColorFilter
extends ColorFilter {
    @Size(value=4L)
    private final float[] mColor;
    private final BlendMode mMode;
    @Nullable
    private final icyllis.arc3d.core.effects.BlendModeColorFilter mColorFilter;

    public BlendModeColorFilter(@ColorInt int color, @NonNull BlendMode mode) {
        this((float)(color >> 16 & 0xFF) * 0.003921569f, (float)(color >> 8 & 0xFF) * 0.003921569f, (float)(color & 0xFF) * 0.003921569f, (float)(color >>> 24) * 0.003921569f, mode);
    }

    public BlendModeColorFilter(@NonNull @Size(value=4L) float[] color, @Nullable ColorSpace colorSpace, @NonNull BlendMode mode) {
        this(color[0], color[1], color[2], color[3], colorSpace, mode);
    }

    public BlendModeColorFilter(float r, float g, float b, float a, @NonNull BlendMode mode) {
        this(r, g, b, a, null, mode);
    }

    public BlendModeColorFilter(float r, float g, float b, float a, @Nullable ColorSpace colorSpace, @NonNull BlendMode mode) {
        Objects.requireNonNull(mode);
        this.mColor = new float[]{MathUtil.pin(r, 0.0f, 1.0f), MathUtil.pin(g, 0.0f, 1.0f), MathUtil.pin(b, 0.0f, 1.0f), MathUtil.pin(a, 0.0f, 1.0f)};
        this.mMode = mode;
        this.mColorFilter = icyllis.arc3d.core.effects.BlendModeColorFilter.make(this.mColor, colorSpace, mode.getNativeBlendMode());
        if (this.mColorFilter != null) {
            Core.registerNativeResource((Object)this, this.mColorFilter);
        }
    }

    public int getColor() {
        return (int)(this.mColor[0] * 255.0f + 0.5f) << 16 | (int)(this.mColor[1] * 255.0f + 0.5f) << 8 | (int)(this.mColor[2] * 255.0f + 0.5f) | (int)(this.mColor[3] * 255.0f + 0.5f) << 24;
    }

    @NonNull
    public float[] getColor4f() {
        return (float[])this.mColor.clone();
    }

    @NonNull
    public float[] getColor4f(@NonNull @Size(value=4L) float[] dst) {
        System.arraycopy(this.mColor, 0, dst, 0, 4);
        return dst;
    }

    @NonNull
    public BlendMode getMode() {
        return this.mMode;
    }

    @Override
    @ApiStatus.Internal
    @RawPtr
    public icyllis.arc3d.core.effects.ColorFilter getNativeColorFilter() {
        return this.mColorFilter;
    }
}

