/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.fragment;

import icyllis.modernui.core.CancellationSignal;
import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.fragment.SharedElementCallback;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.transition.Transition;
import icyllis.modernui.transition.TransitionListener;
import icyllis.modernui.transition.TransitionSet;
import icyllis.modernui.util.ArrayMap;
import icyllis.modernui.view.OneShotPreDrawListener;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class FragmentTransition {
    private FragmentTransition() {
    }

    @Nullable
    static String findKeyForValue(@Nonnull ArrayMap<String, String> map, @Nonnull String value) {
        int numElements = map.size();
        for (int i = 0; i < numElements; ++i) {
            if (!value.equals(map.valueAt(i))) continue;
            return map.keyAt(i);
        }
        return null;
    }

    static void retainValues(@Nonnull ArrayMap<String, String> nameOverrides, @Nonnull ArrayMap<String, View> namedViews) {
        for (int i = nameOverrides.size() - 1; i >= 0; --i) {
            String targetName = nameOverrides.valueAt(i);
            if (namedViews.containsKey(targetName)) continue;
            nameOverrides.removeAt(i);
        }
    }

    static void callSharedElementStartEnd(Fragment inFragment, Fragment outFragment, boolean isPop, ArrayMap<String, View> sharedElements, boolean isStart) {
        SharedElementCallback sharedElementCallback;
        SharedElementCallback sharedElementCallback2 = sharedElementCallback = isPop ? outFragment.getEnterTransitionCallback() : inFragment.getEnterTransitionCallback();
        if (sharedElementCallback != null) {
            ArrayList<View> views = new ArrayList<View>();
            ArrayList<String> names = new ArrayList<String>();
            int count = sharedElements == null ? 0 : sharedElements.size();
            for (int i = 0; i < count; ++i) {
                names.add(sharedElements.keyAt(i));
                views.add(sharedElements.valueAt(i));
            }
            if (isStart) {
                sharedElementCallback.onSharedElementStart(names, views, null);
            } else {
                sharedElementCallback.onSharedElementEnd(names, views, null);
            }
        }
    }

    static void setViewVisibility(ArrayList<View> views, int visibility) {
        if (views == null) {
            return;
        }
        for (int i = views.size() - 1; i >= 0; --i) {
            View view = views.get(i);
            view.setVisibility(visibility);
        }
    }

    @Nonnull
    static ArrayList<String> prepareSetNameOverridesReordered(@Nonnull ArrayList<View> sharedElementsIn) {
        ArrayList<String> names = new ArrayList<String>();
        for (View view : sharedElementsIn) {
            names.add(view.getTransitionName());
            view.setTransitionName(null);
        }
        return names;
    }

    static void setNameOverridesReordered(@Nonnull View sceneRoot, @Nonnull ArrayList<View> sharedElementsOut, @Nonnull ArrayList<View> sharedElementsIn, @Nonnull ArrayList<String> inNames, @Nonnull Map<String, String> nameOverrides) {
        int numSharedElements = sharedElementsIn.size();
        ArrayList<String> outNames = new ArrayList<String>();
        block0: for (int i = 0; i < numSharedElements; ++i) {
            View view = sharedElementsOut.get(i);
            String name = view.getTransitionName();
            outNames.add(name);
            if (name == null) continue;
            view.setTransitionName(null);
            String inName = nameOverrides.get(name);
            for (int j = 0; j < numSharedElements; ++j) {
                if (!inName.equals(inNames.get(j))) continue;
                sharedElementsIn.get(j).setTransitionName(name);
                continue block0;
            }
        }
        OneShotPreDrawListener.add(sceneRoot, () -> {
            for (int i = 0; i < numSharedElements; ++i) {
                ((View)sharedElementsIn.get(i)).setTransitionName((String)inNames.get(i));
                ((View)sharedElementsOut.get(i)).setTransitionName((String)outNames.get(i));
            }
        });
    }

    static void setSharedElementTargets(@Nonnull TransitionSet transition, @Nonnull View nonExistentView, @Nonnull ArrayList<View> sharedViews) {
        List<View> views = transition.getTargets();
        views.clear();
        for (View view : sharedViews) {
            FragmentTransition.bfsAddViewChildren(views, view);
        }
        views.add(nonExistentView);
        sharedViews.add(nonExistentView);
        FragmentTransition.addTargets(transition, sharedViews);
    }

    static void setEpicenter(@Nonnull Transition transition, View view) {
        if (view != null) {
            Rect epicenter = new Rect();
            view.getBoundsOnScreen(epicenter);
            transition.setEpicenterCallback(t -> epicenter);
        }
    }

    static void setEpicenter(Transition transition, Rect epicenter) {
        if (transition != null) {
            transition.setEpicenterCallback(t -> {
                if (epicenter == null || epicenter.isEmpty()) {
                    return null;
                }
                return epicenter;
            });
        }
    }

    static void addTargets(@Nullable Transition transition, @Nonnull ArrayList<View> views) {
        block4: {
            List<View> targets;
            block3: {
                if (transition == null) {
                    return;
                }
                if (!(transition instanceof TransitionSet)) break block3;
                TransitionSet set = (TransitionSet)transition;
                int numTransitions = set.getTransitionCount();
                for (int i = 0; i < numTransitions; ++i) {
                    Transition child = set.getTransitionAt(i);
                    FragmentTransition.addTargets(child, views);
                }
                break block4;
            }
            if (FragmentTransition.hasSimpleTarget(transition) || !FragmentTransition.isNullOrEmpty(targets = transition.getTargets())) break block4;
            for (View view : views) {
                transition.addTarget(view);
            }
        }
    }

    @Nonnull
    static TransitionSet mergeTransitionsTogether(@Nullable Transition transition1, @Nullable Transition transition2, @Nullable Transition transition3) {
        TransitionSet transitionSet = new TransitionSet();
        if (transition1 != null) {
            transitionSet.addTransition(transition1);
        }
        if (transition2 != null) {
            transitionSet.addTransition(transition2);
        }
        if (transition3 != null) {
            transitionSet.addTransition(transition3);
        }
        return transitionSet;
    }

    static void scheduleHideFragmentView(@Nonnull Transition exitTransition, final View fragmentView, final ArrayList<View> exitingViews) {
        exitTransition.addListener(new TransitionListener(){

            @Override
            public void onTransitionStart(@Nonnull Transition transition) {
                transition.removeListener(this);
                transition.addListener(this);
            }

            @Override
            public void onTransitionEnd(@Nonnull Transition transition) {
                transition.removeListener(this);
                fragmentView.setVisibility(8);
                for (View exitingView : exitingViews) {
                    exitingView.setVisibility(0);
                }
            }
        });
    }

    static Transition mergeTransitionsInSequence(Transition exitTransition, Transition enterTransition, Transition sharedElementTransition) {
        Transition staggered = null;
        if (exitTransition != null && enterTransition != null) {
            staggered = new TransitionSet().addTransition(exitTransition).addTransition(enterTransition).setOrdering(1);
        } else if (exitTransition != null) {
            staggered = exitTransition;
        } else if (enterTransition != null) {
            staggered = enterTransition;
        }
        if (sharedElementTransition != null) {
            TransitionSet together = new TransitionSet();
            if (staggered != null) {
                together.addTransition(staggered);
            }
            together.addTransition(sharedElementTransition);
            return together;
        }
        return staggered;
    }

    static void scheduleRemoveTargets(@Nonnull Transition overallTransition, final @Nullable Transition enterTransition, final ArrayList<View> enteringViews, final @Nullable Transition exitTransition, final ArrayList<View> exitingViews, final @Nullable Transition sharedElementTransition, final ArrayList<View> sharedElementsIn) {
        overallTransition.addListener(new TransitionListener(){

            @Override
            public void onTransitionStart(@Nonnull Transition transition) {
                if (enterTransition != null) {
                    FragmentTransition.replaceTargets(enterTransition, enteringViews, null);
                }
                if (exitTransition != null) {
                    FragmentTransition.replaceTargets(exitTransition, exitingViews, null);
                }
                if (sharedElementTransition != null) {
                    FragmentTransition.replaceTargets(sharedElementTransition, sharedElementsIn, null);
                }
            }

            @Override
            public void onTransitionEnd(@Nonnull Transition transition) {
                transition.removeListener(this);
            }
        });
    }

    static void setListenerForTransitionEnd(@Nonnull Transition transition, @Nonnull CancellationSignal signal, final @Nonnull Runnable transitionCompleteRunnable) {
        signal.setOnCancelListener(transition::cancel);
        transition.addListener(new TransitionListener(){

            @Override
            public void onTransitionEnd(@Nonnull Transition transition) {
                transitionCompleteRunnable.run();
            }
        });
    }

    static void swapSharedElementTargets(TransitionSet sharedElementTransition, ArrayList<View> sharedElementsOut, ArrayList<View> sharedElementsIn) {
        if (sharedElementTransition != null) {
            sharedElementTransition.getTargets().clear();
            sharedElementTransition.getTargets().addAll(sharedElementsIn);
            FragmentTransition.replaceTargets(sharedElementTransition, sharedElementsOut, sharedElementsIn);
        }
    }

    static void replaceTargets(Transition transition, ArrayList<View> oldTargets, ArrayList<View> newTargets) {
        block4: {
            int i;
            List<View> targets;
            block3: {
                if (!(transition instanceof TransitionSet)) break block3;
                TransitionSet set = (TransitionSet)transition;
                int numTransitions = set.getTransitionCount();
                for (int i2 = 0; i2 < numTransitions; ++i2) {
                    Transition child = set.getTransitionAt(i2);
                    FragmentTransition.replaceTargets(child, oldTargets, newTargets);
                }
                break block4;
            }
            if (FragmentTransition.hasSimpleTarget(transition) || (targets = transition.getTargets()).size() != oldTargets.size() || !targets.containsAll(oldTargets)) break block4;
            int targetCount = newTargets == null ? 0 : newTargets.size();
            for (i = 0; i < targetCount; ++i) {
                transition.addTarget(newTargets.get(i));
            }
            for (i = oldTargets.size() - 1; i >= 0; --i) {
                transition.removeTarget(oldTargets.get(i));
            }
        }
    }

    static void bfsAddViewChildren(@Nonnull List<View> views, @Nonnull View startView) {
        int startIndex = views.size();
        if (FragmentTransition.containedBeforeIndex(views, startView, startIndex)) {
            return;
        }
        if (startView.getTransitionName() != null) {
            views.add(startView);
        }
        for (int index = startIndex; index < views.size(); ++index) {
            View view = views.get(index);
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                View child = viewGroup.getChildAt(childIndex);
                if (FragmentTransition.containedBeforeIndex(views, child, startIndex) || child.getTransitionName() == null) continue;
                views.add(child);
            }
        }
    }

    private static boolean containedBeforeIndex(List<View> views, View view, int maxIndex) {
        for (int i = 0; i < maxIndex; ++i) {
            if (views.get(i) != view) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSimpleTarget(@Nonnull Transition transition) {
        return !FragmentTransition.isNullOrEmpty(transition.getTargetIds()) || !FragmentTransition.isNullOrEmpty(transition.getTargetNames()) || !FragmentTransition.isNullOrEmpty(transition.getTargetTypes());
    }

    private static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }
}

