/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.fragment;

import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.fragment.FragmentManager;
import icyllis.modernui.fragment.FragmentManagerViewModel;
import icyllis.modernui.fragment.FragmentStateManager;
import icyllis.modernui.view.ViewGroup;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Marker;

final class FragmentStore {
    private static final Marker MARKER = FragmentManager.MARKER;
    private final ArrayList<Fragment> mAdded = new ArrayList();
    private final HashMap<String, FragmentStateManager> mActive = new HashMap();
    private FragmentManagerViewModel mViewModel;

    FragmentStore() {
    }

    void setViewModel(@Nonnull FragmentManagerViewModel viewModel) {
        this.mViewModel = viewModel;
    }

    FragmentManagerViewModel getViewModel() {
        return this.mViewModel;
    }

    void resetActiveFragments() {
        this.mActive.clear();
    }

    void restoreAddedFragments(@Nullable List<String> added) {
        this.mAdded.clear();
        if (added != null) {
            for (String who : added) {
                Fragment f = this.findActiveFragment(who);
                if (f == null) {
                    throw new IllegalStateException("No instantiated fragment for (" + who + ")");
                }
                this.addFragment(f);
            }
        }
    }

    void makeActive(@Nonnull FragmentStateManager active) {
        Fragment f = active.getFragment();
        if (this.mActive.put(f.mWho, active) == null && f.mRetainInstanceChangedWhileDetached) {
            if (f.mRetainInstance) {
                this.mViewModel.addRetainedFragment(f);
            } else {
                this.mViewModel.removeRetainedFragment(f);
            }
            f.mRetainInstanceChangedWhileDetached = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFragment(@Nonnull Fragment fragment) {
        if (this.mAdded.contains(fragment)) {
            throw new IllegalStateException("Fragment already added: " + fragment);
        }
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            this.mAdded.add(fragment);
        }
        fragment.mAdded = true;
    }

    void dispatchStateChange(int state) {
        for (FragmentStateManager manager : this.mActive.values()) {
            if (manager == null) continue;
            manager.setFragmentManagerState(state);
        }
    }

    void moveToExpectedState() {
        for (Fragment f : this.mAdded) {
            FragmentStateManager fragmentStateManager = this.mActive.get(f.mWho);
            if (fragmentStateManager == null) continue;
            fragmentStateManager.moveToExpectedState();
        }
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager == null) continue;
            fragmentStateManager.moveToExpectedState();
            Fragment f = fragmentStateManager.getFragment();
            boolean beingRemoved = f.mRemoving && !f.isInBackStack();
            if (!beingRemoved) continue;
            this.makeInactive(fragmentStateManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFragment(@Nonnull Fragment fragment) {
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            this.mAdded.remove(fragment);
        }
        fragment.mAdded = false;
    }

    void makeInactive(@Nonnull FragmentStateManager inactive) {
        Fragment f = inactive.getFragment();
        if (f.mRetainInstance) {
            this.mViewModel.removeRetainedFragment(f);
        }
        if (this.mActive.put(f.mWho, null) != null) {
            // empty if block
        }
    }

    void burpActive() {
        Collection<FragmentStateManager> values = this.mActive.values();
        values.removeAll(Collections.singleton(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ArrayList<String> saveAddedFragments() {
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            if (this.mAdded.isEmpty()) {
                return null;
            }
            ArrayList<String> added = new ArrayList<String>(this.mAdded.size());
            for (Fragment f : this.mAdded) {
                added.add(f.mWho);
            }
            return added;
        }
    }

    @Nonnull
    List<FragmentStateManager> getActiveFragmentStateManagers() {
        ArrayList<FragmentStateManager> list = new ArrayList<FragmentStateManager>();
        for (FragmentStateManager manager : this.mActive.values()) {
            if (manager == null) continue;
            list.add(manager);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    List<Fragment> getFragments() {
        if (this.mAdded.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            return new ArrayList<Fragment>(this.mAdded);
        }
    }

    @Nonnull
    List<Fragment> getActiveFragments() {
        ArrayList<Fragment> list = new ArrayList<Fragment>();
        for (FragmentStateManager manager : this.mActive.values()) {
            if (manager != null) {
                list.add(manager.getFragment());
                continue;
            }
            list.add(null);
        }
        return list;
    }

    int getActiveFragmentCount() {
        return this.mActive.size();
    }

    @Nullable
    Fragment findFragmentById(int id2) {
        Fragment f;
        for (int i = this.mAdded.size() - 1; i >= 0; --i) {
            f = this.mAdded.get(i);
            if (f.mFragmentId != id2) continue;
            return f;
        }
        for (FragmentStateManager manager : this.mActive.values()) {
            if (manager == null) continue;
            f = manager.getFragment();
            if (f.mFragmentId != id2) continue;
            return f;
        }
        return null;
    }

    @Nullable
    Fragment findFragmentByTag(@Nullable String tag) {
        Fragment f;
        if (tag == null) {
            return null;
        }
        for (int i = this.mAdded.size() - 1; i >= 0; --i) {
            f = this.mAdded.get(i);
            if (!tag.equals(f.mTag)) continue;
            return f;
        }
        for (FragmentStateManager manager : this.mActive.values()) {
            if (manager == null) continue;
            f = manager.getFragment();
            if (!tag.equals(f.mTag)) continue;
            return f;
        }
        return null;
    }

    boolean containsActiveFragment(@Nonnull String who) {
        return this.mActive.get(who) != null;
    }

    @Nullable
    FragmentStateManager getFragmentStateManager(@Nonnull String who) {
        return this.mActive.get(who);
    }

    @Nullable
    Fragment findFragmentByWho(@Nonnull String who) {
        for (FragmentStateManager manager : this.mActive.values()) {
            if (manager == null) continue;
            Fragment f = manager.getFragment();
            if ((f = f.findFragmentByWho(who)) == null) continue;
            return f;
        }
        return null;
    }

    @Nullable
    Fragment findActiveFragment(@Nonnull String who) {
        FragmentStateManager manager = this.mActive.get(who);
        if (manager != null) {
            return manager.getFragment();
        }
        return null;
    }

    int findFragmentIndexInContainer(@Nonnull Fragment f) {
        int i;
        ViewGroup container = f.mContainer;
        if (container == null) {
            return -1;
        }
        int fragmentIndex = this.mAdded.indexOf(f);
        for (i = fragmentIndex - 1; i >= 0; --i) {
            Fragment underFragment = this.mAdded.get(i);
            if (underFragment.mContainer != container || underFragment.mView == null) continue;
            int underIndex = container.indexOfChild(underFragment.mView);
            return underIndex + 1;
        }
        for (i = fragmentIndex + 1; i < this.mAdded.size(); ++i) {
            Fragment overFragment = this.mAdded.get(i);
            if (overFragment.mContainer != container || overFragment.mView == null) continue;
            return container.indexOfChild(overFragment.mView);
        }
        return -1;
    }

    void dump(@Nonnull String prefix, @Nullable FileDescriptor fd, @Nonnull PrintWriter writer, String ... args) {
        int count;
        Fragment f;
        String innerPrefix = prefix + "    ";
        if (!this.mActive.isEmpty()) {
            writer.print(prefix);
            writer.println("Active Fragments:");
            for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
                writer.print(prefix);
                if (fragmentStateManager != null) {
                    f = fragmentStateManager.getFragment();
                    writer.println(f);
                    f.dump(innerPrefix, fd, writer, args);
                    continue;
                }
                writer.println("null");
            }
        }
        if ((count = this.mAdded.size()) > 0) {
            writer.print(prefix);
            writer.println("Added Fragments:");
            for (int i = 0; i < count; ++i) {
                f = this.mAdded.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f.toString());
            }
        }
    }
}

