/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;

public final class LocaleList {
    private static final Locale[] EMPTY_LOCALES = new Locale[0];
    private static final LocaleList EMPTY_LOCALE_LIST = new LocaleList(new Locale[0]);
    private final Locale[] mLocales;
    private final String mStringRepresentation;

    public LocaleList(Locale ... list) {
        if (list.length == 0) {
            this.mLocales = EMPTY_LOCALES;
            this.mStringRepresentation = "";
        } else {
            ArrayList<Locale> ll = new ArrayList<Locale>();
            HashSet<Locale> dedup = new HashSet<Locale>();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < list.length; ++i) {
                Locale l = list[i];
                if (l == null) {
                    throw new NullPointerException("list[" + i + "] is null");
                }
                if (!dedup.add(l)) continue;
                Locale clone = (Locale)l.clone();
                ll.add(clone);
                sb.append(clone.toLanguageTag());
                if (i >= list.length - 1) continue;
                sb.append(',');
            }
            this.mLocales = ll.toArray(new Locale[0]);
            this.mStringRepresentation = sb.toString();
        }
    }
}

