/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.vulkan;

import icyllis.arc3d.engine.ImageDesc;
import icyllis.arc3d.vulkan.VKUtil;

public final class VulkanImageDesc
extends ImageDesc {
    public final int mVkFlags;
    public final int mVkImageType;
    public final int mFormat;
    public final int mImageTiling;
    public final int mImageUsageFlags;
    public final int mSharingMode;

    public VulkanImageDesc(int vkFlags, int vkImageType, int format, int imageTiling, int imageUsageFlags, int sharingMode, int imageType, int width, int height, int depth, int arraySize, int mipLevelCount, int sampleCount, int flags) {
        super(imageType, width, height, depth, arraySize, mipLevelCount, sampleCount, flags);
        this.mVkFlags = vkFlags;
        this.mVkImageType = vkImageType;
        this.mFormat = format;
        this.mImageTiling = imageTiling;
        this.mImageUsageFlags = imageUsageFlags;
        this.mSharingMode = sharingMode;
    }

    @Override
    public int getBackend() {
        return 1;
    }

    @Override
    public int getVkFormat() {
        return this.mFormat;
    }

    @Override
    public int getChannelFlags() {
        return VKUtil.vkFormatChannels(this.mFormat);
    }

    @Override
    public boolean isSRGB() {
        return this.mFormat == 43;
    }

    @Override
    public int getCompressionType() {
        return VKUtil.vkFormatCompressionType(this.mFormat);
    }

    @Override
    public int getBytesPerBlock() {
        return VKUtil.vkFormatBytesPerBlock(this.mFormat);
    }

    @Override
    public int getDepthBits() {
        return VKUtil.vkFormatDepthBits(this.mFormat);
    }

    @Override
    public int getStencilBits() {
        return VKUtil.vkFormatStencilBits(this.mFormat);
    }

    public int hashCode() {
        int result = this.mVkFlags;
        result = 31 * result + this.mVkImageType;
        result = 31 * result + this.mFormat;
        result = 31 * result + this.mImageTiling;
        result = 31 * result + this.mImageUsageFlags;
        result = 31 * result + this.mSharingMode;
        result = 31 * result + this.mWidth;
        result = 31 * result + this.mHeight;
        result = 31 * result + this.mDepth;
        result = 31 * result + this.mArraySize;
        result = 31 * result + this.mMipLevelCount;
        result = 31 * result + this.mSampleCount;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof VulkanImageDesc) {
            VulkanImageDesc desc = (VulkanImageDesc)o;
            return this.mVkFlags == desc.mVkFlags && this.mVkImageType == desc.mVkImageType && this.mFormat == desc.mFormat && this.mImageTiling == desc.mImageTiling && this.mImageUsageFlags == desc.mImageUsageFlags && this.mSharingMode == desc.mSharingMode && this.mWidth == desc.mWidth && this.mHeight == desc.mHeight && this.mDepth == desc.mDepth && this.mArraySize == desc.mArraySize && this.mMipLevelCount == desc.mMipLevelCount && this.mSampleCount == desc.mSampleCount;
        }
        return false;
    }

    public String toString() {
        return "{vkFlags=0x" + Integer.toHexString(this.mVkFlags) + ", vkImageType=" + this.mVkImageType + ", vkFormat=" + VKUtil.vkFormatName(this.mFormat) + ", imageTiling=" + this.mImageTiling + ", imageUsageFlags=0x" + Integer.toHexString(this.mImageUsageFlags) + ", sharingMode=" + this.mSharingMode + ", width=" + this.mWidth + ", height=" + this.mHeight + ", depth=" + this.mDepth + ", arraySize=" + this.mArraySize + ", mipLevelCount=" + this.mMipLevelCount + ", sampleCount=" + this.mSampleCount + "}";
    }
}

