/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.vulkan;

import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.engine.BackendImage;
import icyllis.arc3d.engine.BackendRenderTarget;
import icyllis.arc3d.engine.Context;
import icyllis.arc3d.engine.ContextOptions;
import icyllis.arc3d.engine.Device;
import icyllis.arc3d.engine.FlushInfo;
import icyllis.arc3d.engine.GpuRenderTarget;
import icyllis.arc3d.engine.Image;
import icyllis.arc3d.engine.ImageProxyView;
import icyllis.arc3d.engine.OpsRenderPass;
import icyllis.arc3d.engine.ResourceProvider;
import icyllis.arc3d.engine.SurfaceProxy;
import icyllis.arc3d.vulkan.VulkanBackendContext;
import icyllis.arc3d.vulkan.VulkanCaps;
import icyllis.arc3d.vulkan.VulkanMemoryAllocator;
import icyllis.arc3d.vulkan.VulkanResourceProvider;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.VK11;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceProperties;
import org.lwjgl.vulkan.VkPhysicalDeviceProperties2;

public class VulkanDevice
extends Device {
    private VkPhysicalDevice mPhysicalDevice;
    private VkDevice mDevice;
    private VulkanMemoryAllocator mMemoryAllocator;
    private boolean mProtectedContext;
    private int mQueueIndex;

    public VulkanDevice(ContextOptions options, VulkanCaps caps, VulkanBackendContext backendContext, VulkanMemoryAllocator memoryAllocator) {
        super(1, options, caps);
        this.mMemoryAllocator = memoryAllocator;
        this.mPhysicalDevice = backendContext.mPhysicalDevice;
        this.mDevice = backendContext.mDevice;
        this.mQueueIndex = backendContext.mGraphicsQueueIndex;
    }

    @Nullable
    public static VulkanDevice make(@Nonnull VulkanBackendContext context, ContextOptions options) {
        VulkanCaps caps;
        if (context.mInstance == null || context.mPhysicalDevice == null || context.mDevice == null || context.mQueue == null) {
            return null;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkPhysicalDeviceProperties2 properties2 = VkPhysicalDeviceProperties2.calloc((MemoryStack)stack).sType$Default();
            VK11.vkGetPhysicalDeviceProperties2((VkPhysicalDevice)context.mPhysicalDevice, (VkPhysicalDeviceProperties2)properties2);
            VkPhysicalDeviceProperties properties = properties2.properties();
            caps = new VulkanCaps(options, context.mPhysicalDevice, properties.apiVersion(), context.mDeviceFeatures2, context.mInstance.getCapabilities(), context.mDevice.getCapabilities());
        }
        VulkanMemoryAllocator allocator = context.mMemoryAllocator;
        if (allocator == null) {
            return null;
        }
        return new VulkanDevice(options, caps, context, allocator);
    }

    public VkDevice vkDevice() {
        return this.mDevice;
    }

    public VkPhysicalDevice vkPhysicalDevice() {
        return this.mPhysicalDevice;
    }

    public int getQueueIndex() {
        return this.mQueueIndex;
    }

    public VulkanMemoryAllocator getMemoryAllocator() {
        return this.mMemoryAllocator;
    }

    public boolean checkResult(int result) {
        if (result == 0 || result > 0) {
            return true;
        }
        switch (result) {
            case -4: {
                this.mDeviceIsLost = true;
                break;
            }
            case -2: 
            case -1: {
                this.mOutOfMemoryEncountered = true;
            }
        }
        return false;
    }

    public boolean isProtectedContext() {
        return this.mProtectedContext;
    }

    @Override
    public ResourceProvider makeResourceProvider(Context context, long maxResourceBudget) {
        return new VulkanResourceProvider(this, context, maxResourceBudget);
    }

    @Override
    @Nullable
    protected GpuRenderTarget onCreateRenderTarget(int width, int height, int sampleCount, int numColorTargets, @Nullable Image[] colorTargets, @Nullable Image[] resolveTargets, @Nullable int[] mipLevels, @Nullable Image depthStencilTarget, int surfaceFlags) {
        return null;
    }

    @Override
    @Nullable
    protected GpuRenderTarget onWrapRenderableBackendTexture(BackendImage texture, int sampleCount, boolean ownership) {
        return null;
    }

    @Override
    @Nullable
    public GpuRenderTarget onWrapBackendRenderTarget(BackendRenderTarget backendRenderTarget) {
        return null;
    }

    @Override
    protected OpsRenderPass onGetOpsRenderPass(ImageProxyView writeView, Rect2i contentBounds, byte colorOps, byte stencilOps, float[] clearColor, Set<SurfaceProxy> sampledTextures, int pipelineFlags) {
        return null;
    }

    @Override
    protected void onResolveRenderTarget(GpuRenderTarget renderTarget, int resolveLeft, int resolveTop, int resolveRight, int resolveBottom) {
    }

    @Override
    public long insertFence() {
        return 0L;
    }

    @Override
    public boolean checkFence(long fence) {
        return false;
    }

    @Override
    public void deleteFence(long fence) {
    }

    @Override
    public void addFinishedCallback(FlushInfo.FinishedCallback callback) {
    }

    @Override
    public void checkFinishedCallbacks() {
    }

    @Override
    public void waitForQueue() {
    }
}

