/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.opengl;

import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.engine.Caps;
import icyllis.arc3d.engine.Key;
import icyllis.arc3d.engine.trash.GraphicsPipelineDesc_Old;
import icyllis.arc3d.engine.trash.PipelineKey_old;
import icyllis.arc3d.opengl.GLCaps;
import icyllis.arc3d.opengl.GLDevice;
import icyllis.arc3d.opengl.GLGraphicsPipeline;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Deprecated
public class GLPipelineCache {
    private final GLDevice mDevice;
    private final int mCacheSize;
    private final ConcurrentHashMap<Key, GLGraphicsPipeline> mCache;

    @VisibleForTesting
    public GLPipelineCache(GLDevice device, int cacheSize) {
        this.mDevice = device;
        this.mCacheSize = cacheSize;
        this.mCache = new ConcurrentHashMap(cacheSize, 0.5f);
    }

    public void discard() {
        this.mCache.values().forEach(GLGraphicsPipeline::discard);
        this.release();
    }

    public void release() {
        this.mCache.values().forEach(RefCnt::unref);
        this.mCache.clear();
    }

    @Nullable
    public GLGraphicsPipeline findOrCreateGraphicsPipeline(PipelineKey_old desc, GraphicsPipelineDesc_Old graphicsPipelineDesc) {
        if (desc.isEmpty()) {
            GLCaps caps = this.mDevice.getCaps();
            ((Caps)caps).makeDesc(desc, null, graphicsPipelineDesc);
        }
        assert (!desc.isEmpty());
        return this.findOrCreateGraphicsPipelineImpl(desc, graphicsPipelineDesc);
    }

    @Nonnull
    private GLGraphicsPipeline findOrCreateGraphicsPipelineImpl(PipelineKey_old desc, GraphicsPipelineDesc_Old graphicsPipelineDesc) {
        GLGraphicsPipeline existing = this.mCache.get(desc);
        if (existing != null) {
            return existing;
        }
        desc = new PipelineKey_old(desc);
        GLGraphicsPipeline newPipeline = null;
        existing = this.mCache.putIfAbsent(desc.toStorageKey(), newPipeline);
        if (existing != null) {
            newPipeline.discard();
            return existing;
        }
        return newPipeline;
    }

    public void close() {
        assert (this.mCache.isEmpty());
    }
}

