/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.opengl;

import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.Buffer;
import icyllis.arc3d.engine.GpuRenderTarget;
import icyllis.arc3d.engine.GraphicsPipeline;
import icyllis.arc3d.engine.OpsRenderPass;
import icyllis.arc3d.engine.trash.GraphicsPipelineDesc_Old;
import icyllis.arc3d.opengl.GLBuffer;
import icyllis.arc3d.opengl.GLCommandBuffer;
import icyllis.arc3d.opengl.GLDevice;
import icyllis.arc3d.opengl.GLGraphicsPipeline;
import icyllis.arc3d.opengl.GLRenderTarget;

public final class GLOpsRenderPass
extends OpsRenderPass {
    private final GLDevice mDevice;
    private GLCommandBuffer mCmdBuffer;
    private GLGraphicsPipeline mPipelineState;
    private byte mColorOps;
    private byte mStencilOps;
    private float[] mClearColor;
    private int mPrimitiveType;
    @SharedPtr
    private Buffer mActiveIndexBuffer;
    @SharedPtr
    private Buffer mActiveVertexBuffer;
    @SharedPtr
    private Buffer mActiveInstanceBuffer;
    private int mIndexType;
    private int mVertexStreamOffset;
    private int mInstanceStreamOffset;

    public GLOpsRenderPass(GLDevice device) {
        this.mDevice = device;
    }

    @Override
    protected GLDevice getDevice() {
        return this.mDevice;
    }

    public GLOpsRenderPass set(GpuRenderTarget renderTarget, Rect2i bounds, int origin, byte colorOps, byte stencilOps, float[] clearColor) {
        this.set(renderTarget, origin);
        this.mColorOps = colorOps;
        this.mStencilOps = stencilOps;
        this.mClearColor = clearColor;
        return this;
    }

    @Override
    public void begin() {
        super.begin();
        GLRenderTarget glRenderTarget = (GLRenderTarget)this.mRenderTarget;
    }

    @Override
    public void end() {
        this.mActiveIndexBuffer = RefCnt.move(this.mActiveIndexBuffer);
        this.mActiveVertexBuffer = RefCnt.move(this.mActiveVertexBuffer);
        this.mActiveInstanceBuffer = RefCnt.move(this.mActiveInstanceBuffer);
        GLRenderTarget glRenderTarget = (GLRenderTarget)this.mRenderTarget;
        super.end();
    }

    @Override
    protected boolean onBindPipeline(GraphicsPipelineDesc_Old graphicsPipelineDesc, GraphicsPipeline pipeline, Rect2fc drawBounds) {
        this.mActiveIndexBuffer = RefCnt.move(this.mActiveIndexBuffer);
        this.mActiveVertexBuffer = RefCnt.move(this.mActiveVertexBuffer);
        this.mActiveInstanceBuffer = RefCnt.move(this.mActiveInstanceBuffer);
        this.mPipelineState = (GLGraphicsPipeline)pipeline;
        if (this.mPipelineState == null) {
            return false;
        }
        this.mPrimitiveType = switch (graphicsPipelineDesc.primitiveType()) {
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 3;
            case 3 -> 4;
            case 4 -> 5;
            default -> throw new AssertionError();
        };
        return this.mPipelineState.bindUniforms(this.mCmdBuffer, graphicsPipelineDesc, this.mRenderTarget.getWidth(), this.mRenderTarget.getHeight());
    }

    @Override
    public void clearColor(int left, int top, int right, int bottom, float red, float green, float blue, float alpha) {
        super.clearColor(left, top, right, bottom, red, green, blue, alpha);
    }

    @Override
    public void clearStencil(int left, int top, int right, int bottom, boolean insideMask) {
        super.clearStencil(left, top, right, bottom, insideMask);
    }

    @Override
    protected void onBindBuffers(@RawPtr Buffer indexBuffer, int indexType, @RawPtr Buffer vertexBuffer, int vertexStreamOffset, @RawPtr Buffer instanceBuffer, int instanceStreamOffset) {
        assert (this.mPipelineState != null);
        if (!this.mDevice.getCaps().hasBaseInstanceSupport() && indexBuffer != null && !this.mDevice.getCaps().hasDrawElementsBaseVertexSupport()) {
            this.mPipelineState.bindIndexBuffer((GLBuffer)indexBuffer);
            this.mVertexStreamOffset = vertexStreamOffset;
            this.mInstanceStreamOffset = instanceStreamOffset;
        }
        this.mActiveIndexBuffer = RefCnt.create(this.mActiveIndexBuffer, indexBuffer);
        this.mActiveVertexBuffer = RefCnt.create(this.mActiveVertexBuffer, vertexBuffer);
        this.mActiveInstanceBuffer = RefCnt.create(this.mActiveInstanceBuffer, instanceBuffer);
        this.mIndexType = switch (indexType) {
            case 0 -> 5121;
            case 1 -> 5123;
            case 2 -> 5125;
            default -> throw new AssertionError();
        };
    }

    @Override
    protected void onDraw(int vertexCount, int baseVertex) {
        this.mDevice.getGL().glDrawArrays(this.mPrimitiveType, baseVertex, vertexCount);
    }

    @Override
    protected void onDrawIndexed(int indexCount, int baseIndex, int baseVertex) {
        if (this.mDevice.getCaps().hasDrawElementsBaseVertexSupport()) {
            this.mDevice.getGL().glDrawElementsBaseVertex(this.mPrimitiveType, indexCount, this.mIndexType, baseIndex, baseVertex);
        }
    }

    @Override
    protected void onDrawInstanced(int instanceCount, int baseInstance, int vertexCount, int baseVertex) {
        if (this.mDevice.getCaps().hasBaseInstanceSupport()) {
            this.mDevice.getGL().glDrawArraysInstancedBaseInstance(this.mPrimitiveType, baseVertex, vertexCount, instanceCount, baseInstance);
        }
    }

    @Override
    protected void onDrawIndexedInstanced(int indexCount, int baseIndex, int instanceCount, int baseInstance, int baseVertex) {
        if (this.mDevice.getCaps().hasBaseInstanceSupport()) {
            this.mDevice.getGL().glDrawElementsInstancedBaseVertexBaseInstance(this.mPrimitiveType, indexCount, this.mIndexType, baseIndex, instanceCount, baseVertex, baseInstance);
        }
    }
}

