/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.opengl;

import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.Framebuffer;
import icyllis.arc3d.engine.FramebufferDesc;
import icyllis.arc3d.opengl.GLDevice;
import icyllis.arc3d.opengl.GLImage;
import icyllis.arc3d.opengl.GLInterface;
import icyllis.arc3d.opengl.GLRenderbuffer;
import icyllis.arc3d.opengl.GLTexture;
import icyllis.arc3d.opengl.GLUtil;
import javax.annotation.Nullable;

public final class GLFramebuffer
extends Framebuffer {
    private int mRenderFramebuffer;
    private int mResolveFramebuffer;

    private GLFramebuffer(GLDevice device, int renderFramebuffer, int resolveFramebuffer) {
        super(device);
        this.mRenderFramebuffer = renderFramebuffer;
        this.mResolveFramebuffer = resolveFramebuffer;
    }

    private static void attachColorAttachment(GLInterface gl, int index, GLImage image, int mipLevel) {
        if (image instanceof GLRenderbuffer) {
            GLRenderbuffer renderbuffer = (GLRenderbuffer)image;
            gl.glFramebufferRenderbuffer(36160, 36064 + index, 36161, renderbuffer.getHandle());
        } else {
            GLTexture texture = (GLTexture)image;
            switch (texture.getTarget()) {
                case 3553: 
                case 37120: {
                    gl.glFramebufferTexture2D(36160, 36064 + index, texture.getTarget(), texture.getHandle(), mipLevel);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    @Nullable
    @SharedPtr
    public static GLFramebuffer make(GLDevice device, FramebufferDesc desc) {
        int status;
        FramebufferDesc.ColorAttachmentDesc attachmentDesc;
        int index;
        int resolveFramebuffer;
        assert (device.isOnExecutingThread());
        GLInterface gl = device.getGL();
        int renderFramebuffer = gl.glGenFramebuffers();
        if (renderFramebuffer == 0) {
            return null;
        }
        boolean hasColorAttachments = false;
        boolean hasColorResolveAttachments = false;
        int numColorAttachments = desc.mColorAttachments.length;
        for (int i = 0; i < numColorAttachments; ++i) {
            FramebufferDesc.ColorAttachmentDesc attachmentDesc2 = desc.mColorAttachments[i];
            hasColorAttachments |= attachmentDesc2.mAttachment != null;
            hasColorResolveAttachments |= attachmentDesc2.mResolveAttachment != null;
        }
        if (hasColorResolveAttachments) {
            resolveFramebuffer = gl.glGenFramebuffers();
            if (resolveFramebuffer == 0) {
                gl.glDeleteFramebuffers(renderFramebuffer);
                return null;
            }
        } else {
            resolveFramebuffer = renderFramebuffer;
        }
        gl.glBindFramebuffer(36160, renderFramebuffer);
        if (hasColorAttachments) {
            int[] drawBuffers = new int[numColorAttachments];
            for (index = 0; index < numColorAttachments; ++index) {
                attachmentDesc = desc.mColorAttachments[index];
                if (attachmentDesc.mAttachment == null) {
                    drawBuffers[index] = 0;
                    continue;
                }
                GLImage attachment = (GLImage)attachmentDesc.mAttachment.get();
                assert (attachment != null);
                GLFramebuffer.attachColorAttachment(gl, index, attachment, attachmentDesc.mMipLevel);
                drawBuffers[index] = 36064 + index;
            }
            gl.glDrawBuffers(drawBuffers);
        }
        if (desc.mDepthStencilAttachment.mAttachment != null) {
            int attachmentPoint;
            GLRenderbuffer attachment = (GLRenderbuffer)desc.mDepthStencilAttachment.mAttachment.get();
            assert (attachment != null);
            if (GLUtil.glFormatIsPackedDepthStencil(attachment.getFormat())) {
                attachmentPoint = 33306;
            } else if (GLUtil.glFormatDepthBits(attachment.getFormat()) > 0) {
                attachmentPoint = 36096;
            } else {
                assert (GLUtil.glFormatStencilBits(attachment.getFormat()) > 0);
                attachmentPoint = 36128;
            }
            gl.glFramebufferRenderbuffer(36160, attachmentPoint, 36161, attachment.getHandle());
        }
        if (!device.getCaps().skipErrorChecks() && (status = gl.glCheckFramebufferStatus(36160)) != 36053) {
            gl.glDeleteFramebuffers(renderFramebuffer);
            gl.glDeleteFramebuffers(resolveFramebuffer);
            return null;
        }
        if (hasColorResolveAttachments) {
            int status2;
            gl.glBindFramebuffer(36160, resolveFramebuffer);
            int[] drawBuffers = new int[numColorAttachments];
            for (index = 0; index < numColorAttachments; ++index) {
                attachmentDesc = desc.mColorAttachments[index];
                if (attachmentDesc.mResolveAttachment == null) {
                    drawBuffers[index] = 0;
                    continue;
                }
                GLImage resolveAttachment = (GLImage)attachmentDesc.mResolveAttachment.get();
                assert (resolveAttachment != null);
                GLFramebuffer.attachColorAttachment(gl, index, resolveAttachment, attachmentDesc.mMipLevel);
                drawBuffers[index] = 36064 + index;
            }
            gl.glDrawBuffers(drawBuffers);
            if (!device.getCaps().skipErrorChecks() && (status2 = gl.glCheckFramebufferStatus(36160)) != 36053) {
                gl.glDeleteFramebuffers(renderFramebuffer);
                gl.glDeleteFramebuffers(resolveFramebuffer);
                return null;
            }
        }
        return new GLFramebuffer(device, renderFramebuffer, resolveFramebuffer);
    }

    public int getRenderFramebuffer() {
        return this.mRenderFramebuffer;
    }

    public int getResolveFramebuffer() {
        return this.mResolveFramebuffer;
    }

    @Override
    protected void deallocate() {
        GLDevice device = (GLDevice)this.getDevice();
        assert (device.isOnExecutingThread());
        if (this.mRenderFramebuffer != 0) {
            device.getGL().glDeleteFramebuffers(this.mRenderFramebuffer);
        }
        if (this.mRenderFramebuffer != this.mResolveFramebuffer) {
            assert (this.mResolveFramebuffer != 0);
            device.getGL().glDeleteFramebuffers(this.mResolveFramebuffer);
        }
        this.mRenderFramebuffer = 0;
        this.mResolveFramebuffer = 0;
    }
}

