/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.opengl;

import icyllis.arc3d.core.ColorInfo;
import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.Rect2ic;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.UniqueID;
import icyllis.arc3d.engine.BlendInfo;
import icyllis.arc3d.engine.Buffer;
import icyllis.arc3d.engine.BufferImageCopyData;
import icyllis.arc3d.engine.CommandBuffer;
import icyllis.arc3d.engine.DepthStencilSettings;
import icyllis.arc3d.engine.Engine;
import icyllis.arc3d.engine.FramebufferDesc;
import icyllis.arc3d.engine.GraphicsPipeline;
import icyllis.arc3d.engine.Image;
import icyllis.arc3d.engine.QueueManager;
import icyllis.arc3d.engine.RenderPassDesc;
import icyllis.arc3d.engine.Sampler;
import icyllis.arc3d.opengl.GLBuffer;
import icyllis.arc3d.opengl.GLDevice;
import icyllis.arc3d.opengl.GLFramebuffer;
import icyllis.arc3d.opengl.GLGraphicsPipeline;
import icyllis.arc3d.opengl.GLImage;
import icyllis.arc3d.opengl.GLInterface;
import icyllis.arc3d.opengl.GLProgram;
import icyllis.arc3d.opengl.GLResourceProvider;
import icyllis.arc3d.opengl.GLSampler;
import icyllis.arc3d.opengl.GLTexture;
import icyllis.arc3d.opengl.GLTextureMutableState;
import icyllis.arc3d.opengl.GLUtil;
import icyllis.arc3d.opengl.GLVertexArray;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.lwjgl.system.MemoryStack;

public final class GLCommandBuffer
extends CommandBuffer {
    private static final int kDisabled_TriState = 0;
    private static final int kEnabled_TriState = 1;
    private static final int kUnknown_TriState = 2;
    private final GLDevice mDevice;
    private final GLResourceProvider mResourceProvider;
    private final MemoryStack mStack = MemoryStack.stackGet();
    private int mHWViewportX;
    private int mHWViewportY;
    private int mHWViewportWidth;
    private int mHWViewportHeight;
    private int mHWScissorX;
    private int mHWScissorY;
    private int mHWScissorWidth;
    private int mHWScissorHeight;
    private int mHWScissorTest;
    private int mHWColorWrite;
    private int mHWBlendState;
    private byte mHWBlendEquation;
    private byte mHWBlendSrcFactor;
    private byte mHWBlendDstFactor;
    private int mHWDepthTest;
    private int mHWDepthWrite;
    private byte mHWDepthCompareOp;
    private int mHWStencilTest;
    private DepthStencilSettings.Face mHWFrontStencil;
    private DepthStencilSettings.Face mHWBackStencil;
    @SharedPtr
    private GLFramebuffer mHWFramebuffer;
    @RawPtr
    private GLProgram mHWProgram;
    @RawPtr
    private GLVertexArray mHWVertexArray;
    private int mHWActiveTextureUnit;
    private final UniqueID[][] mHWTextureStates;
    private final UniqueID[] mHWSamplerStates;
    @RawPtr
    private GLGraphicsPipeline mGraphicsPipeline;
    private int mPrimitiveType;
    private int mIndexType;
    private long mIndexBufferOffset;
    @RawPtr
    private final GLBuffer[] mActiveVertexBuffers = new GLBuffer[32];
    private final long[] mActiveVertexOffsets = new long[32];
    private RenderPassDesc mRenderPassDesc;
    private final Rect2i mContentBounds = new Rect2i();
    private long mSubmitFence;

    GLCommandBuffer(GLDevice device, GLResourceProvider resourceProvider) {
        this.mDevice = device;
        this.mResourceProvider = resourceProvider;
        int maxTextureUnits = device.getCaps().shaderCaps().mMaxFragmentSamplers;
        this.mHWTextureStates = new UniqueID[maxTextureUnits][6];
        this.mHWSamplerStates = new UniqueID[maxTextureUnits];
        this.resetStates();
    }

    public void resetStates() {
        this.mHWFramebuffer = RefCnt.move(this.mHWFramebuffer);
        this.mHWProgram = null;
        this.mHWVertexArray = null;
        this.mHWScissorTest = 2;
        this.mHWScissorX = -1;
        this.mHWScissorY = -1;
        this.mHWScissorWidth = -1;
        this.mHWScissorHeight = -1;
        this.mHWViewportX = -1;
        this.mHWViewportY = -1;
        this.mHWViewportWidth = -1;
        this.mHWViewportHeight = -1;
        this.mHWColorWrite = 2;
        this.mHWBlendState = 2;
        this.mHWBlendEquation = (byte)-1;
        this.mHWBlendSrcFactor = (byte)-1;
        this.mHWBlendDstFactor = (byte)-1;
        this.mHWDepthTest = 2;
        this.mHWDepthWrite = 2;
        this.mHWDepthCompareOp = (byte)-1;
        this.mHWStencilTest = 2;
        this.mHWFrontStencil = null;
        this.mHWBackStencil = null;
        this.mHWActiveTextureUnit = -1;
        for (Object[] objectArray : this.mHWTextureStates) {
            Arrays.fill(objectArray, null);
        }
        Arrays.fill(this.mHWSamplerStates, null);
        Arrays.fill(this.mActiveVertexBuffers, null);
    }

    @Override
    public boolean beginRenderPass(RenderPassDesc renderPassDesc, FramebufferDesc framebufferDesc, Rect2ic renderPassBounds, float[] clearColors, float clearDepth, int clearStencil) {
        this.mDevice.flushRenderCalls();
        if ((framebufferDesc.mFramebufferFlags & 0x800) != 0) {
            this.mDevice.getGL().glBindFramebuffer(36160, 0);
            this.mHWFramebuffer = RefCnt.move(this.mHWFramebuffer);
        } else {
            @SharedPtr GLFramebuffer framebuffer = this.mDevice.findOrCreateFramebuffer(framebufferDesc);
            if (framebuffer == null) {
                return false;
            }
            if (this.mHWFramebuffer != framebuffer) {
                this.mDevice.getGL().glBindFramebuffer(36160, framebuffer.getRenderFramebuffer());
                this.mHWFramebuffer = RefCnt.move(this.mHWFramebuffer, framebuffer);
            } else {
                framebuffer.unref();
            }
        }
        this.flushScissorTest(false);
        try (MemoryStack stack = this.mStack.push();){
            boolean depthStencilLoadClear;
            FloatBuffer floatValues = stack.mallocFloat(4);
            for (int i = 0; i < renderPassDesc.mNumColorAttachments; ++i) {
                boolean colorLoadClear;
                RenderPassDesc.ColorAttachmentDesc attachmentDesc = renderPassDesc.mColorAttachments[i];
                boolean bl = colorLoadClear = attachmentDesc.mLoadOp == 1;
                if (!colorLoadClear) continue;
                this.flushColorWrite(true);
                floatValues.put(0, clearColors, i << 2, 4);
                this.mDevice.getGL().glClearBufferfv(6144, i, floatValues);
            }
            boolean bl = depthStencilLoadClear = renderPassDesc.mDepthStencilAttachment.mDesc != null && renderPassDesc.mDepthStencilAttachment.mLoadOp == 1;
            if (depthStencilLoadClear) {
                boolean hasStencil;
                boolean hasDepth = renderPassDesc.mDepthStencilAttachment.mDesc.getDepthBits() > 0;
                boolean bl2 = hasStencil = renderPassDesc.mDepthStencilAttachment.mDesc.getStencilBits() > 0;
                if (hasDepth) {
                    this.flushDepthWrite(true);
                }
                if (hasStencil) {
                    this.mDevice.getGL().glStencilMask(-1);
                    this.mHWFrontStencil = null;
                    this.mHWBackStencil = null;
                }
                if (hasDepth && hasStencil) {
                    this.mDevice.getGL().glClearBufferfi(34041, 0, clearDepth, clearStencil);
                } else if (hasDepth) {
                    floatValues.put(0, clearDepth).limit(1);
                    this.mDevice.getGL().glClearBufferfv(6145, 0, floatValues);
                } else if (hasStencil) {
                    IntBuffer intValues = stack.ints(clearStencil);
                    this.mDevice.getGL().glClearBufferiv(6146, 0, intValues);
                }
            }
        }
        this.mRenderPassDesc = renderPassDesc;
        this.mContentBounds.set(renderPassBounds);
        return true;
    }

    @Override
    public void endRenderPass() {
        Arrays.fill(this.mActiveVertexBuffers, null);
        this.flushScissorTest(false);
        GLFramebuffer framebuffer = this.mHWFramebuffer;
        if (framebuffer != null && framebuffer.getRenderFramebuffer() != framebuffer.getResolveFramebuffer()) {
            this.mDevice.getGL().glBindFramebuffer(36009, framebuffer.getResolveFramebuffer());
            Rect2i b = this.mContentBounds;
            this.mDevice.getGL().glBlitFramebuffer(b.mLeft, b.mTop, b.mRight, b.mBottom, b.mLeft, b.mTop, b.mRight, b.mBottom, 16384, 9728);
        }
        if (this.mDevice.getCaps().hasInvalidateFramebufferSupport()) {
            RenderPassDesc renderPassDesc = this.mRenderPassDesc;
            try (MemoryStack stack = this.mStack.push();){
                boolean depthStencilStoreDiscard;
                IntBuffer attachmentsToDiscard = stack.mallocInt(renderPassDesc.mNumColorAttachments + 1);
                for (int i = 0; i < renderPassDesc.mNumColorAttachments; ++i) {
                    boolean colorLoadClear;
                    RenderPassDesc.ColorAttachmentDesc attachmentDesc = renderPassDesc.mColorAttachments[i];
                    boolean bl = colorLoadClear = attachmentDesc.mStoreOp == 1;
                    if (!colorLoadClear) continue;
                    attachmentsToDiscard.put(framebuffer == null ? 6144 : 36064 + i);
                }
                boolean bl = depthStencilStoreDiscard = renderPassDesc.mDepthStencilAttachment.mDesc != null && renderPassDesc.mDepthStencilAttachment.mStoreOp == 1;
                if (depthStencilStoreDiscard) {
                    boolean hasStencil;
                    boolean hasDepth = renderPassDesc.mDepthStencilAttachment.mDesc.getDepthBits() > 0;
                    boolean bl2 = hasStencil = renderPassDesc.mDepthStencilAttachment.mDesc.getStencilBits() > 0;
                    if (hasDepth && hasStencil) {
                        attachmentsToDiscard.put(framebuffer == null ? 34041 : 33306);
                    } else if (hasDepth) {
                        attachmentsToDiscard.put(framebuffer == null ? 6145 : 36096);
                    } else if (hasStencil) {
                        attachmentsToDiscard.put(framebuffer == null ? 6146 : 36128);
                    }
                }
                attachmentsToDiscard.flip();
                if (attachmentsToDiscard.hasRemaining()) {
                    this.mDevice.getGL().glInvalidateFramebuffer(36008, attachmentsToDiscard);
                }
            }
        }
        this.mHWFramebuffer = RefCnt.move(framebuffer);
        this.mRenderPassDesc = null;
    }

    @Override
    protected boolean onCopyBuffer(@RawPtr Buffer srcBuffer, @RawPtr Buffer dstBuffer, long srcOffset, long dstOffset, long size) {
        assert (!srcBuffer.isMapped());
        assert (!dstBuffer.isMapped());
        GLBuffer glSrc = (GLBuffer)srcBuffer;
        GLBuffer glDst = (GLBuffer)dstBuffer;
        long clientBufferPtr = glSrc.getClientUploadBuffer();
        if (glSrc.getHandle() == 0 && clientBufferPtr == 0L) {
            return false;
        }
        if (glDst.getHandle() == 0 || glDst.getClientUploadBuffer() != 0L) {
            return false;
        }
        assert (glSrc.getHandle() == 0 || clientBufferPtr == 0L);
        if (clientBufferPtr != 0L) {
            if (this.mDevice.getCaps().hasDSASupport()) {
                this.mDevice.getGL().glNamedBufferSubData(glDst.getHandle(), dstOffset, size, clientBufferPtr + srcOffset);
            } else {
                int target = glDst.getTarget();
                this.mDevice.getGL().glBindBuffer(target, glDst.getHandle());
                this.mDevice.getGL().glBufferSubData(target, dstOffset, size, clientBufferPtr + srcOffset);
            }
        } else if (this.mDevice.getCaps().hasDSASupport()) {
            this.mDevice.getGL().glCopyNamedBufferSubData(glSrc.getHandle(), glDst.getHandle(), srcOffset, dstOffset, size);
        } else {
            this.mDevice.getGL().glBindBuffer(36662, glSrc.getHandle());
            this.mDevice.getGL().glBindBuffer(36663, glDst.getHandle());
            this.mDevice.getGL().glCopyBufferSubData(36662, 36663, srcOffset, dstOffset, size);
        }
        return true;
    }

    @Override
    protected boolean onCopyBufferToImage(@RawPtr Buffer srcBuffer, @RawPtr Image dstImage, int srcColorType, int dstColorType, BufferImageCopyData[] copyData) {
        int maxLevel;
        GLBuffer glBuffer = (GLBuffer)srcBuffer;
        GLTexture glTexture = (GLTexture)dstImage;
        long clientBufferPtr = glBuffer.getClientUploadBuffer();
        if (glBuffer.getHandle() == 0 && clientBufferPtr == 0L) {
            return false;
        }
        assert (glBuffer.getHandle() == 0 || clientBufferPtr == 0L);
        int glFormat = glTexture.getFormat();
        int srcFormat = this.mDevice.getCaps().getPixelsExternalFormat(glFormat, dstColorType, srcColorType, true);
        if (srcFormat == 0) {
            return false;
        }
        int srcType = this.mDevice.getCaps().getPixelsExternalType(glFormat, dstColorType, srcColorType);
        if (srcType == 0) {
            return false;
        }
        GLInterface gl = this.mDevice.getGL();
        boolean dsa = this.mDevice.getCaps().hasDSASupport();
        int target = glTexture.getTarget();
        int handle = glTexture.getHandle();
        int boundTexture = 0;
        if (!dsa && handle != (boundTexture = gl.glGetInteger(32873))) {
            gl.glBindTexture(target, handle);
        }
        GLTextureMutableState mutableState = glTexture.getGLMutableState();
        if (mutableState.mBaseMipmapLevel != 0) {
            if (dsa) {
                gl.glTextureParameteri(handle, 33084, 0);
            } else {
                gl.glTexParameteri(target, 33084, 0);
            }
            mutableState.mBaseMipmapLevel = 0;
        }
        if (mutableState.mMaxMipmapLevel != (maxLevel = glTexture.getMipLevelCount() - 1)) {
            if (dsa) {
                gl.glTextureParameteri(handle, 33085, maxLevel);
            } else {
                gl.glTexParameteri(target, 33085, maxLevel);
            }
            mutableState.mMaxMipmapLevel = maxLevel;
        }
        gl.glPixelStorei(3315, 0);
        gl.glPixelStorei(3316, 0);
        gl.glPixelStorei(3317, 1);
        int bpp = ColorInfo.bytesPerPixel(srcColorType);
        assert ((glBuffer.getUsage() & 8) != 0);
        gl.glBindBuffer(35052, glBuffer.getHandle());
        for (BufferImageCopyData data : copyData) {
            long trimRowBytes = (long)data.mWidth * (long)bpp;
            if (data.mBufferRowBytes != trimRowBytes) {
                int rowLength = (int)(data.mBufferRowBytes / (long)bpp);
                gl.glPixelStorei(3314, rowLength);
            } else {
                gl.glPixelStorei(3314, 0);
            }
            if (dsa) {
                gl.glTextureSubImage2D(handle, data.mMipLevel, data.mX, data.mY, data.mWidth, data.mHeight, srcFormat, srcType, clientBufferPtr + data.mBufferOffset);
                continue;
            }
            gl.glTexSubImage2D(target, data.mMipLevel, data.mX, data.mY, data.mWidth, data.mHeight, srcFormat, srcType, clientBufferPtr + data.mBufferOffset);
        }
        gl.glBindBuffer(35052, 0);
        if (!dsa && handle != boundTexture) {
            gl.glBindTexture(target, boundTexture);
        }
        return true;
    }

    @Override
    protected boolean onCopyImage(@RawPtr Image srcImage, int srcL, int srcT, int srcR, int srcB, @RawPtr Image dstImage, int dstX, int dstY, int mipLevel) {
        GLImage glSrc = (GLImage)srcImage;
        GLImage glDst = (GLImage)dstImage;
        return this.mDevice.copyImage(glSrc, srcL, srcT, srcR, srcB, glDst, dstX, dstY, mipLevel);
    }

    public void flushScissorTest(boolean enable) {
        if (enable) {
            if (this.mHWScissorTest != 1) {
                this.mDevice.getGL().glEnable(3089);
                this.mHWScissorTest = 1;
            }
        } else if (this.mHWScissorTest != 0) {
            this.mDevice.getGL().glDisable(3089);
            this.mHWScissorTest = 0;
        }
    }

    public void flushColorWrite(boolean enable) {
        if (enable) {
            if (this.mHWColorWrite != 1) {
                this.mDevice.getGL().glColorMask(true, true, true, true);
                this.mHWColorWrite = 1;
            }
        } else if (this.mHWColorWrite != 0) {
            this.mDevice.getGL().glColorMask(false, false, false, false);
            this.mHWColorWrite = 0;
        }
    }

    public void flushDepthWrite(boolean enable) {
        if (enable) {
            if (this.mHWDepthWrite != 1) {
                this.mDevice.getGL().glDepthMask(true);
                this.mHWDepthWrite = 1;
            }
        } else if (this.mHWDepthWrite != 0) {
            this.mDevice.getGL().glDepthMask(false);
            this.mHWDepthWrite = 0;
        }
    }

    @Override
    public boolean bindGraphicsPipeline(@RawPtr GraphicsPipeline graphicsPipeline) {
        boolean blendOff;
        Arrays.fill(this.mActiveVertexBuffers, null);
        this.mGraphicsPipeline = (GLGraphicsPipeline)graphicsPipeline;
        @RawPtr GLProgram program = this.mGraphicsPipeline.getProgram();
        if (program == null) {
            return false;
        }
        if (this.mHWProgram != program) {
            this.mDevice.getGL().glUseProgram(program.getProgram());
            this.mHWProgram = program;
        }
        @RawPtr GLVertexArray vertexArray = this.mGraphicsPipeline.getVertexArray();
        assert (vertexArray != null);
        if (this.mHWVertexArray != vertexArray) {
            this.mDevice.getGL().glBindVertexArray(vertexArray.getHandle());
            this.mHWVertexArray = vertexArray;
        }
        this.mPrimitiveType = GLUtil.toGLPrimitiveType(this.mGraphicsPipeline.getPrimitiveType());
        BlendInfo blendInfo = this.mGraphicsPipeline.getBlendInfo();
        boolean bl = blendOff = blendInfo.blendShouldDisable() || !blendInfo.mColorWrite;
        if (blendOff) {
            if (this.mHWBlendState != 0) {
                this.mDevice.getGL().glDisable(3042);
                this.mHWBlendState = 0;
            }
        } else if (this.mHWBlendState != 1) {
            this.mDevice.getGL().glEnable(3042);
            this.mHWBlendState = 1;
        }
        if (this.mHWBlendEquation != blendInfo.mEquation) {
            this.mDevice.getGL().glBlendEquation(GLUtil.toGLBlendEquation(blendInfo.mEquation));
            this.mHWBlendEquation = blendInfo.mEquation;
        }
        if (this.mHWBlendSrcFactor != blendInfo.mSrcFactor || this.mHWBlendDstFactor != blendInfo.mDstFactor) {
            this.mDevice.getGL().glBlendFunc(GLUtil.toGLBlendFactor(blendInfo.mSrcFactor), GLUtil.toGLBlendFactor(blendInfo.mDstFactor));
            this.mHWBlendSrcFactor = blendInfo.mSrcFactor;
            this.mHWBlendDstFactor = blendInfo.mDstFactor;
        }
        this.flushColorWrite(blendInfo.mColorWrite);
        DepthStencilSettings ds = this.mGraphicsPipeline.getDepthStencilSettings();
        if (ds.mDepthTest) {
            if (this.mHWDepthTest != 1) {
                this.mDevice.getGL().glEnable(2929);
                this.mHWDepthTest = 1;
            }
        } else if (this.mHWDepthTest != 0) {
            this.mDevice.getGL().glDisable(2929);
            this.mHWDepthTest = 0;
        }
        this.flushDepthWrite(ds.mDepthWrite);
        if (ds.mDepthCompareOp != this.mHWDepthCompareOp) {
            this.mDevice.getGL().glDepthFunc(GLUtil.toGLCompareFunc(ds.mDepthCompareOp));
            this.mHWDepthCompareOp = ds.mDepthCompareOp;
        }
        if (ds.mStencilTest) {
            if (this.mHWStencilTest != 1) {
                this.mDevice.getGL().glEnable(2960);
                this.mHWStencilTest = 1;
            }
            if (!Objects.equals(this.mHWFrontStencil, ds.mFrontFace) || !Objects.equals(this.mHWBackStencil, ds.mBackFace)) {
                if (ds.isTwoSided()) {
                    GLCommandBuffer.setup_gl_stencil_state(this.mDevice.getGL(), ds.mFrontFace, 1028);
                    GLCommandBuffer.setup_gl_stencil_state(this.mDevice.getGL(), ds.mBackFace, 1029);
                } else {
                    GLCommandBuffer.setup_gl_stencil_state(this.mDevice.getGL(), ds.mFrontFace, 1032);
                }
                this.mHWFrontStencil = ds.mFrontFace;
                this.mHWBackStencil = ds.mBackFace;
            }
        } else if (this.mHWStencilTest != 0) {
            this.mDevice.getGL().glDisable(2960);
            this.mHWStencilTest = 0;
        }
        return true;
    }

    private static void setup_gl_stencil_state(GLInterface gl, DepthStencilSettings.Face face, int glFace) {
        int glFailOp = GLUtil.toGLStencilOp(face.mFailOp);
        int glPassOp = GLUtil.toGLStencilOp(face.mPassOp);
        int glDepthFailOp = GLUtil.toGLStencilOp(face.mDepthFailOp);
        int glFunc = GLUtil.toGLCompareFunc(face.mCompareOp);
        if (glFace == 1032) {
            gl.glStencilOp(glFailOp, glDepthFailOp, glPassOp);
            gl.glStencilFunc(glFunc, face.mReference, face.mCompareMask);
            gl.glStencilMask(face.mWriteMask);
        } else {
            gl.glStencilOpSeparate(glFace, glFailOp, glDepthFailOp, glPassOp);
            gl.glStencilFuncSeparate(glFace, glFunc, face.mReference, face.mCompareMask);
            gl.glStencilMaskSeparate(glFace, face.mWriteMask);
        }
    }

    @Override
    public void setViewport(int x, int y, int width, int height) {
        assert (width >= 0 && height >= 0);
        if (x != this.mHWViewportX || y != this.mHWViewportY || width != this.mHWViewportWidth || height != this.mHWViewportHeight) {
            this.mDevice.getGL().glViewport(x, y, width, height);
            this.mHWViewportX = x;
            this.mHWViewportY = y;
            this.mHWViewportWidth = width;
            this.mHWViewportHeight = height;
        }
    }

    @Override
    public void setScissor(int x, int y, int width, int height) {
        this.flushScissorTest(true);
        if (x != this.mHWScissorX || y != this.mHWScissorY || width != this.mHWScissorWidth || height != this.mHWScissorHeight) {
            this.mDevice.getGL().glScissor(x, y, width, height);
            this.mHWScissorX = x;
            this.mHWScissorY = y;
            this.mHWScissorWidth = width;
            this.mHWScissorHeight = height;
        }
    }

    @Override
    public void bindIndexBuffer(int indexType, @RawPtr Buffer buffer, long offset) {
        assert (this.mGraphicsPipeline != null);
        this.mIndexType = switch (indexType) {
            case 0 -> 5121;
            case 1 -> 5123;
            case 2 -> 5125;
            default -> throw new AssertionError();
        };
        this.mGraphicsPipeline.bindIndexBuffer((GLBuffer)buffer);
        this.mIndexBufferOffset = offset;
    }

    @Override
    public void bindVertexBuffer(int binding, @RawPtr Buffer buffer, long offset) {
        assert (this.mGraphicsPipeline != null);
        GLBuffer glBuffer = (GLBuffer)buffer;
        if (this.mDevice.getCaps().hasBaseInstanceSupport()) {
            this.mGraphicsPipeline.bindVertexBuffer(binding, glBuffer, offset);
        } else {
            if (this.mGraphicsPipeline.getVertexInputRate(binding) == 0) {
                this.mGraphicsPipeline.bindVertexBuffer(binding, glBuffer, offset);
            }
            this.mActiveVertexBuffers[binding] = glBuffer;
            this.mActiveVertexOffsets[binding] = offset;
        }
    }

    @Override
    public void bindUniformBuffer(int binding, @RawPtr Buffer buffer, long offset, long size) {
        assert (this.mGraphicsPipeline != null);
        GLBuffer glBuffer = (GLBuffer)buffer;
        this.mDevice.getGL().glBindBufferRange(35345, binding, glBuffer.getHandle(), offset, size);
    }

    @Override
    public void bindTextureSampler(int binding, @RawPtr Image texture, @RawPtr Sampler sampler, short swizzle) {
        int maxLevel;
        assert (texture != null && texture.isSampledImage());
        GLTexture glTexture = (GLTexture)texture;
        GLSampler glSampler = (GLSampler)sampler;
        boolean dsa = this.mDevice.getCaps().hasDSASupport();
        int target = glTexture.getTarget();
        int handle = glTexture.getHandle();
        int imageType = glTexture.getImageType();
        if (this.mHWTextureStates[binding][imageType] != glTexture.getUniqueID()) {
            if (dsa) {
                this.mDevice.getGL().glBindTextureUnit(binding, handle);
            } else {
                this.setTextureUnit(binding);
                this.mDevice.getGL().glBindTexture(target, handle);
            }
            this.mHWTextureStates[binding][imageType] = glTexture.getUniqueID();
        }
        if (this.mHWSamplerStates[binding] != glSampler.getUniqueID()) {
            this.mDevice.getGL().glBindSampler(binding, glSampler.getHandle());
            this.mHWSamplerStates[binding] = glSampler.getUniqueID();
        }
        GLTextureMutableState mutableState = glTexture.getGLMutableState();
        if (mutableState.mBaseMipmapLevel != 0) {
            if (dsa) {
                this.mDevice.getGL().glTextureParameteri(handle, 33084, 0);
            } else {
                this.mDevice.getGL().glTexParameteri(target, 33084, 0);
            }
            mutableState.mBaseMipmapLevel = 0;
        }
        if (mutableState.mMaxMipmapLevel != (maxLevel = glTexture.getMipLevelCount() - 1)) {
            if (dsa) {
                this.mDevice.getGL().glTextureParameteri(handle, 33085, maxLevel);
            } else {
                this.mDevice.getGL().glTexParameteri(target, 33085, maxLevel);
            }
            mutableState.mMaxMipmapLevel = maxLevel;
        }
        if (mutableState.mSwizzle != swizzle) {
            for (int i = 0; i < 4; ++i) {
                int swiz = switch (swizzle >> (i << 2) & 0xF) {
                    case 0 -> 6403;
                    case 1 -> 6404;
                    case 2 -> 6405;
                    case 3 -> 6406;
                    case 4 -> 0;
                    case 5 -> 1;
                    default -> throw new AssertionError(swizzle);
                };
                int channel = 36418 + i;
                if (dsa) {
                    this.mDevice.getGL().glTextureParameteri(handle, channel, swiz);
                    continue;
                }
                this.mDevice.getGL().glTexParameteri(target, channel, swiz);
            }
            mutableState.mSwizzle = swizzle;
        }
    }

    private void setTextureUnit(int unit) {
        assert (unit >= 0 && unit < this.mHWTextureStates.length);
        if (unit != this.mHWActiveTextureUnit) {
            this.mDevice.getGL().glActiveTexture(33984 + unit);
            this.mHWActiveTextureUnit = unit;
        }
    }

    private long getIndexOffset(int baseIndex) {
        int indexSize = Engine.IndexType.size(this.mIndexType);
        return (long)baseIndex * (long)indexSize + this.mIndexBufferOffset;
    }

    @Override
    public void draw(int vertexCount, int baseVertex) {
        this.mDevice.getGL().glDrawArrays(this.mPrimitiveType, baseVertex, vertexCount);
    }

    @Override
    public void drawIndexed(int indexCount, int baseIndex, int baseVertex) {
        long indicesOffset = this.getIndexOffset(baseIndex);
        if (this.mDevice.getCaps().hasBaseInstanceSupport()) {
            this.mDevice.getGL().glDrawElementsInstancedBaseVertexBaseInstance(this.mPrimitiveType, indexCount, this.mIndexType, indicesOffset, 1, baseVertex, 0);
        } else if (this.mDevice.getCaps().hasDrawElementsBaseVertexSupport()) {
            this.mDevice.getGL().glDrawElementsBaseVertex(this.mPrimitiveType, indexCount, this.mIndexType, indicesOffset, baseVertex);
        } else {
            int bindings = this.mGraphicsPipeline.getVertexBindingCount();
            for (int i = 0; i < bindings; ++i) {
                assert (this.mGraphicsPipeline.getVertexInputRate(i) == 0);
                long vertexOffset = (long)baseVertex * (long)this.mGraphicsPipeline.getVertexStride(i) + this.mActiveVertexOffsets[i];
                this.mGraphicsPipeline.bindVertexBuffer(i, this.mActiveVertexBuffers[i], vertexOffset);
            }
            this.mDevice.getGL().glDrawElements(this.mPrimitiveType, indexCount, this.mIndexType, indicesOffset);
        }
    }

    @Override
    public void drawInstanced(int instanceCount, int baseInstance, int vertexCount, int baseVertex) {
        if (this.mDevice.getCaps().hasBaseInstanceSupport()) {
            this.mDevice.getGL().glDrawArraysInstancedBaseInstance(this.mPrimitiveType, baseVertex, vertexCount, instanceCount, baseInstance);
        } else {
            int bindings = this.mGraphicsPipeline.getVertexBindingCount();
            for (int i = 0; i < bindings; ++i) {
                if (this.mGraphicsPipeline.getVertexInputRate(i) <= 0) continue;
                long instanceOffset = (long)baseInstance * (long)this.mGraphicsPipeline.getVertexStride(i) + this.mActiveVertexOffsets[i];
                this.mGraphicsPipeline.bindVertexBuffer(i, this.mActiveVertexBuffers[i], instanceOffset);
            }
            this.mDevice.getGL().glDrawArraysInstanced(this.mPrimitiveType, baseVertex, vertexCount, instanceCount);
        }
    }

    @Override
    public void drawIndexedInstanced(int indexCount, int baseIndex, int instanceCount, int baseInstance, int baseVertex) {
        long indicesOffset = this.getIndexOffset(baseIndex);
        if (this.mDevice.getCaps().hasBaseInstanceSupport()) {
            this.mDevice.getGL().glDrawElementsInstancedBaseVertexBaseInstance(this.mPrimitiveType, indexCount, this.mIndexType, indicesOffset, instanceCount, baseVertex, baseInstance);
        } else {
            boolean hasBaseVertexSupport = this.mDevice.getCaps().hasDrawElementsBaseVertexSupport();
            int bindings = this.mGraphicsPipeline.getVertexBindingCount();
            for (int i = 0; i < bindings; ++i) {
                if (this.mGraphicsPipeline.getVertexInputRate(i) > 0) {
                    long instanceOffset = (long)baseInstance * (long)this.mGraphicsPipeline.getVertexStride(i) + this.mActiveVertexOffsets[i];
                    this.mGraphicsPipeline.bindVertexBuffer(i, this.mActiveVertexBuffers[i], instanceOffset);
                    continue;
                }
                if (hasBaseVertexSupport) continue;
                long vertexOffset = (long)baseVertex * (long)this.mGraphicsPipeline.getVertexStride(i) + this.mActiveVertexOffsets[i];
                this.mGraphicsPipeline.bindVertexBuffer(i, this.mActiveVertexBuffers[i], vertexOffset);
            }
            if (hasBaseVertexSupport) {
                this.mDevice.getGL().glDrawElementsInstancedBaseVertex(this.mPrimitiveType, indexCount, this.mIndexType, indicesOffset, instanceCount, baseVertex);
            } else {
                this.mDevice.getGL().glDrawElementsInstanced(this.mPrimitiveType, indexCount, this.mIndexType, indicesOffset, instanceCount);
            }
        }
    }

    @Override
    protected void begin() {
        this.mDevice.purgeStaleResources();
        this.mDevice.flushRenderCalls();
        GLInterface gl = this.mDevice.getGL();
        gl.glDisable(2848);
        gl.glDisable(2881);
        gl.glDisable(3024);
        gl.glEnable(32925);
        gl.glDisable(3058);
        gl.glDisable(32823);
        gl.glDisable(2884);
        gl.glFrontFace(2305);
        gl.glLineWidth(1.0f);
        gl.glDisable(34370);
    }

    @Override
    protected boolean submit(QueueManager queueManager) {
        this.mDevice.purgeStaleResources();
        this.resetStates();
        this.mSubmitFence = this.mDevice.getGL().glFenceSync(37143, 0);
        this.mDevice.getGL().glFlush();
        if (!this.mDevice.getCaps().skipErrorChecks()) {
            this.mDevice.clearErrors();
        }
        return true;
    }

    @Override
    protected boolean checkFinishedAndReset() {
        if (this.mSubmitFence == 0L) {
            return true;
        }
        int status = this.mDevice.getGL().glClientWaitSync(this.mSubmitFence, 0, 0L);
        if (status == 37148 || status == 37146) {
            this.mDevice.getGL().glDeleteSync(this.mSubmitFence);
            this.mSubmitFence = 0L;
            this.callFinishedCallbacks(true);
            this.releaseResources();
            return true;
        }
        return false;
    }

    @Override
    protected void waitUntilFinished() {
        this.mDevice.getGL().glFinish();
    }
}

