/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite.shading;

import icyllis.arc3d.core.SLDataType;
import icyllis.arc3d.engine.ShaderVar;
import icyllis.arc3d.engine.VertexInputLayout;
import icyllis.arc3d.granite.GeometryStep;
import icyllis.arc3d.granite.shading.GraphicsPipelineBuilder;
import icyllis.arc3d.granite.shading.ShaderBuilderBase;
import icyllis.arc3d.granite.shading.VertexGeomBuilder;
import java.util.ArrayList;
import java.util.Iterator;

public class VertexShaderBuilder
extends ShaderBuilderBase
implements VertexGeomBuilder {
    private final ArrayList<ShaderVar> mInputs = new ArrayList();

    public VertexShaderBuilder(GraphicsPipelineBuilder pipelineBuilder) {
        super(pipelineBuilder);
    }

    @Override
    protected void onFinish() {
        int locationIndex = 0;
        for (ShaderVar var : this.mInputs) {
            var.addLayoutQualifier("location", locationIndex);
            int locations = SLDataType.locations(var.getType());
            assert (locations > 0);
            assert (!var.isArray());
            locationIndex += locations;
        }
        this.mPipelineBuilder.uniformHandler().appendUniformDecls(1, 0, "UniformBlock", this.uniforms());
        this.mPipelineBuilder.appendDecls(this.mInputs, this.inputs());
        this.mPipelineBuilder.varyingHandler().getVertDecls(this.outputs());
    }

    @Override
    public void emitAttributes(GeometryStep geomProc) {
        VertexInputLayout inputLayout = geomProc.getInputLayout();
        for (int i = 0; i < inputLayout.getBindingCount(); ++i) {
            Iterator<VertexInputLayout.Attribute> attrs = inputLayout.getAttributes(i);
            while (attrs.hasNext()) {
                VertexInputLayout.Attribute attr2 = attrs.next();
                ShaderVar var = attr2.asShaderVar();
                assert (var.getTypeModifier() == 2);
                this.mInputs.add(var);
            }
        }
    }

    @Override
    public void emitNormalizedPosition(ShaderVar devicePos) {
        if (devicePos.getType() == 15) {
            this.codeAppendf("gl_Position = vec4(%1$s.xy * %2$s.xz + %1$s.zz * %2$s.yw, 0.0, %1$s.z);\n", devicePos.getName(), "SV_Projection");
        } else {
            assert (devicePos.getType() == 14);
            this.codeAppendf("gl_Position = vec4(%1$s.xy * %2$s.xz + %2$s.yw, 0.0, 1.0);\n", devicePos.getName(), "SV_Projection");
        }
    }
}

