/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite.geom;

import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.granite.geom.BoundsManager;
import icyllis.arc3d.granite.geom.FullBoundsManager;
import icyllis.arc3d.granite.geom.GridBoundsManager;

public final class HybridBoundsManager
extends BoundsManager {
    private final int mDeviceWidth;
    private final int mDeviceHeight;
    private final int mGridCellSize;
    private final int mMaxBruteForceN;
    private final int mMaxGridSize;
    private BoundsManager mCurrentManager;
    private final FullBoundsManager mFullManager;
    private GridBoundsManager mGridManager;

    public HybridBoundsManager(int deviceWidth, int deviceHeight, int gridCellSize, int maxBruteForceN, int maxGridSize) {
        assert (deviceWidth >= 1 && deviceHeight >= 1 && gridCellSize >= 1 && maxBruteForceN >= 1);
        this.mDeviceWidth = deviceWidth;
        this.mDeviceHeight = deviceHeight;
        this.mGridCellSize = gridCellSize;
        this.mMaxBruteForceN = maxBruteForceN;
        this.mMaxGridSize = maxGridSize;
        this.mFullManager = new FullBoundsManager(maxBruteForceN);
        this.mCurrentManager = this.mFullManager;
    }

    @Override
    public int getMostRecentDraw(Rect2fc bounds) {
        return this.mCurrentManager.getMostRecentDraw(bounds);
    }

    @Override
    public void recordDraw(Rect2fc bounds, int order) {
        if (this.mCurrentManager == this.mFullManager && this.mFullManager.count() >= this.mMaxBruteForceN) {
            if (this.mGridManager == null) {
                this.mGridManager = GridBoundsManager.makeRes(this.mDeviceWidth, this.mDeviceHeight, this.mGridCellSize, this.mMaxGridSize);
            }
            this.mCurrentManager = this.mGridManager;
            this.mFullManager.transferTo(this.mCurrentManager);
            assert (this.mFullManager.count() == 0);
        }
        this.mCurrentManager.recordDraw(bounds, order);
    }

    @Override
    public void clear() {
        if (this.mCurrentManager == this.mGridManager) {
            this.mGridManager.clear();
            this.mCurrentManager = this.mFullManager;
        } else {
            assert (this.mCurrentManager == this.mFullManager);
            this.mFullManager.clear();
        }
    }
}

