/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.BlendMode;
import icyllis.arc3d.engine.BlendInfo;
import icyllis.arc3d.engine.DepthStencilSettings;
import icyllis.arc3d.engine.Device;
import icyllis.arc3d.engine.Key;
import icyllis.arc3d.engine.KeyBuilder;
import icyllis.arc3d.engine.PipelineDesc;
import icyllis.arc3d.granite.FragmentNode;
import icyllis.arc3d.granite.FragmentStage;
import icyllis.arc3d.granite.GeometryStep;
import icyllis.arc3d.granite.PipelineBuilder;
import icyllis.arc3d.granite.ShaderCodeSource;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class GraphicsPipelineDesc
extends PipelineDesc {
    private GeometryStep mGeometryStep;
    private Key mPaintParamsKey;
    @Nullable
    private BlendMode mFinalBlendMode;
    private boolean mUseFastSolidColor;

    public GraphicsPipelineDesc() {
    }

    public GraphicsPipelineDesc(GeometryStep geometryStep, Key paintParamsKey, @Nullable BlendMode finalBlendMode, boolean useFastSolidColor) {
        this.mGeometryStep = geometryStep;
        this.mPaintParamsKey = paintParamsKey;
        this.mFinalBlendMode = finalBlendMode;
        this.mUseFastSolidColor = useFastSolidColor;
    }

    public GraphicsPipelineDesc set(GeometryStep geometryStep, KeyBuilder paintParamsKey, @Nullable BlendMode finalBlendMode, boolean useFastSolidColor) {
        this.mGeometryStep = geometryStep;
        this.mPaintParamsKey = paintParamsKey;
        this.mFinalBlendMode = finalBlendMode;
        this.mUseFastSolidColor = useFastSolidColor;
        return this;
    }

    public GeometryStep geomStep() {
        return this.mGeometryStep;
    }

    public Key getPaintParamsKey() {
        return this.mPaintParamsKey;
    }

    @Nullable
    public BlendMode getFinalBlendMode() {
        return this.mFinalBlendMode;
    }

    public boolean usesFastSolidColor() {
        return this.mUseFastSolidColor;
    }

    public boolean mayRequireLocalCoords() {
        return !this.mUseFastSolidColor && (this.mPaintParamsKey.size() != 1 || this.mPaintParamsKey.get(0) != 2);
    }

    private FragmentNode createNode(ShaderCodeSource codeSource, StringBuilder label, int[] currentStageIndex) {
        FragmentNode[] children;
        assert (currentStageIndex[0] < this.mPaintParamsKey.size());
        int n = currentStageIndex[0];
        currentStageIndex[0] = n + 1;
        int index = n;
        int id2 = this.mPaintParamsKey.get(index);
        FragmentStage stage = codeSource.findStage(id2);
        if (stage == null) {
            return null;
        }
        String name = stage.name();
        if (name.endsWith("Shader")) {
            label.append(name, 0, name.length() - 6);
        } else {
            label.append(name);
        }
        if (stage.mNumChildren > 0) {
            children = new FragmentNode[stage.mNumChildren];
            label.append(" [ ");
            for (int i = 0; i < stage.mNumChildren; ++i) {
                FragmentNode child = this.createNode(codeSource, label, currentStageIndex);
                if (child == null) {
                    return null;
                }
                children[i] = child;
            }
            label.append("]");
        } else {
            children = FragmentNode.NO_CHILDREN;
        }
        label.append(" ");
        return new FragmentNode(stage, children, id2, index);
    }

    public FragmentNode[] getRootNodes(ShaderCodeSource codeSource, StringBuilder label) {
        int keySize = this.mPaintParamsKey.size();
        ObjectArrayList roots = new ObjectArrayList(7);
        int[] currentIndex = new int[]{0};
        while (currentIndex[0] < keySize) {
            FragmentNode root = this.createNode(codeSource, label, currentIndex);
            if (root == null) {
                label.setLength(0);
                return FragmentNode.NO_CHILDREN;
            }
            roots.add((Object)root);
        }
        return (FragmentNode[])roots.toArray((Object[])FragmentNode.NO_CHILDREN);
    }

    public boolean isDepthOnlyPass() {
        boolean depthOnly;
        boolean bl = depthOnly = this.mPaintParamsKey.isEmpty() && !this.mUseFastSolidColor;
        assert (depthOnly == (this.mFinalBlendMode == null));
        return depthOnly;
    }

    @Override
    public PipelineDesc.GraphicsPipelineInfo createGraphicsPipelineInfo(Device device) {
        PipelineBuilder pipelineBuilder = new PipelineBuilder(device, this);
        return pipelineBuilder.build();
    }

    @Override
    public byte getPrimitiveType() {
        return this.mGeometryStep.primitiveType();
    }

    @Override
    public BlendInfo getBlendInfo() {
        if (this.mFinalBlendMode != null) {
            BlendInfo info = BlendInfo.getSimpleBlendInfo(this.mFinalBlendMode);
            return info != null ? info : BlendInfo.BLEND_SRC_OVER;
        }
        return BlendInfo.BLEND_DST;
    }

    @Override
    public DepthStencilSettings getDepthStencilSettings() {
        return this.mGeometryStep.depthStencilSettings();
    }

    @Override
    public GraphicsPipelineDesc copy() {
        Key key = this.mPaintParamsKey;
        if (key instanceof KeyBuilder) {
            KeyBuilder keyBuilder = (KeyBuilder)key;
            return new GraphicsPipelineDesc(this.mGeometryStep, keyBuilder.toStorageKey(), this.mFinalBlendMode, this.mUseFastSolidColor);
        }
        return this;
    }

    public int hashCode() {
        int result = this.mGeometryStep.uniqueID();
        result = 31 * result + this.mPaintParamsKey.hashCode();
        result = 31 * result + Objects.hashCode(this.mFinalBlendMode);
        result = 31 * result + Boolean.hashCode(this.mUseFastSolidColor);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GraphicsPipelineDesc) {
            GraphicsPipelineDesc desc = (GraphicsPipelineDesc)o;
            return this.mGeometryStep.uniqueID() == desc.mGeometryStep.uniqueID() && this.mUseFastSolidColor == desc.mUseFastSolidColor && Objects.equals(this.mPaintParamsKey, desc.mPaintParamsKey) && Objects.equals(this.mFinalBlendMode, desc.mFinalBlendMode);
        }
        return false;
    }
}

