/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.Image;
import icyllis.arc3d.core.ImageInfo;
import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.Rect2ic;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.Context;
import icyllis.arc3d.engine.ISurface;
import icyllis.arc3d.engine.ImageDesc;
import icyllis.arc3d.engine.ImageViewProxy;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.engine.task.CopyImageTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class GraniteImage
extends Image {
    @RawPtr
    RecordingContext mContext;
    @SharedPtr
    ImageViewProxy mImageViewProxy;

    public GraniteImage(@Nonnull @RawPtr RecordingContext context, @Nonnull @SharedPtr ImageViewProxy view, int colorType, int alphaType, @Nullable ColorSpace colorSpace) {
        super(ImageInfo.make(view.getWidth(), view.getHeight(), colorType, alphaType, colorSpace));
        this.mContext = context;
        this.mImageViewProxy = view;
    }

    @Nullable
    @SharedPtr
    public static GraniteImage copy(@RawPtr RecordingContext rc, @RawPtr ImageViewProxy srcView, @Nonnull ImageInfo srcInfo, @Nonnull Rect2ic subset, boolean budgeted, boolean mipmapped, boolean approxFit, @Nullable String label) {
        ImageDesc dstDesc;
        ImageViewProxy dst;
        assert (!mipmapped || !approxFit);
        if (srcView == null) {
            return null;
        }
        assert (new Rect2i(0, 0, srcInfo.width(), srcInfo.height()).contains(subset));
        int width = subset.width();
        int height = subset.height();
        if (approxFit) {
            width = ISurface.getApproxSize(width);
            height = ISurface.getApproxSize(height);
        }
        if ((dst = ImageViewProxy.make(rc, dstDesc = rc.getCaps().getImageDescForSampledCopy(srcView.getDesc(), width, height, 1, mipmapped ? 4 : 0), srcView.getOrigin(), srcView.getSwizzle(), budgeted, label)) == null) {
            return null;
        }
        @SharedPtr CopyImageTask copyTask = CopyImageTask.make(RefCnt.create(srcView), subset, RefCnt.create(dst), 0, 0, 0);
        if (copyTask == null) {
            RefCnt.move(dst);
            return null;
        }
        rc.addTask(copyTask);
        return new GraniteImage(rc, dst, srcInfo.colorType(), srcInfo.alphaType(), srcInfo.colorSpace());
    }

    @Override
    protected void deallocate() {
        this.mImageViewProxy = RefCnt.move(this.mImageViewProxy);
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @RawPtr
    public ImageViewProxy getImageViewProxy() {
        return this.mImageViewProxy;
    }

    @Override
    public boolean isTextureBacked() {
        return true;
    }

    @Override
    public long getTextureSize() {
        return this.mImageViewProxy.getMemorySize();
    }

    public String toString() {
        return "GraniteImage{mContext=" + this.mContext + ", mImageViewProxy=" + this.mImageViewProxy + "}";
    }
}

