/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.Rect2f;

public class ArcShape {
    public static final int kArc_Type = 0;
    public static final int kArcRound_Type = 1;
    public static final int kArcSquare_Type = 2;
    public static final int kPie_Type = 3;
    public static final int kChord_Type = 4;
    public static final int kTypeCount = 5;
    public float mCenterX;
    public float mCenterY;
    public float mRadius;
    public float mStartAngle;
    public float mSweepAngle;
    public float mHalfWidth;
    public int mType;

    public ArcShape() {
    }

    public ArcShape(float centerX, float centerY, float radius, float startAngle, float sweepAngle, float halfWidth) {
        this.mCenterX = centerX;
        this.mCenterY = centerY;
        this.mRadius = radius;
        this.mStartAngle = startAngle;
        this.mSweepAngle = sweepAngle;
        this.mHalfWidth = halfWidth;
    }

    public static boolean isOpenArc(int type) {
        return switch (type) {
            case 0, 1, 2 -> true;
            default -> false;
        };
    }

    public void getBounds(Rect2f dest) {
        dest.set(this.mCenterX - this.mRadius, this.mCenterY - this.mRadius, this.mCenterX + this.mRadius, this.mCenterY + this.mRadius);
        if (ArcShape.isOpenArc(this.mType)) {
            float outset = this.mType == 2 ? 1.4142135f * this.mHalfWidth : this.mHalfWidth;
            dest.outset(outset, outset);
        }
    }
}

